/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.VideoDetail;
import software.amazon.awssdk.services.mediaconvert.transform.OutputDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, OutputDetail> {
    private final Integer durationInMs;
    private final VideoDetail videoDetails;

    private OutputDetail(BuilderImpl builder) {
        this.durationInMs = builder.durationInMs;
        this.videoDetails = builder.videoDetails;
    }

    public Integer durationInMs() {
        return this.durationInMs;
    }

    public VideoDetail videoDetails() {
        return this.videoDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDetail)) {
            return false;
        }
        OutputDetail other = (OutputDetail)obj;
        return Objects.equals(this.durationInMs(), other.durationInMs()) && Objects.equals(this.videoDetails(), other.videoDetails());
    }

    public String toString() {
        return ToString.builder((String)"OutputDetail").add("DurationInMs", (Object)this.durationInMs()).add("VideoDetails", (Object)this.videoDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DurationInMs": {
                return Optional.ofNullable(clazz.cast(this.durationInMs()));
            }
            case "VideoDetails": {
                return Optional.ofNullable(clazz.cast(this.videoDetails()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer durationInMs;
        private VideoDetail videoDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDetail model) {
            this.durationInMs(model.durationInMs);
            this.videoDetails(model.videoDetails);
        }

        public final Integer getDurationInMs() {
            return this.durationInMs;
        }

        @Override
        public final Builder durationInMs(Integer durationInMs) {
            this.durationInMs = durationInMs;
            return this;
        }

        public final void setDurationInMs(Integer durationInMs) {
            this.durationInMs = durationInMs;
        }

        public final VideoDetail.Builder getVideoDetails() {
            return this.videoDetails != null ? this.videoDetails.toBuilder() : null;
        }

        @Override
        public final Builder videoDetails(VideoDetail videoDetails) {
            this.videoDetails = videoDetails;
            return this;
        }

        public final void setVideoDetails(VideoDetail.BuilderImpl videoDetails) {
            this.videoDetails = videoDetails != null ? videoDetails.build() : null;
        }

        public OutputDetail build() {
            return new OutputDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutputDetail> {
        public Builder durationInMs(Integer var1);

        public Builder videoDetails(VideoDetail var1);

        default public Builder videoDetails(Consumer<VideoDetail.Builder> videoDetails) {
            return this.videoDetails((VideoDetail)((VideoDetail.Builder)VideoDetail.builder().applyMutation(videoDetails)).build());
        }
    }
}

