/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.transform.NoiseReducerSpatialFilterSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NoiseReducerSpatialFilterSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, NoiseReducerSpatialFilterSettings> {
    private final Integer postFilterSharpenStrength;
    private final Integer speed;
    private final Integer strength;

    private NoiseReducerSpatialFilterSettings(BuilderImpl builder) {
        this.postFilterSharpenStrength = builder.postFilterSharpenStrength;
        this.speed = builder.speed;
        this.strength = builder.strength;
    }

    public Integer postFilterSharpenStrength() {
        return this.postFilterSharpenStrength;
    }

    public Integer speed() {
        return this.speed;
    }

    public Integer strength() {
        return this.strength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.postFilterSharpenStrength());
        hashCode = 31 * hashCode + Objects.hashCode(this.speed());
        hashCode = 31 * hashCode + Objects.hashCode(this.strength());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NoiseReducerSpatialFilterSettings)) {
            return false;
        }
        NoiseReducerSpatialFilterSettings other = (NoiseReducerSpatialFilterSettings)obj;
        return Objects.equals(this.postFilterSharpenStrength(), other.postFilterSharpenStrength()) && Objects.equals(this.speed(), other.speed()) && Objects.equals(this.strength(), other.strength());
    }

    public String toString() {
        return ToString.builder((String)"NoiseReducerSpatialFilterSettings").add("PostFilterSharpenStrength", (Object)this.postFilterSharpenStrength()).add("Speed", (Object)this.speed()).add("Strength", (Object)this.strength()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PostFilterSharpenStrength": {
                return Optional.ofNullable(clazz.cast(this.postFilterSharpenStrength()));
            }
            case "Speed": {
                return Optional.ofNullable(clazz.cast(this.speed()));
            }
            case "Strength": {
                return Optional.ofNullable(clazz.cast(this.strength()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NoiseReducerSpatialFilterSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer postFilterSharpenStrength;
        private Integer speed;
        private Integer strength;

        private BuilderImpl() {
        }

        private BuilderImpl(NoiseReducerSpatialFilterSettings model) {
            this.postFilterSharpenStrength(model.postFilterSharpenStrength);
            this.speed(model.speed);
            this.strength(model.strength);
        }

        public final Integer getPostFilterSharpenStrength() {
            return this.postFilterSharpenStrength;
        }

        @Override
        public final Builder postFilterSharpenStrength(Integer postFilterSharpenStrength) {
            this.postFilterSharpenStrength = postFilterSharpenStrength;
            return this;
        }

        public final void setPostFilterSharpenStrength(Integer postFilterSharpenStrength) {
            this.postFilterSharpenStrength = postFilterSharpenStrength;
        }

        public final Integer getSpeed() {
            return this.speed;
        }

        @Override
        public final Builder speed(Integer speed) {
            this.speed = speed;
            return this;
        }

        public final void setSpeed(Integer speed) {
            this.speed = speed;
        }

        public final Integer getStrength() {
            return this.strength;
        }

        @Override
        public final Builder strength(Integer strength) {
            this.strength = strength;
            return this;
        }

        public final void setStrength(Integer strength) {
            this.strength = strength;
        }

        public NoiseReducerSpatialFilterSettings build() {
            return new NoiseReducerSpatialFilterSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NoiseReducerSpatialFilterSettings> {
        public Builder postFilterSharpenStrength(Integer var1);

        public Builder speed(Integer var1);

        public Builder strength(Integer var1);
    }
}

