/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertRequest;
import software.amazon.awssdk.services.mediaconvert.model.Order;
import software.amazon.awssdk.services.mediaconvert.model.QueueListBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueuesRequest
extends MediaConvertRequest
implements ToCopyableBuilder<Builder, ListQueuesRequest> {
    private final String listBy;
    private final Integer maxResults;
    private final String nextToken;
    private final String order;

    private ListQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.listBy = builder.listBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.order = builder.order;
    }

    public QueueListBy listBy() {
        return QueueListBy.fromValue(this.listBy);
    }

    public String listByAsString() {
        return this.listBy;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Order order() {
        return Order.fromValue(this.order);
    }

    public String orderAsString() {
        return this.order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.listByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesRequest)) {
            return false;
        }
        ListQueuesRequest other = (ListQueuesRequest)((Object)obj);
        return Objects.equals(this.listByAsString(), other.listByAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.orderAsString(), other.orderAsString());
    }

    public String toString() {
        return ToString.builder((String)"ListQueuesRequest").add("ListBy", (Object)this.listByAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Order", (Object)this.orderAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListBy": {
                return Optional.ofNullable(clazz.cast(this.listByAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Order": {
                return Optional.ofNullable(clazz.cast(this.orderAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaConvertRequest.BuilderImpl
    implements Builder {
        private String listBy;
        private Integer maxResults;
        private String nextToken;
        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesRequest model) {
            super(model);
            this.listBy(model.listBy);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.order(model.order);
        }

        public final String getListBy() {
            return this.listBy;
        }

        @Override
        public final Builder listBy(String listBy) {
            this.listBy = listBy;
            return this;
        }

        @Override
        public final Builder listBy(QueueListBy listBy) {
            this.listBy(listBy.toString());
            return this;
        }

        public final void setListBy(String listBy) {
            this.listBy = listBy;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOrder() {
            return this.order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(Order order) {
            this.order(order.toString());
            return this;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListQueuesRequest build() {
            return new ListQueuesRequest(this);
        }
    }

    public static interface Builder
    extends MediaConvertRequest.Builder,
    CopyableBuilder<Builder, ListQueuesRequest> {
        public Builder listBy(String var1);

        public Builder listBy(QueueListBy var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder order(String var1);

        public Builder order(Order var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

