/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.transform.H264QvbrSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class H264QvbrSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, H264QvbrSettings> {
    private final Integer maxAverageBitrate;
    private final Integer qvbrQualityLevel;

    private H264QvbrSettings(BuilderImpl builder) {
        this.maxAverageBitrate = builder.maxAverageBitrate;
        this.qvbrQualityLevel = builder.qvbrQualityLevel;
    }

    public Integer maxAverageBitrate() {
        return this.maxAverageBitrate;
    }

    public Integer qvbrQualityLevel() {
        return this.qvbrQualityLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAverageBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.qvbrQualityLevel());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H264QvbrSettings)) {
            return false;
        }
        H264QvbrSettings other = (H264QvbrSettings)obj;
        return Objects.equals(this.maxAverageBitrate(), other.maxAverageBitrate()) && Objects.equals(this.qvbrQualityLevel(), other.qvbrQualityLevel());
    }

    public String toString() {
        return ToString.builder((String)"H264QvbrSettings").add("MaxAverageBitrate", (Object)this.maxAverageBitrate()).add("QvbrQualityLevel", (Object)this.qvbrQualityLevel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxAverageBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxAverageBitrate()));
            }
            case "QvbrQualityLevel": {
                return Optional.ofNullable(clazz.cast(this.qvbrQualityLevel()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        H264QvbrSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxAverageBitrate;
        private Integer qvbrQualityLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(H264QvbrSettings model) {
            this.maxAverageBitrate(model.maxAverageBitrate);
            this.qvbrQualityLevel(model.qvbrQualityLevel);
        }

        public final Integer getMaxAverageBitrate() {
            return this.maxAverageBitrate;
        }

        @Override
        public final Builder maxAverageBitrate(Integer maxAverageBitrate) {
            this.maxAverageBitrate = maxAverageBitrate;
            return this;
        }

        public final void setMaxAverageBitrate(Integer maxAverageBitrate) {
            this.maxAverageBitrate = maxAverageBitrate;
        }

        public final Integer getQvbrQualityLevel() {
            return this.qvbrQualityLevel;
        }

        @Override
        public final Builder qvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
            return this;
        }

        public final void setQvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
        }

        public H264QvbrSettings build() {
            return new H264QvbrSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, H264QvbrSettings> {
        public Builder maxAverageBitrate(Integer var1);

        public Builder qvbrQualityLevel(Integer var1);
    }
}

