/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.CmafClientCache;
import software.amazon.awssdk.services.mediaconvert.model.CmafCodecSpecification;
import software.amazon.awssdk.services.mediaconvert.model.CmafEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.model.CmafManifestCompression;
import software.amazon.awssdk.services.mediaconvert.model.CmafManifestDurationFormat;
import software.amazon.awssdk.services.mediaconvert.model.CmafSegmentControl;
import software.amazon.awssdk.services.mediaconvert.model.CmafStreamInfResolution;
import software.amazon.awssdk.services.mediaconvert.model.CmafWriteDASHManifest;
import software.amazon.awssdk.services.mediaconvert.model.CmafWriteHLSManifest;
import software.amazon.awssdk.services.mediaconvert.transform.CmafGroupSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CmafGroupSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, CmafGroupSettings> {
    private final String baseUrl;
    private final String clientCache;
    private final String codecSpecification;
    private final String destination;
    private final CmafEncryptionSettings encryption;
    private final Integer fragmentLength;
    private final String manifestCompression;
    private final String manifestDurationFormat;
    private final Integer minBufferTime;
    private final Double minFinalSegmentLength;
    private final String segmentControl;
    private final Integer segmentLength;
    private final String streamInfResolution;
    private final String writeDashManifest;
    private final String writeHlsManifest;

    private CmafGroupSettings(BuilderImpl builder) {
        this.baseUrl = builder.baseUrl;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.destination = builder.destination;
        this.encryption = builder.encryption;
        this.fragmentLength = builder.fragmentLength;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minBufferTime = builder.minBufferTime;
        this.minFinalSegmentLength = builder.minFinalSegmentLength;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.streamInfResolution = builder.streamInfResolution;
        this.writeDashManifest = builder.writeDashManifest;
        this.writeHlsManifest = builder.writeHlsManifest;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public CmafClientCache clientCache() {
        return CmafClientCache.fromValue(this.clientCache);
    }

    public String clientCacheAsString() {
        return this.clientCache;
    }

    public CmafCodecSpecification codecSpecification() {
        return CmafCodecSpecification.fromValue(this.codecSpecification);
    }

    public String codecSpecificationAsString() {
        return this.codecSpecification;
    }

    public String destination() {
        return this.destination;
    }

    public CmafEncryptionSettings encryption() {
        return this.encryption;
    }

    public Integer fragmentLength() {
        return this.fragmentLength;
    }

    public CmafManifestCompression manifestCompression() {
        return CmafManifestCompression.fromValue(this.manifestCompression);
    }

    public String manifestCompressionAsString() {
        return this.manifestCompression;
    }

    public CmafManifestDurationFormat manifestDurationFormat() {
        return CmafManifestDurationFormat.fromValue(this.manifestDurationFormat);
    }

    public String manifestDurationFormatAsString() {
        return this.manifestDurationFormat;
    }

    public Integer minBufferTime() {
        return this.minBufferTime;
    }

    public Double minFinalSegmentLength() {
        return this.minFinalSegmentLength;
    }

    public CmafSegmentControl segmentControl() {
        return CmafSegmentControl.fromValue(this.segmentControl);
    }

    public String segmentControlAsString() {
        return this.segmentControl;
    }

    public Integer segmentLength() {
        return this.segmentLength;
    }

    public CmafStreamInfResolution streamInfResolution() {
        return CmafStreamInfResolution.fromValue(this.streamInfResolution);
    }

    public String streamInfResolutionAsString() {
        return this.streamInfResolution;
    }

    public CmafWriteDASHManifest writeDashManifest() {
        return CmafWriteDASHManifest.fromValue(this.writeDashManifest);
    }

    public String writeDashManifestAsString() {
        return this.writeDashManifest;
    }

    public CmafWriteHLSManifest writeHlsManifest() {
        return CmafWriteHLSManifest.fromValue(this.writeHlsManifest);
    }

    public String writeHlsManifestAsString() {
        return this.writeHlsManifest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSpecificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestDurationFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBufferTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.minFinalSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamInfResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeDashManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeHlsManifestAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafGroupSettings)) {
            return false;
        }
        CmafGroupSettings other = (CmafGroupSettings)obj;
        return Objects.equals(this.baseUrl(), other.baseUrl()) && Objects.equals(this.clientCacheAsString(), other.clientCacheAsString()) && Objects.equals(this.codecSpecificationAsString(), other.codecSpecificationAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.fragmentLength(), other.fragmentLength()) && Objects.equals(this.manifestCompressionAsString(), other.manifestCompressionAsString()) && Objects.equals(this.manifestDurationFormatAsString(), other.manifestDurationFormatAsString()) && Objects.equals(this.minBufferTime(), other.minBufferTime()) && Objects.equals(this.minFinalSegmentLength(), other.minFinalSegmentLength()) && Objects.equals(this.segmentControlAsString(), other.segmentControlAsString()) && Objects.equals(this.segmentLength(), other.segmentLength()) && Objects.equals(this.streamInfResolutionAsString(), other.streamInfResolutionAsString()) && Objects.equals(this.writeDashManifestAsString(), other.writeDashManifestAsString()) && Objects.equals(this.writeHlsManifestAsString(), other.writeHlsManifestAsString());
    }

    public String toString() {
        return ToString.builder((String)"CmafGroupSettings").add("BaseUrl", (Object)this.baseUrl()).add("ClientCache", (Object)this.clientCacheAsString()).add("CodecSpecification", (Object)this.codecSpecificationAsString()).add("Destination", (Object)this.destination()).add("Encryption", (Object)this.encryption()).add("FragmentLength", (Object)this.fragmentLength()).add("ManifestCompression", (Object)this.manifestCompressionAsString()).add("ManifestDurationFormat", (Object)this.manifestDurationFormatAsString()).add("MinBufferTime", (Object)this.minBufferTime()).add("MinFinalSegmentLength", (Object)this.minFinalSegmentLength()).add("SegmentControl", (Object)this.segmentControlAsString()).add("SegmentLength", (Object)this.segmentLength()).add("StreamInfResolution", (Object)this.streamInfResolutionAsString()).add("WriteDashManifest", (Object)this.writeDashManifestAsString()).add("WriteHlsManifest", (Object)this.writeHlsManifestAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseUrl": {
                return Optional.ofNullable(clazz.cast(this.baseUrl()));
            }
            case "ClientCache": {
                return Optional.ofNullable(clazz.cast(this.clientCacheAsString()));
            }
            case "CodecSpecification": {
                return Optional.ofNullable(clazz.cast(this.codecSpecificationAsString()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "FragmentLength": {
                return Optional.ofNullable(clazz.cast(this.fragmentLength()));
            }
            case "ManifestCompression": {
                return Optional.ofNullable(clazz.cast(this.manifestCompressionAsString()));
            }
            case "ManifestDurationFormat": {
                return Optional.ofNullable(clazz.cast(this.manifestDurationFormatAsString()));
            }
            case "MinBufferTime": {
                return Optional.ofNullable(clazz.cast(this.minBufferTime()));
            }
            case "MinFinalSegmentLength": {
                return Optional.ofNullable(clazz.cast(this.minFinalSegmentLength()));
            }
            case "SegmentControl": {
                return Optional.ofNullable(clazz.cast(this.segmentControlAsString()));
            }
            case "SegmentLength": {
                return Optional.ofNullable(clazz.cast(this.segmentLength()));
            }
            case "StreamInfResolution": {
                return Optional.ofNullable(clazz.cast(this.streamInfResolutionAsString()));
            }
            case "WriteDashManifest": {
                return Optional.ofNullable(clazz.cast(this.writeDashManifestAsString()));
            }
            case "WriteHlsManifest": {
                return Optional.ofNullable(clazz.cast(this.writeHlsManifestAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CmafGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String baseUrl;
        private String clientCache;
        private String codecSpecification;
        private String destination;
        private CmafEncryptionSettings encryption;
        private Integer fragmentLength;
        private String manifestCompression;
        private String manifestDurationFormat;
        private Integer minBufferTime;
        private Double minFinalSegmentLength;
        private String segmentControl;
        private Integer segmentLength;
        private String streamInfResolution;
        private String writeDashManifest;
        private String writeHlsManifest;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafGroupSettings model) {
            this.baseUrl(model.baseUrl);
            this.clientCache(model.clientCache);
            this.codecSpecification(model.codecSpecification);
            this.destination(model.destination);
            this.encryption(model.encryption);
            this.fragmentLength(model.fragmentLength);
            this.manifestCompression(model.manifestCompression);
            this.manifestDurationFormat(model.manifestDurationFormat);
            this.minBufferTime(model.minBufferTime);
            this.minFinalSegmentLength(model.minFinalSegmentLength);
            this.segmentControl(model.segmentControl);
            this.segmentLength(model.segmentLength);
            this.streamInfResolution(model.streamInfResolution);
            this.writeDashManifest(model.writeDashManifest);
            this.writeHlsManifest(model.writeHlsManifest);
        }

        public final String getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public final String getClientCache() {
            return this.clientCache;
        }

        @Override
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        public final Builder clientCache(CmafClientCache clientCache) {
            this.clientCache(clientCache.toString());
            return this;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        public final String getCodecSpecification() {
            return this.codecSpecification;
        }

        @Override
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        public final Builder codecSpecification(CmafCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification.toString());
            return this;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final CmafEncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(CmafEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(CmafEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getFragmentLength() {
            return this.fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        public final String getManifestCompression() {
            return this.manifestCompression;
        }

        @Override
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        public final Builder manifestCompression(CmafManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression.toString());
            return this;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        public final String getManifestDurationFormat() {
            return this.manifestDurationFormat;
        }

        @Override
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        public final Builder manifestDurationFormat(CmafManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat.toString());
            return this;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        public final Integer getMinBufferTime() {
            return this.minBufferTime;
        }

        @Override
        public final Builder minBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
            return this;
        }

        public final void setMinBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
        }

        public final Double getMinFinalSegmentLength() {
            return this.minFinalSegmentLength;
        }

        @Override
        public final Builder minFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
            return this;
        }

        public final void setMinFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
        }

        public final String getSegmentControl() {
            return this.segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(CmafSegmentControl segmentControl) {
            this.segmentControl(segmentControl.toString());
            return this;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        public final String getStreamInfResolution() {
            return this.streamInfResolution;
        }

        @Override
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        public final Builder streamInfResolution(CmafStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution.toString());
            return this;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        public final String getWriteDashManifest() {
            return this.writeDashManifest;
        }

        @Override
        public final Builder writeDashManifest(String writeDashManifest) {
            this.writeDashManifest = writeDashManifest;
            return this;
        }

        @Override
        public final Builder writeDashManifest(CmafWriteDASHManifest writeDashManifest) {
            this.writeDashManifest(writeDashManifest.toString());
            return this;
        }

        public final void setWriteDashManifest(String writeDashManifest) {
            this.writeDashManifest = writeDashManifest;
        }

        public final String getWriteHlsManifest() {
            return this.writeHlsManifest;
        }

        @Override
        public final Builder writeHlsManifest(String writeHlsManifest) {
            this.writeHlsManifest = writeHlsManifest;
            return this;
        }

        @Override
        public final Builder writeHlsManifest(CmafWriteHLSManifest writeHlsManifest) {
            this.writeHlsManifest(writeHlsManifest.toString());
            return this;
        }

        public final void setWriteHlsManifest(String writeHlsManifest) {
            this.writeHlsManifest = writeHlsManifest;
        }

        public CmafGroupSettings build() {
            return new CmafGroupSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CmafGroupSettings> {
        public Builder baseUrl(String var1);

        public Builder clientCache(String var1);

        public Builder clientCache(CmafClientCache var1);

        public Builder codecSpecification(String var1);

        public Builder codecSpecification(CmafCodecSpecification var1);

        public Builder destination(String var1);

        public Builder encryption(CmafEncryptionSettings var1);

        default public Builder encryption(Consumer<CmafEncryptionSettings.Builder> encryption) {
            return this.encryption((CmafEncryptionSettings)((CmafEncryptionSettings.Builder)CmafEncryptionSettings.builder().applyMutation(encryption)).build());
        }

        public Builder fragmentLength(Integer var1);

        public Builder manifestCompression(String var1);

        public Builder manifestCompression(CmafManifestCompression var1);

        public Builder manifestDurationFormat(String var1);

        public Builder manifestDurationFormat(CmafManifestDurationFormat var1);

        public Builder minBufferTime(Integer var1);

        public Builder minFinalSegmentLength(Double var1);

        public Builder segmentControl(String var1);

        public Builder segmentControl(CmafSegmentControl var1);

        public Builder segmentLength(Integer var1);

        public Builder streamInfResolution(String var1);

        public Builder streamInfResolution(CmafStreamInfResolution var1);

        public Builder writeDashManifest(String var1);

        public Builder writeDashManifest(CmafWriteDASHManifest var1);

        public Builder writeHlsManifest(String var1);

        public Builder writeHlsManifest(CmafWriteHLSManifest var1);
    }
}

