/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleAlignment;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleBackgroundColor;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleFontColor;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleOutlineColor;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleShadowColor;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleTeletextSpacing;
import software.amazon.awssdk.services.mediaconvert.transform.BurninDestinationSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BurninDestinationSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, BurninDestinationSettings> {
    private final String alignment;
    private final String backgroundColor;
    private final Integer backgroundOpacity;
    private final String fontColor;
    private final Integer fontOpacity;
    private final Integer fontResolution;
    private final Integer fontSize;
    private final String outlineColor;
    private final Integer outlineSize;
    private final String shadowColor;
    private final Integer shadowOpacity;
    private final Integer shadowXOffset;
    private final Integer shadowYOffset;
    private final String teletextSpacing;
    private final Integer xPosition;
    private final Integer yPosition;

    private BurninDestinationSettings(BuilderImpl builder) {
        this.alignment = builder.alignment;
        this.backgroundColor = builder.backgroundColor;
        this.backgroundOpacity = builder.backgroundOpacity;
        this.fontColor = builder.fontColor;
        this.fontOpacity = builder.fontOpacity;
        this.fontResolution = builder.fontResolution;
        this.fontSize = builder.fontSize;
        this.outlineColor = builder.outlineColor;
        this.outlineSize = builder.outlineSize;
        this.shadowColor = builder.shadowColor;
        this.shadowOpacity = builder.shadowOpacity;
        this.shadowXOffset = builder.shadowXOffset;
        this.shadowYOffset = builder.shadowYOffset;
        this.teletextSpacing = builder.teletextSpacing;
        this.xPosition = builder.xPosition;
        this.yPosition = builder.yPosition;
    }

    public BurninSubtitleAlignment alignment() {
        return BurninSubtitleAlignment.fromValue(this.alignment);
    }

    public String alignmentAsString() {
        return this.alignment;
    }

    public BurninSubtitleBackgroundColor backgroundColor() {
        return BurninSubtitleBackgroundColor.fromValue(this.backgroundColor);
    }

    public String backgroundColorAsString() {
        return this.backgroundColor;
    }

    public Integer backgroundOpacity() {
        return this.backgroundOpacity;
    }

    public BurninSubtitleFontColor fontColor() {
        return BurninSubtitleFontColor.fromValue(this.fontColor);
    }

    public String fontColorAsString() {
        return this.fontColor;
    }

    public Integer fontOpacity() {
        return this.fontOpacity;
    }

    public Integer fontResolution() {
        return this.fontResolution;
    }

    public Integer fontSize() {
        return this.fontSize;
    }

    public BurninSubtitleOutlineColor outlineColor() {
        return BurninSubtitleOutlineColor.fromValue(this.outlineColor);
    }

    public String outlineColorAsString() {
        return this.outlineColor;
    }

    public Integer outlineSize() {
        return this.outlineSize;
    }

    public BurninSubtitleShadowColor shadowColor() {
        return BurninSubtitleShadowColor.fromValue(this.shadowColor);
    }

    public String shadowColorAsString() {
        return this.shadowColor;
    }

    public Integer shadowOpacity() {
        return this.shadowOpacity;
    }

    public Integer shadowXOffset() {
        return this.shadowXOffset;
    }

    public Integer shadowYOffset() {
        return this.shadowYOffset;
    }

    public BurninSubtitleTeletextSpacing teletextSpacing() {
        return BurninSubtitleTeletextSpacing.fromValue(this.teletextSpacing);
    }

    public String teletextSpacingAsString() {
        return this.teletextSpacing;
    }

    public Integer xPosition() {
        return this.xPosition;
    }

    public Integer yPosition() {
        return this.yPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontResolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.outlineColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outlineSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowXOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowYOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.teletextSpacingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.xPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.yPosition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BurninDestinationSettings)) {
            return false;
        }
        BurninDestinationSettings other = (BurninDestinationSettings)obj;
        return Objects.equals(this.alignmentAsString(), other.alignmentAsString()) && Objects.equals(this.backgroundColorAsString(), other.backgroundColorAsString()) && Objects.equals(this.backgroundOpacity(), other.backgroundOpacity()) && Objects.equals(this.fontColorAsString(), other.fontColorAsString()) && Objects.equals(this.fontOpacity(), other.fontOpacity()) && Objects.equals(this.fontResolution(), other.fontResolution()) && Objects.equals(this.fontSize(), other.fontSize()) && Objects.equals(this.outlineColorAsString(), other.outlineColorAsString()) && Objects.equals(this.outlineSize(), other.outlineSize()) && Objects.equals(this.shadowColorAsString(), other.shadowColorAsString()) && Objects.equals(this.shadowOpacity(), other.shadowOpacity()) && Objects.equals(this.shadowXOffset(), other.shadowXOffset()) && Objects.equals(this.shadowYOffset(), other.shadowYOffset()) && Objects.equals(this.teletextSpacingAsString(), other.teletextSpacingAsString()) && Objects.equals(this.xPosition(), other.xPosition()) && Objects.equals(this.yPosition(), other.yPosition());
    }

    public String toString() {
        return ToString.builder((String)"BurninDestinationSettings").add("Alignment", (Object)this.alignmentAsString()).add("BackgroundColor", (Object)this.backgroundColorAsString()).add("BackgroundOpacity", (Object)this.backgroundOpacity()).add("FontColor", (Object)this.fontColorAsString()).add("FontOpacity", (Object)this.fontOpacity()).add("FontResolution", (Object)this.fontResolution()).add("FontSize", (Object)this.fontSize()).add("OutlineColor", (Object)this.outlineColorAsString()).add("OutlineSize", (Object)this.outlineSize()).add("ShadowColor", (Object)this.shadowColorAsString()).add("ShadowOpacity", (Object)this.shadowOpacity()).add("ShadowXOffset", (Object)this.shadowXOffset()).add("ShadowYOffset", (Object)this.shadowYOffset()).add("TeletextSpacing", (Object)this.teletextSpacingAsString()).add("XPosition", (Object)this.xPosition()).add("YPosition", (Object)this.yPosition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alignment": {
                return Optional.ofNullable(clazz.cast(this.alignmentAsString()));
            }
            case "BackgroundColor": {
                return Optional.ofNullable(clazz.cast(this.backgroundColorAsString()));
            }
            case "BackgroundOpacity": {
                return Optional.ofNullable(clazz.cast(this.backgroundOpacity()));
            }
            case "FontColor": {
                return Optional.ofNullable(clazz.cast(this.fontColorAsString()));
            }
            case "FontOpacity": {
                return Optional.ofNullable(clazz.cast(this.fontOpacity()));
            }
            case "FontResolution": {
                return Optional.ofNullable(clazz.cast(this.fontResolution()));
            }
            case "FontSize": {
                return Optional.ofNullable(clazz.cast(this.fontSize()));
            }
            case "OutlineColor": {
                return Optional.ofNullable(clazz.cast(this.outlineColorAsString()));
            }
            case "OutlineSize": {
                return Optional.ofNullable(clazz.cast(this.outlineSize()));
            }
            case "ShadowColor": {
                return Optional.ofNullable(clazz.cast(this.shadowColorAsString()));
            }
            case "ShadowOpacity": {
                return Optional.ofNullable(clazz.cast(this.shadowOpacity()));
            }
            case "ShadowXOffset": {
                return Optional.ofNullable(clazz.cast(this.shadowXOffset()));
            }
            case "ShadowYOffset": {
                return Optional.ofNullable(clazz.cast(this.shadowYOffset()));
            }
            case "TeletextSpacing": {
                return Optional.ofNullable(clazz.cast(this.teletextSpacingAsString()));
            }
            case "XPosition": {
                return Optional.ofNullable(clazz.cast(this.xPosition()));
            }
            case "YPosition": {
                return Optional.ofNullable(clazz.cast(this.yPosition()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BurninDestinationSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String alignment;
        private String backgroundColor;
        private Integer backgroundOpacity;
        private String fontColor;
        private Integer fontOpacity;
        private Integer fontResolution;
        private Integer fontSize;
        private String outlineColor;
        private Integer outlineSize;
        private String shadowColor;
        private Integer shadowOpacity;
        private Integer shadowXOffset;
        private Integer shadowYOffset;
        private String teletextSpacing;
        private Integer xPosition;
        private Integer yPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(BurninDestinationSettings model) {
            this.alignment(model.alignment);
            this.backgroundColor(model.backgroundColor);
            this.backgroundOpacity(model.backgroundOpacity);
            this.fontColor(model.fontColor);
            this.fontOpacity(model.fontOpacity);
            this.fontResolution(model.fontResolution);
            this.fontSize(model.fontSize);
            this.outlineColor(model.outlineColor);
            this.outlineSize(model.outlineSize);
            this.shadowColor(model.shadowColor);
            this.shadowOpacity(model.shadowOpacity);
            this.shadowXOffset(model.shadowXOffset);
            this.shadowYOffset(model.shadowYOffset);
            this.teletextSpacing(model.teletextSpacing);
            this.xPosition(model.xPosition);
            this.yPosition(model.yPosition);
        }

        public final String getAlignment() {
            return this.alignment;
        }

        @Override
        public final Builder alignment(String alignment) {
            this.alignment = alignment;
            return this;
        }

        @Override
        public final Builder alignment(BurninSubtitleAlignment alignment) {
            this.alignment(alignment.toString());
            return this;
        }

        public final void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        public final String getBackgroundColor() {
            return this.backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @Override
        public final Builder backgroundColor(BurninSubtitleBackgroundColor backgroundColor) {
            this.backgroundColor(backgroundColor.toString());
            return this;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public final Integer getBackgroundOpacity() {
            return this.backgroundOpacity;
        }

        @Override
        public final Builder backgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
            return this;
        }

        public final void setBackgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
        }

        public final String getFontColor() {
            return this.fontColor;
        }

        @Override
        public final Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            return this;
        }

        @Override
        public final Builder fontColor(BurninSubtitleFontColor fontColor) {
            this.fontColor(fontColor.toString());
            return this;
        }

        public final void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        public final Integer getFontOpacity() {
            return this.fontOpacity;
        }

        @Override
        public final Builder fontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
            return this;
        }

        public final void setFontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
        }

        public final Integer getFontResolution() {
            return this.fontResolution;
        }

        @Override
        public final Builder fontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
            return this;
        }

        public final void setFontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
        }

        public final Integer getFontSize() {
            return this.fontSize;
        }

        @Override
        public final Builder fontSize(Integer fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public final void setFontSize(Integer fontSize) {
            this.fontSize = fontSize;
        }

        public final String getOutlineColor() {
            return this.outlineColor;
        }

        @Override
        public final Builder outlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
            return this;
        }

        @Override
        public final Builder outlineColor(BurninSubtitleOutlineColor outlineColor) {
            this.outlineColor(outlineColor.toString());
            return this;
        }

        public final void setOutlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
        }

        public final Integer getOutlineSize() {
            return this.outlineSize;
        }

        @Override
        public final Builder outlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
            return this;
        }

        public final void setOutlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
        }

        public final String getShadowColor() {
            return this.shadowColor;
        }

        @Override
        public final Builder shadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
            return this;
        }

        @Override
        public final Builder shadowColor(BurninSubtitleShadowColor shadowColor) {
            this.shadowColor(shadowColor.toString());
            return this;
        }

        public final void setShadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
        }

        public final Integer getShadowOpacity() {
            return this.shadowOpacity;
        }

        @Override
        public final Builder shadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
            return this;
        }

        public final void setShadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
        }

        public final Integer getShadowXOffset() {
            return this.shadowXOffset;
        }

        @Override
        public final Builder shadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
            return this;
        }

        public final void setShadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
        }

        public final Integer getShadowYOffset() {
            return this.shadowYOffset;
        }

        @Override
        public final Builder shadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
            return this;
        }

        public final void setShadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
        }

        public final String getTeletextSpacing() {
            return this.teletextSpacing;
        }

        @Override
        public final Builder teletextSpacing(String teletextSpacing) {
            this.teletextSpacing = teletextSpacing;
            return this;
        }

        @Override
        public final Builder teletextSpacing(BurninSubtitleTeletextSpacing teletextSpacing) {
            this.teletextSpacing(teletextSpacing.toString());
            return this;
        }

        public final void setTeletextSpacing(String teletextSpacing) {
            this.teletextSpacing = teletextSpacing;
        }

        public final Integer getXPosition() {
            return this.xPosition;
        }

        @Override
        public final Builder xPosition(Integer xPosition) {
            this.xPosition = xPosition;
            return this;
        }

        public final void setXPosition(Integer xPosition) {
            this.xPosition = xPosition;
        }

        public final Integer getYPosition() {
            return this.yPosition;
        }

        @Override
        public final Builder yPosition(Integer yPosition) {
            this.yPosition = yPosition;
            return this;
        }

        public final void setYPosition(Integer yPosition) {
            this.yPosition = yPosition;
        }

        public BurninDestinationSettings build() {
            return new BurninDestinationSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BurninDestinationSettings> {
        public Builder alignment(String var1);

        public Builder alignment(BurninSubtitleAlignment var1);

        public Builder backgroundColor(String var1);

        public Builder backgroundColor(BurninSubtitleBackgroundColor var1);

        public Builder backgroundOpacity(Integer var1);

        public Builder fontColor(String var1);

        public Builder fontColor(BurninSubtitleFontColor var1);

        public Builder fontOpacity(Integer var1);

        public Builder fontResolution(Integer var1);

        public Builder fontSize(Integer var1);

        public Builder outlineColor(String var1);

        public Builder outlineColor(BurninSubtitleOutlineColor var1);

        public Builder outlineSize(Integer var1);

        public Builder shadowColor(String var1);

        public Builder shadowColor(BurninSubtitleShadowColor var1);

        public Builder shadowOpacity(Integer var1);

        public Builder shadowXOffset(Integer var1);

        public Builder shadowYOffset(Integer var1);

        public Builder teletextSpacing(String var1);

        public Builder teletextSpacing(BurninSubtitleTeletextSpacing var1);

        public Builder xPosition(Integer var1);

        public Builder yPosition(Integer var1);
    }
}

