/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.ProresSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProresSettingsMarshaller {
    private static final MarshallingInfo<String> CODECPROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecProfile").isBinary(false).build();
    private static final MarshallingInfo<String> FRAMERATECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateControl").isBinary(false).build();
    private static final MarshallingInfo<String> FRAMERATECONVERSIONALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateConversionAlgorithm").isBinary(false).build();
    private static final MarshallingInfo<Integer> FRAMERATEDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateDenominator").isBinary(false).build();
    private static final MarshallingInfo<Integer> FRAMERATENUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateNumerator").isBinary(false).build();
    private static final MarshallingInfo<String> INTERLACEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interlaceMode").isBinary(false).build();
    private static final MarshallingInfo<String> PARCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> PARDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parDenominator").isBinary(false).build();
    private static final MarshallingInfo<Integer> PARNUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parNumerator").isBinary(false).build();
    private static final MarshallingInfo<String> SLOWPAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slowPal").isBinary(false).build();
    private static final MarshallingInfo<String> TELECINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("telecine").isBinary(false).build();
    private static final ProresSettingsMarshaller INSTANCE = new ProresSettingsMarshaller();

    private ProresSettingsMarshaller() {
    }

    public static ProresSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProresSettings proresSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)proresSettings, (String)"proresSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)proresSettings.codecProfileAsString(), CODECPROFILE_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.framerateControlAsString(), FRAMERATECONTROL_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.framerateConversionAlgorithmAsString(), FRAMERATECONVERSIONALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.framerateDenominator(), FRAMERATEDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.framerateNumerator(), FRAMERATENUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.interlaceModeAsString(), INTERLACEMODE_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.parControlAsString(), PARCONTROL_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.parDenominator(), PARDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.parNumerator(), PARNUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.slowPalAsString(), SLOWPAL_BINDING);
            protocolMarshaller.marshall((Object)proresSettings.telecineAsString(), TELECINE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

