/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Output;
import software.amazon.awssdk.services.mediaconvert.transform.AudioDescriptionUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.CaptionDescriptionUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.ContainerSettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.OutputSettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.VideoDescriptionUnmarshaller;

public class OutputUnmarshaller
implements Unmarshaller<Output, JsonUnmarshallerContext> {
    private static final OutputUnmarshaller INSTANCE = new OutputUnmarshaller();

    public Output unmarshall(JsonUnmarshallerContext context) throws Exception {
        Output.Builder outputBuilder = Output.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("audioDescriptions", targetDepth)) {
                    context.nextToken();
                    outputBuilder.audioDescriptions(new ListUnmarshaller((Unmarshaller)AudioDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("captionDescriptions", targetDepth)) {
                    context.nextToken();
                    outputBuilder.captionDescriptions(new ListUnmarshaller((Unmarshaller)CaptionDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("containerSettings", targetDepth)) {
                    context.nextToken();
                    outputBuilder.containerSettings(ContainerSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("extension", targetDepth)) {
                    context.nextToken();
                    outputBuilder.extension((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("nameModifier", targetDepth)) {
                    context.nextToken();
                    outputBuilder.nameModifier((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("outputSettings", targetDepth)) {
                    context.nextToken();
                    outputBuilder.outputSettings(OutputSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("preset", targetDepth)) {
                    context.nextToken();
                    outputBuilder.preset((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("videoDescription", targetDepth)) {
                    context.nextToken();
                    outputBuilder.videoDescription(VideoDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Output)outputBuilder.build();
    }

    public static OutputUnmarshaller getInstance() {
        return INSTANCE;
    }
}

