/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.OutputChannelMapping;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputChannelMappingMarshaller {
    private static final MarshallingInfo<List> INPUTCHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputChannels").isBinary(false).build();
    private static final OutputChannelMappingMarshaller INSTANCE = new OutputChannelMappingMarshaller();

    private OutputChannelMappingMarshaller() {
    }

    public static OutputChannelMappingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputChannelMapping outputChannelMapping, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputChannelMapping, (String)"outputChannelMapping");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(outputChannelMapping.inputChannels(), INPUTCHANNELS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

