/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.JobTemplateSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobTemplateSettingsMarshaller {
    private static final MarshallingInfo<Integer> ADAVAILOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adAvailOffset").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> AVAILBLANKING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availBlanking").isBinary(false).build();
    private static final MarshallingInfo<List> INPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputs").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NIELSENCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nielsenConfiguration").isBinary(false).build();
    private static final MarshallingInfo<List> OUTPUTGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputGroups").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TIMECODECONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timecodeConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TIMEDMETADATAINSERTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataInsertion").isBinary(false).build();
    private static final JobTemplateSettingsMarshaller INSTANCE = new JobTemplateSettingsMarshaller();

    private JobTemplateSettingsMarshaller() {
    }

    public static JobTemplateSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobTemplateSettings jobTemplateSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobTemplateSettings, (String)"jobTemplateSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobTemplateSettings.adAvailOffset(), ADAVAILOFFSET_BINDING);
            protocolMarshaller.marshall((Object)jobTemplateSettings.availBlanking(), AVAILBLANKING_BINDING);
            protocolMarshaller.marshall(jobTemplateSettings.inputs(), INPUTS_BINDING);
            protocolMarshaller.marshall((Object)jobTemplateSettings.nielsenConfiguration(), NIELSENCONFIGURATION_BINDING);
            protocolMarshaller.marshall(jobTemplateSettings.outputGroups(), OUTPUTGROUPS_BINDING);
            protocolMarshaller.marshall((Object)jobTemplateSettings.timecodeConfig(), TIMECODECONFIG_BINDING);
            protocolMarshaller.marshall((Object)jobTemplateSettings.timedMetadataInsertion(), TIMEDMETADATAINSERTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

