/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.H264Settings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class H264SettingsMarshaller {
    private static final MarshallingInfo<String> ADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adaptiveQuantization").isBinary(false).build();
    private static final MarshallingInfo<Integer> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").isBinary(false).build();
    private static final MarshallingInfo<String> CODECLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecLevel").isBinary(false).build();
    private static final MarshallingInfo<String> CODECPROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecProfile").isBinary(false).build();
    private static final MarshallingInfo<String> ENTROPYENCODING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entropyEncoding").isBinary(false).build();
    private static final MarshallingInfo<String> FIELDENCODING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fieldEncoding").isBinary(false).build();
    private static final MarshallingInfo<String> FLICKERADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("flickerAdaptiveQuantization").isBinary(false).build();
    private static final MarshallingInfo<String> FRAMERATECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateControl").isBinary(false).build();
    private static final MarshallingInfo<String> FRAMERATECONVERSIONALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateConversionAlgorithm").isBinary(false).build();
    private static final MarshallingInfo<Integer> FRAMERATEDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateDenominator").isBinary(false).build();
    private static final MarshallingInfo<Integer> FRAMERATENUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateNumerator").isBinary(false).build();
    private static final MarshallingInfo<String> GOPBREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopBReference").isBinary(false).build();
    private static final MarshallingInfo<Integer> GOPCLOSEDCADENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopClosedCadence").isBinary(false).build();
    private static final MarshallingInfo<Double> GOPSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopSize").isBinary(false).build();
    private static final MarshallingInfo<String> GOPSIZEUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopSizeUnits").isBinary(false).build();
    private static final MarshallingInfo<Integer> HRDBUFFERINITIALFILLPERCENTAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hrdBufferInitialFillPercentage").isBinary(false).build();
    private static final MarshallingInfo<Integer> HRDBUFFERSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hrdBufferSize").isBinary(false).build();
    private static final MarshallingInfo<String> INTERLACEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interlaceMode").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXBITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxBitrate").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINIINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minIInterval").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBERBFRAMESBETWEENREFERENCEFRAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberBFramesBetweenReferenceFrames").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBERREFERENCEFRAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberReferenceFrames").isBinary(false).build();
    private static final MarshallingInfo<String> PARCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> PARDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parDenominator").isBinary(false).build();
    private static final MarshallingInfo<Integer> PARNUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parNumerator").isBinary(false).build();
    private static final MarshallingInfo<String> QUALITYTUNINGLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("qualityTuningLevel").isBinary(false).build();
    private static final MarshallingInfo<String> RATECONTROLMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rateControlMode").isBinary(false).build();
    private static final MarshallingInfo<String> REPEATPPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repeatPps").isBinary(false).build();
    private static final MarshallingInfo<String> SCENECHANGEDETECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sceneChangeDetect").isBinary(false).build();
    private static final MarshallingInfo<Integer> SLICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slices").isBinary(false).build();
    private static final MarshallingInfo<String> SLOWPAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slowPal").isBinary(false).build();
    private static final MarshallingInfo<Integer> SOFTNESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("softness").isBinary(false).build();
    private static final MarshallingInfo<String> SPATIALADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spatialAdaptiveQuantization").isBinary(false).build();
    private static final MarshallingInfo<String> SYNTAX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("syntax").isBinary(false).build();
    private static final MarshallingInfo<String> TELECINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("telecine").isBinary(false).build();
    private static final MarshallingInfo<String> TEMPORALADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("temporalAdaptiveQuantization").isBinary(false).build();
    private static final MarshallingInfo<String> UNREGISTEREDSEITIMECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unregisteredSeiTimecode").isBinary(false).build();
    private static final H264SettingsMarshaller INSTANCE = new H264SettingsMarshaller();

    private H264SettingsMarshaller() {
    }

    public static H264SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(H264Settings h264Settings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)h264Settings, (String)"h264Settings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)h264Settings.adaptiveQuantizationAsString(), ADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.codecLevelAsString(), CODECLEVEL_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.codecProfileAsString(), CODECPROFILE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.entropyEncodingAsString(), ENTROPYENCODING_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.fieldEncodingAsString(), FIELDENCODING_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.flickerAdaptiveQuantizationAsString(), FLICKERADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.framerateControlAsString(), FRAMERATECONTROL_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.framerateConversionAlgorithmAsString(), FRAMERATECONVERSIONALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.framerateDenominator(), FRAMERATEDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.framerateNumerator(), FRAMERATENUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.gopBReferenceAsString(), GOPBREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.gopClosedCadence(), GOPCLOSEDCADENCE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.gopSize(), GOPSIZE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.gopSizeUnitsAsString(), GOPSIZEUNITS_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.hrdBufferInitialFillPercentage(), HRDBUFFERINITIALFILLPERCENTAGE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.hrdBufferSize(), HRDBUFFERSIZE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.interlaceModeAsString(), INTERLACEMODE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.maxBitrate(), MAXBITRATE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.minIInterval(), MINIINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.numberBFramesBetweenReferenceFrames(), NUMBERBFRAMESBETWEENREFERENCEFRAMES_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.numberReferenceFrames(), NUMBERREFERENCEFRAMES_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.parControlAsString(), PARCONTROL_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.parDenominator(), PARDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.parNumerator(), PARNUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.qualityTuningLevelAsString(), QUALITYTUNINGLEVEL_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.rateControlModeAsString(), RATECONTROLMODE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.repeatPpsAsString(), REPEATPPS_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.sceneChangeDetectAsString(), SCENECHANGEDETECT_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.slices(), SLICES_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.slowPalAsString(), SLOWPAL_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.softness(), SOFTNESS_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.spatialAdaptiveQuantizationAsString(), SPATIALADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.syntaxAsString(), SYNTAX_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.telecineAsString(), TELECINE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.temporalAdaptiveQuantizationAsString(), TEMPORALADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.unregisteredSeiTimecodeAsString(), UNREGISTEREDSEITIMECODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

