/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.DvbSdtSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DvbSdtSettingsMarshaller {
    private static final MarshallingInfo<String> OUTPUTSDT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputSdt").isBinary(false).build();
    private static final MarshallingInfo<Integer> SDTINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sdtInterval").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceName").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEPROVIDERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceProviderName").isBinary(false).build();
    private static final DvbSdtSettingsMarshaller INSTANCE = new DvbSdtSettingsMarshaller();

    private DvbSdtSettingsMarshaller() {
    }

    public static DvbSdtSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DvbSdtSettings dvbSdtSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dvbSdtSettings, (String)"dvbSdtSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dvbSdtSettings.outputSdtAsString(), OUTPUTSDT_BINDING);
            protocolMarshaller.marshall((Object)dvbSdtSettings.sdtInterval(), SDTINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)dvbSdtSettings.serviceName(), SERVICENAME_BINDING);
            protocolMarshaller.marshall((Object)dvbSdtSettings.serviceProviderName(), SERVICEPROVIDERNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

