/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.CaptionDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CaptionDescriptionMarshaller {
    private static final MarshallingInfo<String> CAPTIONSELECTORNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionSelectorName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationSettings").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageCode").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageDescription").isBinary(false).build();
    private static final CaptionDescriptionMarshaller INSTANCE = new CaptionDescriptionMarshaller();

    private CaptionDescriptionMarshaller() {
    }

    public static CaptionDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CaptionDescription captionDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)captionDescription, (String)"captionDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)captionDescription.captionSelectorName(), CAPTIONSELECTORNAME_BINDING);
            protocolMarshaller.marshall((Object)captionDescription.destinationSettings(), DESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDescription.languageCodeAsString(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)captionDescription.languageDescription(), LANGUAGEDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

