/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.AudioNormalizationSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AudioNormalizationSettingsMarshaller {
    private static final MarshallingInfo<String> ALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithm").isBinary(false).build();
    private static final MarshallingInfo<String> ALGORITHMCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithmControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> CORRECTIONGATELEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("correctionGateLevel").isBinary(false).build();
    private static final MarshallingInfo<String> LOUDNESSLOGGING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loudnessLogging").isBinary(false).build();
    private static final MarshallingInfo<String> PEAKCALCULATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("peakCalculation").isBinary(false).build();
    private static final MarshallingInfo<Double> TARGETLKFS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetLkfs").isBinary(false).build();
    private static final AudioNormalizationSettingsMarshaller INSTANCE = new AudioNormalizationSettingsMarshaller();

    private AudioNormalizationSettingsMarshaller() {
    }

    public static AudioNormalizationSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioNormalizationSettings audioNormalizationSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)audioNormalizationSettings, (String)"audioNormalizationSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)audioNormalizationSettings.algorithmAsString(), ALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)audioNormalizationSettings.algorithmControlAsString(), ALGORITHMCONTROL_BINDING);
            protocolMarshaller.marshall((Object)audioNormalizationSettings.correctionGateLevel(), CORRECTIONGATELEVEL_BINDING);
            protocolMarshaller.marshall((Object)audioNormalizationSettings.loudnessLoggingAsString(), LOUDNESSLOGGING_BINDING);
            protocolMarshaller.marshall((Object)audioNormalizationSettings.peakCalculationAsString(), PEAKCALCULATION_BINDING);
            protocolMarshaller.marshall((Object)audioNormalizationSettings.targetLkfs(), TARGETLKFS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

