/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.AudioDescription;
import software.amazon.awssdk.services.mediaconvert.transform.AudioCodecSettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.AudioNormalizationSettingsUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.RemixSettingsUnmarshaller;

public class AudioDescriptionUnmarshaller
implements Unmarshaller<AudioDescription, JsonUnmarshallerContext> {
    private static final AudioDescriptionUnmarshaller INSTANCE = new AudioDescriptionUnmarshaller();

    public AudioDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        AudioDescription.Builder audioDescriptionBuilder = AudioDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("audioNormalizationSettings", targetDepth)) {
                    context.nextToken();
                    audioDescriptionBuilder.audioNormalizationSettings(AudioNormalizationSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("audioSourceName", targetDepth)) {
                    context.nextToken();
                    audioDescriptionBuilder.audioSourceName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("audioType", targetDepth)) {
                    context.nextToken();
                    audioDescriptionBuilder.audioType((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("audioTypeControl", targetDepth)) {
                    context.nextToken();
                    audioDescriptionBuilder.audioTypeControl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("codecSettings", targetDepth)) {
                    context.nextToken();
                    audioDescriptionBuilder.codecSettings(AudioCodecSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("languageCode", targetDepth)) {
                    context.nextToken();
                    audioDescriptionBuilder.languageCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("languageCodeControl", targetDepth)) {
                    context.nextToken();
                    audioDescriptionBuilder.languageCodeControl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("remixSettings", targetDepth)) {
                    context.nextToken();
                    audioDescriptionBuilder.remixSettings(RemixSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("streamName", targetDepth)) {
                    context.nextToken();
                    audioDescriptionBuilder.streamName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AudioDescription)audioDescriptionBuilder.build();
    }

    public static AudioDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

