/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.transform.TimingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Timing
implements StructuredPojo,
ToCopyableBuilder<Builder, Timing> {
    private final Instant finishTime;
    private final Instant startTime;
    private final Instant submitTime;

    private Timing(BuilderImpl builder) {
        this.finishTime = builder.finishTime;
        this.startTime = builder.startTime;
        this.submitTime = builder.submitTime;
    }

    public Instant finishTime() {
        return this.finishTime;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant submitTime() {
        return this.submitTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.finishTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Timing)) {
            return false;
        }
        Timing other = (Timing)obj;
        return Objects.equals(this.finishTime(), other.finishTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.submitTime(), other.submitTime());
    }

    public String toString() {
        return ToString.builder((String)"Timing").add("FinishTime", (Object)this.finishTime()).add("StartTime", (Object)this.startTime()).add("SubmitTime", (Object)this.submitTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FinishTime": {
                return Optional.of(clazz.cast(this.finishTime()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "SubmitTime": {
                return Optional.of(clazz.cast(this.submitTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant finishTime;
        private Instant startTime;
        private Instant submitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Timing model) {
            this.finishTime(model.finishTime);
            this.startTime(model.startTime);
            this.submitTime(model.submitTime);
        }

        public final Instant getFinishTime() {
            return this.finishTime;
        }

        @Override
        public final Builder finishTime(Instant finishTime) {
            this.finishTime = finishTime;
            return this;
        }

        public final void setFinishTime(Instant finishTime) {
            this.finishTime = finishTime;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getSubmitTime() {
            return this.submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        public Timing build() {
            return new Timing(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Timing> {
        public Builder finishTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder submitTime(Instant var1);
    }
}

