/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.transform.NielsenConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NielsenConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, NielsenConfiguration> {
    private final Integer breakoutCode;
    private final String distributorId;

    private NielsenConfiguration(BuilderImpl builder) {
        this.breakoutCode = builder.breakoutCode;
        this.distributorId = builder.distributorId;
    }

    public Integer breakoutCode() {
        return this.breakoutCode;
    }

    public String distributorId() {
        return this.distributorId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.breakoutCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributorId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NielsenConfiguration)) {
            return false;
        }
        NielsenConfiguration other = (NielsenConfiguration)obj;
        return Objects.equals(this.breakoutCode(), other.breakoutCode()) && Objects.equals(this.distributorId(), other.distributorId());
    }

    public String toString() {
        return ToString.builder((String)"NielsenConfiguration").add("BreakoutCode", (Object)this.breakoutCode()).add("DistributorId", (Object)this.distributorId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BreakoutCode": {
                return Optional.of(clazz.cast(this.breakoutCode()));
            }
            case "DistributorId": {
                return Optional.of(clazz.cast(this.distributorId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NielsenConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer breakoutCode;
        private String distributorId;

        private BuilderImpl() {
        }

        private BuilderImpl(NielsenConfiguration model) {
            this.breakoutCode(model.breakoutCode);
            this.distributorId(model.distributorId);
        }

        public final Integer getBreakoutCode() {
            return this.breakoutCode;
        }

        @Override
        public final Builder breakoutCode(Integer breakoutCode) {
            this.breakoutCode = breakoutCode;
            return this;
        }

        public final void setBreakoutCode(Integer breakoutCode) {
            this.breakoutCode = breakoutCode;
        }

        public final String getDistributorId() {
            return this.distributorId;
        }

        @Override
        public final Builder distributorId(String distributorId) {
            this.distributorId = distributorId;
            return this;
        }

        public final void setDistributorId(String distributorId) {
            this.distributorId = distributorId;
        }

        public NielsenConfiguration build() {
            return new NielsenConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NielsenConfiguration> {
        public Builder breakoutCode(Integer var1);

        public Builder distributorId(String var1);
    }
}

