/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.MsSmoothAudioDeduplication;
import software.amazon.awssdk.services.mediaconvert.model.MsSmoothEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.model.MsSmoothManifestEncoding;
import software.amazon.awssdk.services.mediaconvert.transform.MsSmoothGroupSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MsSmoothGroupSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, MsSmoothGroupSettings> {
    private final String audioDeduplication;
    private final String destination;
    private final MsSmoothEncryptionSettings encryption;
    private final Integer fragmentLength;
    private final String manifestEncoding;

    private MsSmoothGroupSettings(BuilderImpl builder) {
        this.audioDeduplication = builder.audioDeduplication;
        this.destination = builder.destination;
        this.encryption = builder.encryption;
        this.fragmentLength = builder.fragmentLength;
        this.manifestEncoding = builder.manifestEncoding;
    }

    public MsSmoothAudioDeduplication audioDeduplication() {
        return MsSmoothAudioDeduplication.fromValue(this.audioDeduplication);
    }

    public String audioDeduplicationAsString() {
        return this.audioDeduplication;
    }

    public String destination() {
        return this.destination;
    }

    public MsSmoothEncryptionSettings encryption() {
        return this.encryption;
    }

    public Integer fragmentLength() {
        return this.fragmentLength;
    }

    public MsSmoothManifestEncoding manifestEncoding() {
        return MsSmoothManifestEncoding.fromValue(this.manifestEncoding);
    }

    public String manifestEncodingAsString() {
        return this.manifestEncoding;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDeduplicationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestEncodingAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MsSmoothGroupSettings)) {
            return false;
        }
        MsSmoothGroupSettings other = (MsSmoothGroupSettings)obj;
        return Objects.equals(this.audioDeduplicationAsString(), other.audioDeduplicationAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.fragmentLength(), other.fragmentLength()) && Objects.equals(this.manifestEncodingAsString(), other.manifestEncodingAsString());
    }

    public String toString() {
        return ToString.builder((String)"MsSmoothGroupSettings").add("AudioDeduplication", (Object)this.audioDeduplicationAsString()).add("Destination", (Object)this.destination()).add("Encryption", (Object)this.encryption()).add("FragmentLength", (Object)this.fragmentLength()).add("ManifestEncoding", (Object)this.manifestEncodingAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDeduplication": {
                return Optional.of(clazz.cast(this.audioDeduplicationAsString()));
            }
            case "Destination": {
                return Optional.of(clazz.cast(this.destination()));
            }
            case "Encryption": {
                return Optional.of(clazz.cast(this.encryption()));
            }
            case "FragmentLength": {
                return Optional.of(clazz.cast(this.fragmentLength()));
            }
            case "ManifestEncoding": {
                return Optional.of(clazz.cast(this.manifestEncodingAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MsSmoothGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioDeduplication;
        private String destination;
        private MsSmoothEncryptionSettings encryption;
        private Integer fragmentLength;
        private String manifestEncoding;

        private BuilderImpl() {
        }

        private BuilderImpl(MsSmoothGroupSettings model) {
            this.audioDeduplication(model.audioDeduplication);
            this.destination(model.destination);
            this.encryption(model.encryption);
            this.fragmentLength(model.fragmentLength);
            this.manifestEncoding(model.manifestEncoding);
        }

        public final String getAudioDeduplication() {
            return this.audioDeduplication;
        }

        @Override
        public final Builder audioDeduplication(String audioDeduplication) {
            this.audioDeduplication = audioDeduplication;
            return this;
        }

        @Override
        public final Builder audioDeduplication(MsSmoothAudioDeduplication audioDeduplication) {
            this.audioDeduplication(audioDeduplication.toString());
            return this;
        }

        public final void setAudioDeduplication(String audioDeduplication) {
            this.audioDeduplication = audioDeduplication;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final MsSmoothEncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(MsSmoothEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(MsSmoothEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getFragmentLength() {
            return this.fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        public final String getManifestEncoding() {
            return this.manifestEncoding;
        }

        @Override
        public final Builder manifestEncoding(String manifestEncoding) {
            this.manifestEncoding = manifestEncoding;
            return this;
        }

        @Override
        public final Builder manifestEncoding(MsSmoothManifestEncoding manifestEncoding) {
            this.manifestEncoding(manifestEncoding.toString());
            return this;
        }

        public final void setManifestEncoding(String manifestEncoding) {
            this.manifestEncoding = manifestEncoding;
        }

        public MsSmoothGroupSettings build() {
            return new MsSmoothGroupSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MsSmoothGroupSettings> {
        public Builder audioDeduplication(String var1);

        public Builder audioDeduplication(MsSmoothAudioDeduplication var1);

        public Builder destination(String var1);

        public Builder encryption(MsSmoothEncryptionSettings var1);

        default public Builder encryption(Consumer<MsSmoothEncryptionSettings.Builder> encryption) {
            return this.encryption((MsSmoothEncryptionSettings)((MsSmoothEncryptionSettings.Builder)MsSmoothEncryptionSettings.builder().apply(encryption)).build());
        }

        public Builder fragmentLength(Integer var1);

        public Builder manifestEncoding(String var1);

        public Builder manifestEncoding(MsSmoothManifestEncoding var1);
    }
}

