/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.AacAudioDescriptionBroadcasterMix;
import software.amazon.awssdk.services.mediaconvert.model.AacCodecProfile;
import software.amazon.awssdk.services.mediaconvert.model.AacCodingMode;
import software.amazon.awssdk.services.mediaconvert.model.AacRateControlMode;
import software.amazon.awssdk.services.mediaconvert.model.AacRawFormat;
import software.amazon.awssdk.services.mediaconvert.model.AacSpecification;
import software.amazon.awssdk.services.mediaconvert.model.AacVbrQuality;
import software.amazon.awssdk.services.mediaconvert.transform.AacSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AacSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, AacSettings> {
    private final String audioDescriptionBroadcasterMix;
    private final Integer bitrate;
    private final String codecProfile;
    private final String codingMode;
    private final String rateControlMode;
    private final String rawFormat;
    private final Integer sampleRate;
    private final String specification;
    private final String vbrQuality;

    private AacSettings(BuilderImpl builder) {
        this.audioDescriptionBroadcasterMix = builder.audioDescriptionBroadcasterMix;
        this.bitrate = builder.bitrate;
        this.codecProfile = builder.codecProfile;
        this.codingMode = builder.codingMode;
        this.rateControlMode = builder.rateControlMode;
        this.rawFormat = builder.rawFormat;
        this.sampleRate = builder.sampleRate;
        this.specification = builder.specification;
        this.vbrQuality = builder.vbrQuality;
    }

    public AacAudioDescriptionBroadcasterMix audioDescriptionBroadcasterMix() {
        return AacAudioDescriptionBroadcasterMix.fromValue(this.audioDescriptionBroadcasterMix);
    }

    public String audioDescriptionBroadcasterMixAsString() {
        return this.audioDescriptionBroadcasterMix;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public AacCodecProfile codecProfile() {
        return AacCodecProfile.fromValue(this.codecProfile);
    }

    public String codecProfileAsString() {
        return this.codecProfile;
    }

    public AacCodingMode codingMode() {
        return AacCodingMode.fromValue(this.codingMode);
    }

    public String codingModeAsString() {
        return this.codingMode;
    }

    public AacRateControlMode rateControlMode() {
        return AacRateControlMode.fromValue(this.rateControlMode);
    }

    public String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public AacRawFormat rawFormat() {
        return AacRawFormat.fromValue(this.rawFormat);
    }

    public String rawFormatAsString() {
        return this.rawFormat;
    }

    public Integer sampleRate() {
        return this.sampleRate;
    }

    public AacSpecification specification() {
        return AacSpecification.fromValue(this.specification);
    }

    public String specificationAsString() {
        return this.specification;
    }

    public AacVbrQuality vbrQuality() {
        return AacVbrQuality.fromValue(this.vbrQuality);
    }

    public String vbrQualityAsString() {
        return this.vbrQuality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDescriptionBroadcasterMixAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.specificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vbrQualityAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AacSettings)) {
            return false;
        }
        AacSettings other = (AacSettings)obj;
        return Objects.equals(this.audioDescriptionBroadcasterMixAsString(), other.audioDescriptionBroadcasterMixAsString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.codecProfileAsString(), other.codecProfileAsString()) && Objects.equals(this.codingModeAsString(), other.codingModeAsString()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString()) && Objects.equals(this.rawFormatAsString(), other.rawFormatAsString()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.specificationAsString(), other.specificationAsString()) && Objects.equals(this.vbrQualityAsString(), other.vbrQualityAsString());
    }

    public String toString() {
        return ToString.builder((String)"AacSettings").add("AudioDescriptionBroadcasterMix", (Object)this.audioDescriptionBroadcasterMixAsString()).add("Bitrate", (Object)this.bitrate()).add("CodecProfile", (Object)this.codecProfileAsString()).add("CodingMode", (Object)this.codingModeAsString()).add("RateControlMode", (Object)this.rateControlModeAsString()).add("RawFormat", (Object)this.rawFormatAsString()).add("SampleRate", (Object)this.sampleRate()).add("Specification", (Object)this.specificationAsString()).add("VbrQuality", (Object)this.vbrQualityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDescriptionBroadcasterMix": {
                return Optional.of(clazz.cast(this.audioDescriptionBroadcasterMixAsString()));
            }
            case "Bitrate": {
                return Optional.of(clazz.cast(this.bitrate()));
            }
            case "CodecProfile": {
                return Optional.of(clazz.cast(this.codecProfileAsString()));
            }
            case "CodingMode": {
                return Optional.of(clazz.cast(this.codingModeAsString()));
            }
            case "RateControlMode": {
                return Optional.of(clazz.cast(this.rateControlModeAsString()));
            }
            case "RawFormat": {
                return Optional.of(clazz.cast(this.rawFormatAsString()));
            }
            case "SampleRate": {
                return Optional.of(clazz.cast(this.sampleRate()));
            }
            case "Specification": {
                return Optional.of(clazz.cast(this.specificationAsString()));
            }
            case "VbrQuality": {
                return Optional.of(clazz.cast(this.vbrQualityAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AacSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioDescriptionBroadcasterMix;
        private Integer bitrate;
        private String codecProfile;
        private String codingMode;
        private String rateControlMode;
        private String rawFormat;
        private Integer sampleRate;
        private String specification;
        private String vbrQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(AacSettings model) {
            this.audioDescriptionBroadcasterMix(model.audioDescriptionBroadcasterMix);
            this.bitrate(model.bitrate);
            this.codecProfile(model.codecProfile);
            this.codingMode(model.codingMode);
            this.rateControlMode(model.rateControlMode);
            this.rawFormat(model.rawFormat);
            this.sampleRate(model.sampleRate);
            this.specification(model.specification);
            this.vbrQuality(model.vbrQuality);
        }

        public final String getAudioDescriptionBroadcasterMix() {
            return this.audioDescriptionBroadcasterMix;
        }

        @Override
        public final Builder audioDescriptionBroadcasterMix(String audioDescriptionBroadcasterMix) {
            this.audioDescriptionBroadcasterMix = audioDescriptionBroadcasterMix;
            return this;
        }

        @Override
        public final Builder audioDescriptionBroadcasterMix(AacAudioDescriptionBroadcasterMix audioDescriptionBroadcasterMix) {
            this.audioDescriptionBroadcasterMix(audioDescriptionBroadcasterMix.toString());
            return this;
        }

        public final void setAudioDescriptionBroadcasterMix(String audioDescriptionBroadcasterMix) {
            this.audioDescriptionBroadcasterMix = audioDescriptionBroadcasterMix;
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodecProfile() {
            return this.codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(AacCodecProfile codecProfile) {
            this.codecProfile(codecProfile.toString());
            return this;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        public final String getCodingMode() {
            return this.codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(AacCodingMode codingMode) {
            this.codingMode(codingMode.toString());
            return this;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(AacRateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final String getRawFormat() {
            return this.rawFormat;
        }

        @Override
        public final Builder rawFormat(String rawFormat) {
            this.rawFormat = rawFormat;
            return this;
        }

        @Override
        public final Builder rawFormat(AacRawFormat rawFormat) {
            this.rawFormat(rawFormat.toString());
            return this;
        }

        public final void setRawFormat(String rawFormat) {
            this.rawFormat = rawFormat;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final String getSpecification() {
            return this.specification;
        }

        @Override
        public final Builder specification(String specification) {
            this.specification = specification;
            return this;
        }

        @Override
        public final Builder specification(AacSpecification specification) {
            this.specification(specification.toString());
            return this;
        }

        public final void setSpecification(String specification) {
            this.specification = specification;
        }

        public final String getVbrQuality() {
            return this.vbrQuality;
        }

        @Override
        public final Builder vbrQuality(String vbrQuality) {
            this.vbrQuality = vbrQuality;
            return this;
        }

        @Override
        public final Builder vbrQuality(AacVbrQuality vbrQuality) {
            this.vbrQuality(vbrQuality.toString());
            return this;
        }

        public final void setVbrQuality(String vbrQuality) {
            this.vbrQuality = vbrQuality;
        }

        public AacSettings build() {
            return new AacSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AacSettings> {
        public Builder audioDescriptionBroadcasterMix(String var1);

        public Builder audioDescriptionBroadcasterMix(AacAudioDescriptionBroadcasterMix var1);

        public Builder bitrate(Integer var1);

        public Builder codecProfile(String var1);

        public Builder codecProfile(AacCodecProfile var1);

        public Builder codingMode(String var1);

        public Builder codingMode(AacCodingMode var1);

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(AacRateControlMode var1);

        public Builder rawFormat(String var1);

        public Builder rawFormat(AacRawFormat var1);

        public Builder sampleRate(Integer var1);

        public Builder specification(String var1);

        public Builder specification(AacSpecification var1);

        public Builder vbrQuality(String var1);

        public Builder vbrQuality(AacVbrQuality var1);
    }
}

