/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the VPC interfaces that you want to add to the flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcInterfaceRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcInterfaceRequest.Builder, VpcInterfaceRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(VpcInterfaceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceType").getter(getter(VpcInterfaceRequest::networkInterfaceTypeAsString))
            .setter(setter(Builder::networkInterfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceType").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(VpcInterfaceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(VpcInterfaceRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(VpcInterfaceRequest::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()).build();

    private static final SdkField<Map<String, String>> VPC_INTERFACE_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("VpcInterfaceTags")
            .getter(getter(VpcInterfaceRequest::vpcInterfaceTags))
            .setter(setter(Builder::vpcInterfaceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            NETWORK_INTERFACE_TYPE_FIELD, ROLE_ARN_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD, VPC_INTERFACE_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String networkInterfaceType;

    private final String roleArn;

    private final List<String> securityGroupIds;

    private final String subnetId;

    private final Map<String, String> vpcInterfaceTags;

    private VpcInterfaceRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.networkInterfaceType = builder.networkInterfaceType;
        this.roleArn = builder.roleArn;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.vpcInterfaceTags = builder.vpcInterfaceTags;
    }

    /**
     * <p>
     * The name for the VPC interface. This name must be unique within the flow.
     * </p>
     * 
     * @return The name for the VPC interface. This name must be unique within the flow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #networkInterfaceType} will return {@link NetworkInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #networkInterfaceTypeAsString}.
     * </p>
     * 
     * @return The type of network interface.
     * @see NetworkInterfaceType
     */
    public final NetworkInterfaceType networkInterfaceType() {
        return NetworkInterfaceType.fromValue(networkInterfaceType);
    }

    /**
     * <p>
     * The type of network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #networkInterfaceType} will return {@link NetworkInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #networkInterfaceTypeAsString}.
     * </p>
     * 
     * @return The type of network interface.
     * @see NetworkInterfaceType
     */
    public final String networkInterfaceTypeAsString() {
        return networkInterfaceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role that you created when you set up MediaConnect as a trusted service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role that you created when you set up MediaConnect as a trusted
     *         service.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A virtual firewall to control inbound and outbound traffic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return A virtual firewall to control inbound and outbound traffic.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The subnet IDs that you want to use for your VPC interface. A range of IP addresses in your VPC. When you create
     * your VPC, you specify a range of IPv4 addresses for the VPC in the form of a Classless Inter-Domain Routing
     * (CIDR) block; for example, 10.0.0.0/16. This is the primary CIDR block for your VPC. When you create a subnet for
     * your VPC, you specify the CIDR block for the subnet, which is a subset of the VPC CIDR block. The subnets that
     * you use across all VPC interfaces on the flow must be in the same Availability Zone as the flow.
     * </p>
     * 
     * @return The subnet IDs that you want to use for your VPC interface. A range of IP addresses in your VPC. When you
     *         create your VPC, you specify a range of IPv4 addresses for the VPC in the form of a Classless
     *         Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16. This is the primary CIDR block for your VPC.
     *         When you create a subnet for your VPC, you specify the CIDR block for the subnet, which is a subset of
     *         the VPC CIDR block. The subnets that you use across all VPC interfaces on the flow must be in the same
     *         Availability Zone as the flow.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcInterfaceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcInterfaceTags() {
        return vpcInterfaceTags != null && !(vpcInterfaceTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value pairs that can be used to tag and organize the VPC network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcInterfaceTags} method.
     * </p>
     * 
     * @return The key-value pairs that can be used to tag and organize the VPC network interface.
     */
    public final Map<String, String> vpcInterfaceTags() {
        return vpcInterfaceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcInterfaceTags() ? vpcInterfaceTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcInterfaceRequest)) {
            return false;
        }
        VpcInterfaceRequest other = (VpcInterfaceRequest) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(networkInterfaceTypeAsString(), other.networkInterfaceTypeAsString())
                && Objects.equals(roleArn(), other.roleArn()) && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(subnetId(), other.subnetId())
                && hasVpcInterfaceTags() == other.hasVpcInterfaceTags()
                && Objects.equals(vpcInterfaceTags(), other.vpcInterfaceTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcInterfaceRequest").add("Name", name())
                .add("NetworkInterfaceType", networkInterfaceTypeAsString()).add("RoleArn", roleArn())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("SubnetId", subnetId())
                .add("VpcInterfaceTags", hasVpcInterfaceTags() ? vpcInterfaceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkInterfaceType":
            return Optional.ofNullable(clazz.cast(networkInterfaceTypeAsString()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "VpcInterfaceTags":
            return Optional.ofNullable(clazz.cast(vpcInterfaceTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("networkInterfaceType", NETWORK_INTERFACE_TYPE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("subnetId", SUBNET_ID_FIELD);
        map.put("vpcInterfaceTags", VPC_INTERFACE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcInterfaceRequest, T> g) {
        return obj -> g.apply((VpcInterfaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcInterfaceRequest> {
        /**
         * <p>
         * The name for the VPC interface. This name must be unique within the flow.
         * </p>
         * 
         * @param name
         *        The name for the VPC interface. This name must be unique within the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of network interface.
         * </p>
         * 
         * @param networkInterfaceType
         *        The type of network interface.
         * @see NetworkInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceType
         */
        Builder networkInterfaceType(String networkInterfaceType);

        /**
         * <p>
         * The type of network interface.
         * </p>
         * 
         * @param networkInterfaceType
         *        The type of network interface.
         * @see NetworkInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceType
         */
        Builder networkInterfaceType(NetworkInterfaceType networkInterfaceType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role that you created when you set up MediaConnect as a trusted
         * service.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role that you created when you set up MediaConnect as a trusted
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A virtual firewall to control inbound and outbound traffic.
         * </p>
         * 
         * @param securityGroupIds
         *        A virtual firewall to control inbound and outbound traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A virtual firewall to control inbound and outbound traffic.
         * </p>
         * 
         * @param securityGroupIds
         *        A virtual firewall to control inbound and outbound traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The subnet IDs that you want to use for your VPC interface. A range of IP addresses in your VPC. When you
         * create your VPC, you specify a range of IPv4 addresses for the VPC in the form of a Classless Inter-Domain
         * Routing (CIDR) block; for example, 10.0.0.0/16. This is the primary CIDR block for your VPC. When you create
         * a subnet for your VPC, you specify the CIDR block for the subnet, which is a subset of the VPC CIDR block.
         * The subnets that you use across all VPC interfaces on the flow must be in the same Availability Zone as the
         * flow.
         * </p>
         * 
         * @param subnetId
         *        The subnet IDs that you want to use for your VPC interface. A range of IP addresses in your VPC. When
         *        you create your VPC, you specify a range of IPv4 addresses for the VPC in the form of a Classless
         *        Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16. This is the primary CIDR block for your
         *        VPC. When you create a subnet for your VPC, you specify the CIDR block for the subnet, which is a
         *        subset of the VPC CIDR block. The subnets that you use across all VPC interfaces on the flow must be
         *        in the same Availability Zone as the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The key-value pairs that can be used to tag and organize the VPC network interface.
         * </p>
         * 
         * @param vpcInterfaceTags
         *        The key-value pairs that can be used to tag and organize the VPC network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaceTags(Map<String, String> vpcInterfaceTags);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String networkInterfaceType;

        private String roleArn;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private Map<String, String> vpcInterfaceTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcInterfaceRequest model) {
            name(model.name);
            networkInterfaceType(model.networkInterfaceType);
            roleArn(model.roleArn);
            securityGroupIds(model.securityGroupIds);
            subnetId(model.subnetId);
            vpcInterfaceTags(model.vpcInterfaceTags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkInterfaceType() {
            return networkInterfaceType;
        }

        public final void setNetworkInterfaceType(String networkInterfaceType) {
            this.networkInterfaceType = networkInterfaceType;
        }

        @Override
        public final Builder networkInterfaceType(String networkInterfaceType) {
            this.networkInterfaceType = networkInterfaceType;
            return this;
        }

        @Override
        public final Builder networkInterfaceType(NetworkInterfaceType networkInterfaceType) {
            this.networkInterfaceType(networkInterfaceType == null ? null : networkInterfaceType.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ___listOfStringCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ___listOfStringCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Map<String, String> getVpcInterfaceTags() {
            if (vpcInterfaceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return vpcInterfaceTags;
        }

        public final void setVpcInterfaceTags(Map<String, String> vpcInterfaceTags) {
            this.vpcInterfaceTags = ___mapOfStringCopier.copy(vpcInterfaceTags);
        }

        @Override
        public final Builder vpcInterfaceTags(Map<String, String> vpcInterfaceTags) {
            this.vpcInterfaceTags = ___mapOfStringCopier.copy(vpcInterfaceTags);
            return this;
        }

        @Override
        public VpcInterfaceRequest build() {
            return new VpcInterfaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
