/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRouterOutputRequest extends MediaConnectRequest implements
        ToCopyableBuilder<UpdateRouterOutputRequest.Builder, UpdateRouterOutputRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateRouterOutputRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateRouterOutputRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<RouterOutputConfiguration> CONFIGURATION_FIELD = SdkField
            .<RouterOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(UpdateRouterOutputRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(RouterOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<Long> MAXIMUM_BITRATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaximumBitrate").getter(getter(UpdateRouterOutputRequest::maximumBitrate))
            .setter(setter(Builder::maximumBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBitrate").build()).build();

    private static final SdkField<String> ROUTING_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingScope").getter(getter(UpdateRouterOutputRequest::routingScopeAsString))
            .setter(setter(Builder::routingScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingScope").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tier")
            .getter(getter(UpdateRouterOutputRequest::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()).build();

    private static final SdkField<MaintenanceConfiguration> MAINTENANCE_CONFIGURATION_FIELD = SdkField
            .<MaintenanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("MaintenanceConfiguration")
            .getter(getter(UpdateRouterOutputRequest::maintenanceConfiguration))
            .setter(setter(Builder::maintenanceConfiguration)).constructor(MaintenanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            CONFIGURATION_FIELD, MAXIMUM_BITRATE_FIELD, ROUTING_SCOPE_FIELD, TIER_FIELD, MAINTENANCE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final RouterOutputConfiguration configuration;

    private final Long maximumBitrate;

    private final String routingScope;

    private final String tier;

    private final MaintenanceConfiguration maintenanceConfiguration;

    private UpdateRouterOutputRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.maximumBitrate = builder.maximumBitrate;
        this.routingScope = builder.routingScope;
        this.tier = builder.tier;
        this.maintenanceConfiguration = builder.maintenanceConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the router output that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the router output that you want to update.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The updated name for the router output.
     * </p>
     * 
     * @return The updated name for the router output.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated configuration settings for the router output. Changing the type of the configuration is not
     * supported.
     * </p>
     * 
     * @return The updated configuration settings for the router output. Changing the type of the configuration is not
     *         supported.
     */
    public final RouterOutputConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The updated maximum bitrate for the router output.
     * </p>
     * 
     * @return The updated maximum bitrate for the router output.
     */
    public final Long maximumBitrate() {
        return maximumBitrate;
    }

    /**
     * <p>
     * Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default) - can only
     * take inputs from same Region. GLOBAL - can take inputs from any Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routingScope} will
     * return {@link RoutingScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routingScopeAsString}.
     * </p>
     * 
     * @return Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default) -
     *         can only take inputs from same Region. GLOBAL - can take inputs from any Region.
     * @see RoutingScope
     */
    public final RoutingScope routingScope() {
        return RoutingScope.fromValue(routingScope);
    }

    /**
     * <p>
     * Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default) - can only
     * take inputs from same Region. GLOBAL - can take inputs from any Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routingScope} will
     * return {@link RoutingScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routingScopeAsString}.
     * </p>
     * 
     * @return Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default) -
     *         can only take inputs from same Region. GLOBAL - can take inputs from any Region.
     * @see RoutingScope
     */
    public final String routingScopeAsString() {
        return routingScope;
    }

    /**
     * <p>
     * The updated tier level for the router output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link RouterOutputTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The updated tier level for the router output.
     * @see RouterOutputTier
     */
    public final RouterOutputTier tier() {
        return RouterOutputTier.fromValue(tier);
    }

    /**
     * <p>
     * The updated tier level for the router output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link RouterOutputTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The updated tier level for the router output.
     * @see RouterOutputTier
     */
    public final String tierAsString() {
        return tier;
    }

    /**
     * <p>
     * The updated maintenance configuration settings for the router output, including any changes to preferred
     * maintenance windows and schedules.
     * </p>
     * 
     * @return The updated maintenance configuration settings for the router output, including any changes to preferred
     *         maintenance windows and schedules.
     */
    public final MaintenanceConfiguration maintenanceConfiguration() {
        return maintenanceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(routingScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRouterOutputRequest)) {
            return false;
        }
        UpdateRouterOutputRequest other = (UpdateRouterOutputRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(configuration(), other.configuration())
                && Objects.equals(maximumBitrate(), other.maximumBitrate())
                && Objects.equals(routingScopeAsString(), other.routingScopeAsString())
                && Objects.equals(tierAsString(), other.tierAsString())
                && Objects.equals(maintenanceConfiguration(), other.maintenanceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRouterOutputRequest").add("Arn", arn()).add("Name", name())
                .add("Configuration", configuration()).add("MaximumBitrate", maximumBitrate())
                .add("RoutingScope", routingScopeAsString()).add("Tier", tierAsString())
                .add("MaintenanceConfiguration", maintenanceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "MaximumBitrate":
            return Optional.ofNullable(clazz.cast(maximumBitrate()));
        case "RoutingScope":
            return Optional.ofNullable(clazz.cast(routingScopeAsString()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "MaintenanceConfiguration":
            return Optional.ofNullable(clazz.cast(maintenanceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("maximumBitrate", MAXIMUM_BITRATE_FIELD);
        map.put("routingScope", ROUTING_SCOPE_FIELD);
        map.put("tier", TIER_FIELD);
        map.put("maintenanceConfiguration", MAINTENANCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRouterOutputRequest, T> g) {
        return obj -> g.apply((UpdateRouterOutputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRouterOutputRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the router output that you want to update.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the router output that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The updated name for the router output.
         * </p>
         * 
         * @param name
         *        The updated name for the router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated configuration settings for the router output. Changing the type of the configuration is not
         * supported.
         * </p>
         * 
         * @param configuration
         *        The updated configuration settings for the router output. Changing the type of the configuration is
         *        not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(RouterOutputConfiguration configuration);

        /**
         * <p>
         * The updated configuration settings for the router output. Changing the type of the configuration is not
         * supported.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouterOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link RouterOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouterOutputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(RouterOutputConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link RouterOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(RouterOutputConfiguration)
         */
        default Builder configuration(Consumer<RouterOutputConfiguration.Builder> configuration) {
            return configuration(RouterOutputConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The updated maximum bitrate for the router output.
         * </p>
         * 
         * @param maximumBitrate
         *        The updated maximum bitrate for the router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBitrate(Long maximumBitrate);

        /**
         * <p>
         * Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default) - can
         * only take inputs from same Region. GLOBAL - can take inputs from any Region.
         * </p>
         * 
         * @param routingScope
         *        Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default)
         *        - can only take inputs from same Region. GLOBAL - can take inputs from any Region.
         * @see RoutingScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingScope
         */
        Builder routingScope(String routingScope);

        /**
         * <p>
         * Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default) - can
         * only take inputs from same Region. GLOBAL - can take inputs from any Region.
         * </p>
         * 
         * @param routingScope
         *        Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default)
         *        - can only take inputs from same Region. GLOBAL - can take inputs from any Region.
         * @see RoutingScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingScope
         */
        Builder routingScope(RoutingScope routingScope);

        /**
         * <p>
         * The updated tier level for the router output.
         * </p>
         * 
         * @param tier
         *        The updated tier level for the router output.
         * @see RouterOutputTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterOutputTier
         */
        Builder tier(String tier);

        /**
         * <p>
         * The updated tier level for the router output.
         * </p>
         * 
         * @param tier
         *        The updated tier level for the router output.
         * @see RouterOutputTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterOutputTier
         */
        Builder tier(RouterOutputTier tier);

        /**
         * <p>
         * The updated maintenance configuration settings for the router output, including any changes to preferred
         * maintenance windows and schedules.
         * </p>
         * 
         * @param maintenanceConfiguration
         *        The updated maintenance configuration settings for the router output, including any changes to
         *        preferred maintenance windows and schedules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceConfiguration(MaintenanceConfiguration maintenanceConfiguration);

        /**
         * <p>
         * The updated maintenance configuration settings for the router output, including any changes to preferred
         * maintenance windows and schedules.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaintenanceConfiguration.Builder}
         * avoiding the need to create one manually via {@link MaintenanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #maintenanceConfiguration(MaintenanceConfiguration)}.
         * 
         * @param maintenanceConfiguration
         *        a consumer that will call methods on {@link MaintenanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceConfiguration(MaintenanceConfiguration)
         */
        default Builder maintenanceConfiguration(Consumer<MaintenanceConfiguration.Builder> maintenanceConfiguration) {
            return maintenanceConfiguration(MaintenanceConfiguration.builder().applyMutation(maintenanceConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private RouterOutputConfiguration configuration;

        private Long maximumBitrate;

        private String routingScope;

        private String tier;

        private MaintenanceConfiguration maintenanceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRouterOutputRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            configuration(model.configuration);
            maximumBitrate(model.maximumBitrate);
            routingScope(model.routingScope);
            tier(model.tier);
            maintenanceConfiguration(model.maintenanceConfiguration);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RouterOutputConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(RouterOutputConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RouterOutputConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Long getMaximumBitrate() {
            return maximumBitrate;
        }

        public final void setMaximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        public final String getRoutingScope() {
            return routingScope;
        }

        public final void setRoutingScope(String routingScope) {
            this.routingScope = routingScope;
        }

        @Override
        public final Builder routingScope(String routingScope) {
            this.routingScope = routingScope;
            return this;
        }

        @Override
        public final Builder routingScope(RoutingScope routingScope) {
            this.routingScope(routingScope == null ? null : routingScope.toString());
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(RouterOutputTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final MaintenanceConfiguration.Builder getMaintenanceConfiguration() {
            return maintenanceConfiguration != null ? maintenanceConfiguration.toBuilder() : null;
        }

        public final void setMaintenanceConfiguration(MaintenanceConfiguration.BuilderImpl maintenanceConfiguration) {
            this.maintenanceConfiguration = maintenanceConfiguration != null ? maintenanceConfiguration.build() : null;
        }

        @Override
        public final Builder maintenanceConfiguration(MaintenanceConfiguration maintenanceConfiguration) {
            this.maintenanceConfiguration = maintenanceConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRouterOutputRequest build() {
            return new UpdateRouterOutputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
