/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for source failover.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFailoverConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateFailoverConfig.Builder, UpdateFailoverConfig> {
    private static final SdkField<String> FAILOVER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailoverMode").getter(getter(UpdateFailoverConfig::failoverModeAsString))
            .setter(setter(Builder::failoverMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failoverMode").build()).build();

    private static final SdkField<Integer> RECOVERY_WINDOW_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RecoveryWindow").getter(getter(UpdateFailoverConfig::recoveryWindow))
            .setter(setter(Builder::recoveryWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryWindow").build()).build();

    private static final SdkField<SourcePriority> SOURCE_PRIORITY_FIELD = SdkField
            .<SourcePriority> builder(MarshallingType.SDK_POJO).memberName("SourcePriority")
            .getter(getter(UpdateFailoverConfig::sourcePriority)).setter(setter(Builder::sourcePriority))
            .constructor(SourcePriority::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePriority").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(UpdateFailoverConfig::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILOVER_MODE_FIELD,
            RECOVERY_WINDOW_FIELD, SOURCE_PRIORITY_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String failoverMode;

    private final Integer recoveryWindow;

    private final SourcePriority sourcePriority;

    private final String state;

    private UpdateFailoverConfig(BuilderImpl builder) {
        this.failoverMode = builder.failoverMode;
        this.recoveryWindow = builder.recoveryWindow;
        this.sourcePriority = builder.sourcePriority;
        this.state = builder.state;
    }

    /**
     * <p>
     * The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing
     * graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failoverMode} will
     * return {@link FailoverMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failoverModeAsString}.
     * </p>
     * 
     * @return The type of failover you choose for this flow. MERGE combines the source streams into a single stream,
     *         allowing graceful recovery from any single-source loss. FAILOVER allows switching between different
     *         streams.
     * @see FailoverMode
     */
    public final FailoverMode failoverMode() {
        return FailoverMode.fromValue(failoverMode);
    }

    /**
     * <p>
     * The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing
     * graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failoverMode} will
     * return {@link FailoverMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failoverModeAsString}.
     * </p>
     * 
     * @return The type of failover you choose for this flow. MERGE combines the source streams into a single stream,
     *         allowing graceful recovery from any single-source loss. FAILOVER allows switching between different
     *         streams.
     * @see FailoverMode
     */
    public final String failoverModeAsString() {
        return failoverMode;
    }

    /**
     * <p>
     * Recovery window time to look for dash-7 packets.
     * </p>
     * 
     * @return Recovery window time to look for dash-7 packets.
     */
    public final Integer recoveryWindow() {
        return recoveryWindow;
    }

    /**
     * <p>
     * The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally
     * prioritized streams.
     * </p>
     * 
     * @return The priority you want to assign to a source. You can have a primary stream and a backup stream or two
     *         equally prioritized streams.
     */
    public final SourcePriority sourcePriority() {
        return sourcePriority;
    }

    /**
     * <p>
     * The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the
     * state is active, the flow can have one or two sources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of source failover on the flow. If the state is inactive, the flow can have only one source. If
     *         the state is active, the flow can have one or two sources.
     * @see State
     */
    public final State state() {
        return State.fromValue(state);
    }

    /**
     * <p>
     * The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the
     * state is active, the flow can have one or two sources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of source failover on the flow. If the state is inactive, the flow can have only one source. If
     *         the state is active, the flow can have one or two sources.
     * @see State
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failoverModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryWindow());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePriority());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFailoverConfig)) {
            return false;
        }
        UpdateFailoverConfig other = (UpdateFailoverConfig) obj;
        return Objects.equals(failoverModeAsString(), other.failoverModeAsString())
                && Objects.equals(recoveryWindow(), other.recoveryWindow())
                && Objects.equals(sourcePriority(), other.sourcePriority())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFailoverConfig").add("FailoverMode", failoverModeAsString())
                .add("RecoveryWindow", recoveryWindow()).add("SourcePriority", sourcePriority()).add("State", stateAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailoverMode":
            return Optional.ofNullable(clazz.cast(failoverModeAsString()));
        case "RecoveryWindow":
            return Optional.ofNullable(clazz.cast(recoveryWindow()));
        case "SourcePriority":
            return Optional.ofNullable(clazz.cast(sourcePriority()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("failoverMode", FAILOVER_MODE_FIELD);
        map.put("recoveryWindow", RECOVERY_WINDOW_FIELD);
        map.put("sourcePriority", SOURCE_PRIORITY_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFailoverConfig, T> g) {
        return obj -> g.apply((UpdateFailoverConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateFailoverConfig> {
        /**
         * <p>
         * The type of failover you choose for this flow. MERGE combines the source streams into a single stream,
         * allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
         * </p>
         * 
         * @param failoverMode
         *        The type of failover you choose for this flow. MERGE combines the source streams into a single stream,
         *        allowing graceful recovery from any single-source loss. FAILOVER allows switching between different
         *        streams.
         * @see FailoverMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailoverMode
         */
        Builder failoverMode(String failoverMode);

        /**
         * <p>
         * The type of failover you choose for this flow. MERGE combines the source streams into a single stream,
         * allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
         * </p>
         * 
         * @param failoverMode
         *        The type of failover you choose for this flow. MERGE combines the source streams into a single stream,
         *        allowing graceful recovery from any single-source loss. FAILOVER allows switching between different
         *        streams.
         * @see FailoverMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailoverMode
         */
        Builder failoverMode(FailoverMode failoverMode);

        /**
         * <p>
         * Recovery window time to look for dash-7 packets.
         * </p>
         * 
         * @param recoveryWindow
         *        Recovery window time to look for dash-7 packets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryWindow(Integer recoveryWindow);

        /**
         * <p>
         * The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally
         * prioritized streams.
         * </p>
         * 
         * @param sourcePriority
         *        The priority you want to assign to a source. You can have a primary stream and a backup stream or two
         *        equally prioritized streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePriority(SourcePriority sourcePriority);

        /**
         * <p>
         * The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally
         * prioritized streams.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourcePriority.Builder} avoiding the need
         * to create one manually via {@link SourcePriority#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourcePriority.Builder#build()} is called immediately and its
         * result is passed to {@link #sourcePriority(SourcePriority)}.
         * 
         * @param sourcePriority
         *        a consumer that will call methods on {@link SourcePriority.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourcePriority(SourcePriority)
         */
        default Builder sourcePriority(Consumer<SourcePriority.Builder> sourcePriority) {
            return sourcePriority(SourcePriority.builder().applyMutation(sourcePriority).build());
        }

        /**
         * <p>
         * The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the
         * state is active, the flow can have one or two sources.
         * </p>
         * 
         * @param state
         *        The state of source failover on the flow. If the state is inactive, the flow can have only one source.
         *        If the state is active, the flow can have one or two sources.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the
         * state is active, the flow can have one or two sources.
         * </p>
         * 
         * @param state
         *        The state of source failover on the flow. If the state is inactive, the flow can have only one source.
         *        If the state is active, the flow can have one or two sources.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);
    }

    static final class BuilderImpl implements Builder {
        private String failoverMode;

        private Integer recoveryWindow;

        private SourcePriority sourcePriority;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFailoverConfig model) {
            failoverMode(model.failoverMode);
            recoveryWindow(model.recoveryWindow);
            sourcePriority(model.sourcePriority);
            state(model.state);
        }

        public final String getFailoverMode() {
            return failoverMode;
        }

        public final void setFailoverMode(String failoverMode) {
            this.failoverMode = failoverMode;
        }

        @Override
        public final Builder failoverMode(String failoverMode) {
            this.failoverMode = failoverMode;
            return this;
        }

        @Override
        public final Builder failoverMode(FailoverMode failoverMode) {
            this.failoverMode(failoverMode == null ? null : failoverMode.toString());
            return this;
        }

        public final Integer getRecoveryWindow() {
            return recoveryWindow;
        }

        public final void setRecoveryWindow(Integer recoveryWindow) {
            this.recoveryWindow = recoveryWindow;
        }

        @Override
        public final Builder recoveryWindow(Integer recoveryWindow) {
            this.recoveryWindow = recoveryWindow;
            return this;
        }

        public final SourcePriority.Builder getSourcePriority() {
            return sourcePriority != null ? sourcePriority.toBuilder() : null;
        }

        public final void setSourcePriority(SourcePriority.BuilderImpl sourcePriority) {
            this.sourcePriority = sourcePriority != null ? sourcePriority.build() : null;
        }

        @Override
        public final Builder sourcePriority(SourcePriority sourcePriority) {
            this.sourcePriority = sourcePriority;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public UpdateFailoverConfig build() {
            return new UpdateFailoverConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
