/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TakeRouterInputResponse extends MediaConnectResponse implements
        ToCopyableBuilder<TakeRouterInputResponse.Builder, TakeRouterInputResponse> {
    private static final SdkField<String> ROUTED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutedState").getter(getter(TakeRouterInputResponse::routedStateAsString))
            .setter(setter(Builder::routedState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routedState").build()).build();

    private static final SdkField<String> ROUTER_OUTPUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouterOutputArn").getter(getter(TakeRouterInputResponse::routerOutputArn))
            .setter(setter(Builder::routerOutputArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerOutputArn").build()).build();

    private static final SdkField<String> ROUTER_OUTPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouterOutputName").getter(getter(TakeRouterInputResponse::routerOutputName))
            .setter(setter(Builder::routerOutputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerOutputName").build()).build();

    private static final SdkField<String> ROUTER_INPUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouterInputArn").getter(getter(TakeRouterInputResponse::routerInputArn))
            .setter(setter(Builder::routerInputArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerInputArn").build()).build();

    private static final SdkField<String> ROUTER_INPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouterInputName").getter(getter(TakeRouterInputResponse::routerInputName))
            .setter(setter(Builder::routerInputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerInputName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTED_STATE_FIELD,
            ROUTER_OUTPUT_ARN_FIELD, ROUTER_OUTPUT_NAME_FIELD, ROUTER_INPUT_ARN_FIELD, ROUTER_INPUT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String routedState;

    private final String routerOutputArn;

    private final String routerOutputName;

    private final String routerInputArn;

    private final String routerInputName;

    private TakeRouterInputResponse(BuilderImpl builder) {
        super(builder);
        this.routedState = builder.routedState;
        this.routerOutputArn = builder.routerOutputArn;
        this.routerOutputName = builder.routerOutputName;
        this.routerInputArn = builder.routerInputArn;
        this.routerInputName = builder.routerInputName;
    }

    /**
     * <p>
     * The state of the association between the router input and output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routedState} will
     * return {@link RouterOutputRoutedState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #routedStateAsString}.
     * </p>
     * 
     * @return The state of the association between the router input and output.
     * @see RouterOutputRoutedState
     */
    public final RouterOutputRoutedState routedState() {
        return RouterOutputRoutedState.fromValue(routedState);
    }

    /**
     * <p>
     * The state of the association between the router input and output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routedState} will
     * return {@link RouterOutputRoutedState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #routedStateAsString}.
     * </p>
     * 
     * @return The state of the association between the router input and output.
     * @see RouterOutputRoutedState
     */
    public final String routedStateAsString() {
        return routedState;
    }

    /**
     * <p>
     * The ARN of the associated router output.
     * </p>
     * 
     * @return The ARN of the associated router output.
     */
    public final String routerOutputArn() {
        return routerOutputArn;
    }

    /**
     * <p>
     * The name of the associated router output.
     * </p>
     * 
     * @return The name of the associated router output.
     */
    public final String routerOutputName() {
        return routerOutputName;
    }

    /**
     * <p>
     * The ARN of the associated router input.
     * </p>
     * 
     * @return The ARN of the associated router input.
     */
    public final String routerInputArn() {
        return routerInputArn;
    }

    /**
     * <p>
     * The name of the associated router input.
     * </p>
     * 
     * @return The name of the associated router input.
     */
    public final String routerInputName() {
        return routerInputName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routedStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(routerOutputArn());
        hashCode = 31 * hashCode + Objects.hashCode(routerOutputName());
        hashCode = 31 * hashCode + Objects.hashCode(routerInputArn());
        hashCode = 31 * hashCode + Objects.hashCode(routerInputName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TakeRouterInputResponse)) {
            return false;
        }
        TakeRouterInputResponse other = (TakeRouterInputResponse) obj;
        return Objects.equals(routedStateAsString(), other.routedStateAsString())
                && Objects.equals(routerOutputArn(), other.routerOutputArn())
                && Objects.equals(routerOutputName(), other.routerOutputName())
                && Objects.equals(routerInputArn(), other.routerInputArn())
                && Objects.equals(routerInputName(), other.routerInputName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TakeRouterInputResponse").add("RoutedState", routedStateAsString())
                .add("RouterOutputArn", routerOutputArn()).add("RouterOutputName", routerOutputName())
                .add("RouterInputArn", routerInputArn()).add("RouterInputName", routerInputName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoutedState":
            return Optional.ofNullable(clazz.cast(routedStateAsString()));
        case "RouterOutputArn":
            return Optional.ofNullable(clazz.cast(routerOutputArn()));
        case "RouterOutputName":
            return Optional.ofNullable(clazz.cast(routerOutputName()));
        case "RouterInputArn":
            return Optional.ofNullable(clazz.cast(routerInputArn()));
        case "RouterInputName":
            return Optional.ofNullable(clazz.cast(routerInputName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("routedState", ROUTED_STATE_FIELD);
        map.put("routerOutputArn", ROUTER_OUTPUT_ARN_FIELD);
        map.put("routerOutputName", ROUTER_OUTPUT_NAME_FIELD);
        map.put("routerInputArn", ROUTER_INPUT_ARN_FIELD);
        map.put("routerInputName", ROUTER_INPUT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TakeRouterInputResponse, T> g) {
        return obj -> g.apply((TakeRouterInputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, TakeRouterInputResponse> {
        /**
         * <p>
         * The state of the association between the router input and output.
         * </p>
         * 
         * @param routedState
         *        The state of the association between the router input and output.
         * @see RouterOutputRoutedState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterOutputRoutedState
         */
        Builder routedState(String routedState);

        /**
         * <p>
         * The state of the association between the router input and output.
         * </p>
         * 
         * @param routedState
         *        The state of the association between the router input and output.
         * @see RouterOutputRoutedState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterOutputRoutedState
         */
        Builder routedState(RouterOutputRoutedState routedState);

        /**
         * <p>
         * The ARN of the associated router output.
         * </p>
         * 
         * @param routerOutputArn
         *        The ARN of the associated router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routerOutputArn(String routerOutputArn);

        /**
         * <p>
         * The name of the associated router output.
         * </p>
         * 
         * @param routerOutputName
         *        The name of the associated router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routerOutputName(String routerOutputName);

        /**
         * <p>
         * The ARN of the associated router input.
         * </p>
         * 
         * @param routerInputArn
         *        The ARN of the associated router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routerInputArn(String routerInputArn);

        /**
         * <p>
         * The name of the associated router input.
         * </p>
         * 
         * @param routerInputName
         *        The name of the associated router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routerInputName(String routerInputName);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String routedState;

        private String routerOutputArn;

        private String routerOutputName;

        private String routerInputArn;

        private String routerInputName;

        private BuilderImpl() {
        }

        private BuilderImpl(TakeRouterInputResponse model) {
            super(model);
            routedState(model.routedState);
            routerOutputArn(model.routerOutputArn);
            routerOutputName(model.routerOutputName);
            routerInputArn(model.routerInputArn);
            routerInputName(model.routerInputName);
        }

        public final String getRoutedState() {
            return routedState;
        }

        public final void setRoutedState(String routedState) {
            this.routedState = routedState;
        }

        @Override
        public final Builder routedState(String routedState) {
            this.routedState = routedState;
            return this;
        }

        @Override
        public final Builder routedState(RouterOutputRoutedState routedState) {
            this.routedState(routedState == null ? null : routedState.toString());
            return this;
        }

        public final String getRouterOutputArn() {
            return routerOutputArn;
        }

        public final void setRouterOutputArn(String routerOutputArn) {
            this.routerOutputArn = routerOutputArn;
        }

        @Override
        public final Builder routerOutputArn(String routerOutputArn) {
            this.routerOutputArn = routerOutputArn;
            return this;
        }

        public final String getRouterOutputName() {
            return routerOutputName;
        }

        public final void setRouterOutputName(String routerOutputName) {
            this.routerOutputName = routerOutputName;
        }

        @Override
        public final Builder routerOutputName(String routerOutputName) {
            this.routerOutputName = routerOutputName;
            return this;
        }

        public final String getRouterInputArn() {
            return routerInputArn;
        }

        public final void setRouterInputArn(String routerInputArn) {
            this.routerInputArn = routerInputArn;
        }

        @Override
        public final Builder routerInputArn(String routerInputArn) {
            this.routerInputArn = routerInputArn;
            return this;
        }

        public final String getRouterInputName() {
            return routerInputName;
        }

        public final void setRouterInputName(String routerInputName) {
            this.routerInputName = routerInputName;
        }

        @Override
        public final Builder routerInputName(String routerInputName) {
            this.routerInputName = routerInputName;
            return this;
        }

        @Override
        public TakeRouterInputResponse build() {
            return new TakeRouterInputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
