/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a standard router input, including the protocol, protocol-specific configuration,
 * network interface, and availability zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StandardRouterInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StandardRouterInputConfiguration.Builder, StandardRouterInputConfiguration> {
    private static final SdkField<String> NETWORK_INTERFACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceArn").getter(getter(StandardRouterInputConfiguration::networkInterfaceArn))
            .setter(setter(Builder::networkInterfaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceArn").build())
            .build();

    private static final SdkField<RouterInputProtocolConfiguration> PROTOCOL_CONFIGURATION_FIELD = SdkField
            .<RouterInputProtocolConfiguration> builder(MarshallingType.SDK_POJO).memberName("ProtocolConfiguration")
            .getter(getter(StandardRouterInputConfiguration::protocolConfiguration))
            .setter(setter(Builder::protocolConfiguration)).constructor(RouterInputProtocolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfiguration").build())
            .build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(StandardRouterInputConfiguration::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ARN_FIELD,
            PROTOCOL_CONFIGURATION_FIELD, PROTOCOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String networkInterfaceArn;

    private final RouterInputProtocolConfiguration protocolConfiguration;

    private final String protocol;

    private StandardRouterInputConfiguration(BuilderImpl builder) {
        this.networkInterfaceArn = builder.networkInterfaceArn;
        this.protocolConfiguration = builder.protocolConfiguration;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network interface associated with the standard router input.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network interface associated with the standard router input.
     */
    public final String networkInterfaceArn() {
        return networkInterfaceArn;
    }

    /**
     * <p>
     * The configuration settings for the protocol used by the standard router input.
     * </p>
     * 
     * @return The configuration settings for the protocol used by the standard router input.
     */
    public final RouterInputProtocolConfiguration protocolConfiguration() {
        return protocolConfiguration;
    }

    /**
     * <p>
     * The protocol used by the standard router input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link RouterInputProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol used by the standard router input.
     * @see RouterInputProtocol
     */
    public final RouterInputProtocol protocol() {
        return RouterInputProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol used by the standard router input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link RouterInputProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol used by the standard router input.
     * @see RouterInputProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(protocolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardRouterInputConfiguration)) {
            return false;
        }
        StandardRouterInputConfiguration other = (StandardRouterInputConfiguration) obj;
        return Objects.equals(networkInterfaceArn(), other.networkInterfaceArn())
                && Objects.equals(protocolConfiguration(), other.protocolConfiguration())
                && Objects.equals(protocolAsString(), other.protocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StandardRouterInputConfiguration").add("NetworkInterfaceArn", networkInterfaceArn())
                .add("ProtocolConfiguration", protocolConfiguration()).add("Protocol", protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceArn":
            return Optional.ofNullable(clazz.cast(networkInterfaceArn()));
        case "ProtocolConfiguration":
            return Optional.ofNullable(clazz.cast(protocolConfiguration()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("networkInterfaceArn", NETWORK_INTERFACE_ARN_FIELD);
        map.put("protocolConfiguration", PROTOCOL_CONFIGURATION_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandardRouterInputConfiguration, T> g) {
        return obj -> g.apply((StandardRouterInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StandardRouterInputConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network interface associated with the standard router input.
         * </p>
         * 
         * @param networkInterfaceArn
         *        The Amazon Resource Name (ARN) of the network interface associated with the standard router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceArn(String networkInterfaceArn);

        /**
         * <p>
         * The configuration settings for the protocol used by the standard router input.
         * </p>
         * 
         * @param protocolConfiguration
         *        The configuration settings for the protocol used by the standard router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolConfiguration(RouterInputProtocolConfiguration protocolConfiguration);

        /**
         * <p>
         * The configuration settings for the protocol used by the standard router input.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouterInputProtocolConfiguration.Builder}
         * avoiding the need to create one manually via {@link RouterInputProtocolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouterInputProtocolConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #protocolConfiguration(RouterInputProtocolConfiguration)}.
         * 
         * @param protocolConfiguration
         *        a consumer that will call methods on {@link RouterInputProtocolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protocolConfiguration(RouterInputProtocolConfiguration)
         */
        default Builder protocolConfiguration(Consumer<RouterInputProtocolConfiguration.Builder> protocolConfiguration) {
            return protocolConfiguration(RouterInputProtocolConfiguration.builder().applyMutation(protocolConfiguration).build());
        }

        /**
         * <p>
         * The protocol used by the standard router input.
         * </p>
         * 
         * @param protocol
         *        The protocol used by the standard router input.
         * @see RouterInputProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterInputProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol used by the standard router input.
         * </p>
         * 
         * @param protocol
         *        The protocol used by the standard router input.
         * @see RouterInputProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterInputProtocol
         */
        Builder protocol(RouterInputProtocol protocol);
    }

    static final class BuilderImpl implements Builder {
        private String networkInterfaceArn;

        private RouterInputProtocolConfiguration protocolConfiguration;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardRouterInputConfiguration model) {
            networkInterfaceArn(model.networkInterfaceArn);
            protocolConfiguration(model.protocolConfiguration);
            protocol(model.protocol);
        }

        public final String getNetworkInterfaceArn() {
            return networkInterfaceArn;
        }

        public final void setNetworkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
        }

        @Override
        public final Builder networkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
            return this;
        }

        public final RouterInputProtocolConfiguration.Builder getProtocolConfiguration() {
            return protocolConfiguration != null ? protocolConfiguration.toBuilder() : null;
        }

        public final void setProtocolConfiguration(RouterInputProtocolConfiguration.BuilderImpl protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration != null ? protocolConfiguration.build() : null;
        }

        @Override
        public final Builder protocolConfiguration(RouterInputProtocolConfiguration protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(RouterInputProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        @Override
        public StandardRouterInputConfiguration build() {
            return new StandardRouterInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
