/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a router output using the SRT (Secure Reliable Transport) protocol in caller mode,
 * including the destination address and port, minimum latency, stream ID, and encryption key configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SrtCallerRouterOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SrtCallerRouterOutputConfiguration.Builder, SrtCallerRouterOutputConfiguration> {
    private static final SdkField<String> DESTINATION_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationAddress").getter(getter(SrtCallerRouterOutputConfiguration::destinationAddress))
            .setter(setter(Builder::destinationAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationAddress").build())
            .build();

    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DestinationPort").getter(getter(SrtCallerRouterOutputConfiguration::destinationPort))
            .setter(setter(Builder::destinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPort").build()).build();

    private static final SdkField<Long> MINIMUM_LATENCY_MILLISECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MinimumLatencyMilliseconds")
            .getter(getter(SrtCallerRouterOutputConfiguration::minimumLatencyMilliseconds))
            .setter(setter(Builder::minimumLatencyMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLatencyMilliseconds").build())
            .build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamId").getter(getter(SrtCallerRouterOutputConfiguration::streamId))
            .setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final SdkField<SrtEncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<SrtEncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfiguration")
            .getter(getter(SrtCallerRouterOutputConfiguration::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration)).constructor(SrtEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ADDRESS_FIELD,
            DESTINATION_PORT_FIELD, MINIMUM_LATENCY_MILLISECONDS_FIELD, STREAM_ID_FIELD, ENCRYPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationAddress;

    private final Integer destinationPort;

    private final Long minimumLatencyMilliseconds;

    private final String streamId;

    private final SrtEncryptionConfiguration encryptionConfiguration;

    private SrtCallerRouterOutputConfiguration(BuilderImpl builder) {
        this.destinationAddress = builder.destinationAddress;
        this.destinationPort = builder.destinationPort;
        this.minimumLatencyMilliseconds = builder.minimumLatencyMilliseconds;
        this.streamId = builder.streamId;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    /**
     * <p>
     * The destination IP address for the SRT protocol in caller mode.
     * </p>
     * 
     * @return The destination IP address for the SRT protocol in caller mode.
     */
    public final String destinationAddress() {
        return destinationAddress;
    }

    /**
     * <p>
     * The destination port number for the SRT protocol in caller mode.
     * </p>
     * 
     * @return The destination port number for the SRT protocol in caller mode.
     */
    public final Integer destinationPort() {
        return destinationPort;
    }

    /**
     * <p>
     * The minimum latency in milliseconds for the SRT protocol in caller mode.
     * </p>
     * 
     * @return The minimum latency in milliseconds for the SRT protocol in caller mode.
     */
    public final Long minimumLatencyMilliseconds() {
        return minimumLatencyMilliseconds;
    }

    /**
     * <p>
     * The stream ID for the SRT protocol in caller mode.
     * </p>
     * 
     * @return The stream ID for the SRT protocol in caller mode.
     */
    public final String streamId() {
        return streamId;
    }

    /**
     * <p>
     * Defines the encryption settings for an SRT caller output, including the encryption key configuration and
     * associated parameters.
     * </p>
     * 
     * @return Defines the encryption settings for an SRT caller output, including the encryption key configuration and
     *         associated parameters.
     */
    public final SrtEncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationAddress());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(minimumLatencyMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtCallerRouterOutputConfiguration)) {
            return false;
        }
        SrtCallerRouterOutputConfiguration other = (SrtCallerRouterOutputConfiguration) obj;
        return Objects.equals(destinationAddress(), other.destinationAddress())
                && Objects.equals(destinationPort(), other.destinationPort())
                && Objects.equals(minimumLatencyMilliseconds(), other.minimumLatencyMilliseconds())
                && Objects.equals(streamId(), other.streamId())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SrtCallerRouterOutputConfiguration").add("DestinationAddress", destinationAddress())
                .add("DestinationPort", destinationPort()).add("MinimumLatencyMilliseconds", minimumLatencyMilliseconds())
                .add("StreamId", streamId()).add("EncryptionConfiguration", encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationAddress":
            return Optional.ofNullable(clazz.cast(destinationAddress()));
        case "DestinationPort":
            return Optional.ofNullable(clazz.cast(destinationPort()));
        case "MinimumLatencyMilliseconds":
            return Optional.ofNullable(clazz.cast(minimumLatencyMilliseconds()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationAddress", DESTINATION_ADDRESS_FIELD);
        map.put("destinationPort", DESTINATION_PORT_FIELD);
        map.put("minimumLatencyMilliseconds", MINIMUM_LATENCY_MILLISECONDS_FIELD);
        map.put("streamId", STREAM_ID_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SrtCallerRouterOutputConfiguration, T> g) {
        return obj -> g.apply((SrtCallerRouterOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SrtCallerRouterOutputConfiguration> {
        /**
         * <p>
         * The destination IP address for the SRT protocol in caller mode.
         * </p>
         * 
         * @param destinationAddress
         *        The destination IP address for the SRT protocol in caller mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddress(String destinationAddress);

        /**
         * <p>
         * The destination port number for the SRT protocol in caller mode.
         * </p>
         * 
         * @param destinationPort
         *        The destination port number for the SRT protocol in caller mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPort(Integer destinationPort);

        /**
         * <p>
         * The minimum latency in milliseconds for the SRT protocol in caller mode.
         * </p>
         * 
         * @param minimumLatencyMilliseconds
         *        The minimum latency in milliseconds for the SRT protocol in caller mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLatencyMilliseconds(Long minimumLatencyMilliseconds);

        /**
         * <p>
         * The stream ID for the SRT protocol in caller mode.
         * </p>
         * 
         * @param streamId
         *        The stream ID for the SRT protocol in caller mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * <p>
         * Defines the encryption settings for an SRT caller output, including the encryption key configuration and
         * associated parameters.
         * </p>
         * 
         * @param encryptionConfiguration
         *        Defines the encryption settings for an SRT caller output, including the encryption key configuration
         *        and associated parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(SrtEncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * Defines the encryption settings for an SRT caller output, including the encryption key configuration and
         * associated parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link SrtEncryptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link SrtEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SrtEncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(SrtEncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link SrtEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(SrtEncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<SrtEncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(SrtEncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String destinationAddress;

        private Integer destinationPort;

        private Long minimumLatencyMilliseconds;

        private String streamId;

        private SrtEncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtCallerRouterOutputConfiguration model) {
            destinationAddress(model.destinationAddress);
            destinationPort(model.destinationPort);
            minimumLatencyMilliseconds(model.minimumLatencyMilliseconds);
            streamId(model.streamId);
            encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getDestinationAddress() {
            return destinationAddress;
        }

        public final void setDestinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
        }

        @Override
        public final Builder destinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public final Integer getDestinationPort() {
            return destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final Long getMinimumLatencyMilliseconds() {
            return minimumLatencyMilliseconds;
        }

        public final void setMinimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
        }

        @Override
        public final Builder minimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
            return this;
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final SrtEncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(SrtEncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(SrtEncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public SrtCallerRouterOutputConfiguration build() {
            return new SrtCallerRouterOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
