/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in caller mode,
 * including the source address and port, minimum latency, stream ID, and decryption key configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SrtCallerRouterInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SrtCallerRouterInputConfiguration.Builder, SrtCallerRouterInputConfiguration> {
    private static final SdkField<String> SOURCE_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceAddress").getter(getter(SrtCallerRouterInputConfiguration::sourceAddress))
            .setter(setter(Builder::sourceAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAddress").build()).build();

    private static final SdkField<Integer> SOURCE_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SourcePort").getter(getter(SrtCallerRouterInputConfiguration::sourcePort))
            .setter(setter(Builder::sourcePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePort").build()).build();

    private static final SdkField<Long> MINIMUM_LATENCY_MILLISECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MinimumLatencyMilliseconds")
            .getter(getter(SrtCallerRouterInputConfiguration::minimumLatencyMilliseconds))
            .setter(setter(Builder::minimumLatencyMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLatencyMilliseconds").build())
            .build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamId").getter(getter(SrtCallerRouterInputConfiguration::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final SdkField<SrtDecryptionConfiguration> DECRYPTION_CONFIGURATION_FIELD = SdkField
            .<SrtDecryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("DecryptionConfiguration")
            .getter(getter(SrtCallerRouterInputConfiguration::decryptionConfiguration))
            .setter(setter(Builder::decryptionConfiguration)).constructor(SrtDecryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ADDRESS_FIELD,
            SOURCE_PORT_FIELD, MINIMUM_LATENCY_MILLISECONDS_FIELD, STREAM_ID_FIELD, DECRYPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceAddress;

    private final Integer sourcePort;

    private final Long minimumLatencyMilliseconds;

    private final String streamId;

    private final SrtDecryptionConfiguration decryptionConfiguration;

    private SrtCallerRouterInputConfiguration(BuilderImpl builder) {
        this.sourceAddress = builder.sourceAddress;
        this.sourcePort = builder.sourcePort;
        this.minimumLatencyMilliseconds = builder.minimumLatencyMilliseconds;
        this.streamId = builder.streamId;
        this.decryptionConfiguration = builder.decryptionConfiguration;
    }

    /**
     * <p>
     * The source IP address for the SRT protocol in caller mode.
     * </p>
     * 
     * @return The source IP address for the SRT protocol in caller mode.
     */
    public final String sourceAddress() {
        return sourceAddress;
    }

    /**
     * <p>
     * The source port number for the SRT protocol in caller mode.
     * </p>
     * 
     * @return The source port number for the SRT protocol in caller mode.
     */
    public final Integer sourcePort() {
        return sourcePort;
    }

    /**
     * <p>
     * The minimum latency in milliseconds for the SRT protocol in caller mode.
     * </p>
     * 
     * @return The minimum latency in milliseconds for the SRT protocol in caller mode.
     */
    public final Long minimumLatencyMilliseconds() {
        return minimumLatencyMilliseconds;
    }

    /**
     * <p>
     * The stream ID for the SRT protocol in caller mode.
     * </p>
     * 
     * @return The stream ID for the SRT protocol in caller mode.
     */
    public final String streamId() {
        return streamId;
    }

    /**
     * <p>
     * Specifies the decryption settings for an SRT caller input, including the encryption key configuration and
     * associated parameters.
     * </p>
     * 
     * @return Specifies the decryption settings for an SRT caller input, including the encryption key configuration and
     *         associated parameters.
     */
    public final SrtDecryptionConfiguration decryptionConfiguration() {
        return decryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAddress());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePort());
        hashCode = 31 * hashCode + Objects.hashCode(minimumLatencyMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(decryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtCallerRouterInputConfiguration)) {
            return false;
        }
        SrtCallerRouterInputConfiguration other = (SrtCallerRouterInputConfiguration) obj;
        return Objects.equals(sourceAddress(), other.sourceAddress()) && Objects.equals(sourcePort(), other.sourcePort())
                && Objects.equals(minimumLatencyMilliseconds(), other.minimumLatencyMilliseconds())
                && Objects.equals(streamId(), other.streamId())
                && Objects.equals(decryptionConfiguration(), other.decryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SrtCallerRouterInputConfiguration").add("SourceAddress", sourceAddress())
                .add("SourcePort", sourcePort()).add("MinimumLatencyMilliseconds", minimumLatencyMilliseconds())
                .add("StreamId", streamId()).add("DecryptionConfiguration", decryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceAddress":
            return Optional.ofNullable(clazz.cast(sourceAddress()));
        case "SourcePort":
            return Optional.ofNullable(clazz.cast(sourcePort()));
        case "MinimumLatencyMilliseconds":
            return Optional.ofNullable(clazz.cast(minimumLatencyMilliseconds()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "DecryptionConfiguration":
            return Optional.ofNullable(clazz.cast(decryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceAddress", SOURCE_ADDRESS_FIELD);
        map.put("sourcePort", SOURCE_PORT_FIELD);
        map.put("minimumLatencyMilliseconds", MINIMUM_LATENCY_MILLISECONDS_FIELD);
        map.put("streamId", STREAM_ID_FIELD);
        map.put("decryptionConfiguration", DECRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SrtCallerRouterInputConfiguration, T> g) {
        return obj -> g.apply((SrtCallerRouterInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SrtCallerRouterInputConfiguration> {
        /**
         * <p>
         * The source IP address for the SRT protocol in caller mode.
         * </p>
         * 
         * @param sourceAddress
         *        The source IP address for the SRT protocol in caller mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAddress(String sourceAddress);

        /**
         * <p>
         * The source port number for the SRT protocol in caller mode.
         * </p>
         * 
         * @param sourcePort
         *        The source port number for the SRT protocol in caller mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePort(Integer sourcePort);

        /**
         * <p>
         * The minimum latency in milliseconds for the SRT protocol in caller mode.
         * </p>
         * 
         * @param minimumLatencyMilliseconds
         *        The minimum latency in milliseconds for the SRT protocol in caller mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLatencyMilliseconds(Long minimumLatencyMilliseconds);

        /**
         * <p>
         * The stream ID for the SRT protocol in caller mode.
         * </p>
         * 
         * @param streamId
         *        The stream ID for the SRT protocol in caller mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * <p>
         * Specifies the decryption settings for an SRT caller input, including the encryption key configuration and
         * associated parameters.
         * </p>
         * 
         * @param decryptionConfiguration
         *        Specifies the decryption settings for an SRT caller input, including the encryption key configuration
         *        and associated parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decryptionConfiguration(SrtDecryptionConfiguration decryptionConfiguration);

        /**
         * <p>
         * Specifies the decryption settings for an SRT caller input, including the encryption key configuration and
         * associated parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link SrtDecryptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link SrtDecryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SrtDecryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #decryptionConfiguration(SrtDecryptionConfiguration)}.
         * 
         * @param decryptionConfiguration
         *        a consumer that will call methods on {@link SrtDecryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decryptionConfiguration(SrtDecryptionConfiguration)
         */
        default Builder decryptionConfiguration(Consumer<SrtDecryptionConfiguration.Builder> decryptionConfiguration) {
            return decryptionConfiguration(SrtDecryptionConfiguration.builder().applyMutation(decryptionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sourceAddress;

        private Integer sourcePort;

        private Long minimumLatencyMilliseconds;

        private String streamId;

        private SrtDecryptionConfiguration decryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtCallerRouterInputConfiguration model) {
            sourceAddress(model.sourceAddress);
            sourcePort(model.sourcePort);
            minimumLatencyMilliseconds(model.minimumLatencyMilliseconds);
            streamId(model.streamId);
            decryptionConfiguration(model.decryptionConfiguration);
        }

        public final String getSourceAddress() {
            return sourceAddress;
        }

        public final void setSourceAddress(String sourceAddress) {
            this.sourceAddress = sourceAddress;
        }

        @Override
        public final Builder sourceAddress(String sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        public final Integer getSourcePort() {
            return sourcePort;
        }

        public final void setSourcePort(Integer sourcePort) {
            this.sourcePort = sourcePort;
        }

        @Override
        public final Builder sourcePort(Integer sourcePort) {
            this.sourcePort = sourcePort;
            return this;
        }

        public final Long getMinimumLatencyMilliseconds() {
            return minimumLatencyMilliseconds;
        }

        public final void setMinimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
        }

        @Override
        public final Builder minimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
            return this;
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final SrtDecryptionConfiguration.Builder getDecryptionConfiguration() {
            return decryptionConfiguration != null ? decryptionConfiguration.toBuilder() : null;
        }

        public final void setDecryptionConfiguration(SrtDecryptionConfiguration.BuilderImpl decryptionConfiguration) {
            this.decryptionConfiguration = decryptionConfiguration != null ? decryptionConfiguration.build() : null;
        }

        @Override
        public final Builder decryptionConfiguration(SrtDecryptionConfiguration decryptionConfiguration) {
            this.decryptionConfiguration = decryptionConfiguration;
            return this;
        }

        @Override
        public SrtCallerRouterInputConfiguration build() {
            return new SrtCallerRouterInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
