/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures settings for the <code>SilentAudio</code> metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SilentAudio implements SdkPojo, Serializable, ToCopyableBuilder<SilentAudio.Builder, SilentAudio> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(SilentAudio::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Integer> THRESHOLD_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThresholdSeconds").getter(getter(SilentAudio::thresholdSeconds))
            .setter(setter(Builder::thresholdSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            THRESHOLD_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String state;

    private final Integer thresholdSeconds;

    private SilentAudio(BuilderImpl builder) {
        this.state = builder.state;
        this.thresholdSeconds = builder.thresholdSeconds;
    }

    /**
     * <p>
     * Indicates whether the <code>SilentAudio</code> metric is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates whether the <code>SilentAudio</code> metric is enabled or disabled.
     * @see State
     */
    public final State state() {
        return State.fromValue(state);
    }

    /**
     * <p>
     * Indicates whether the <code>SilentAudio</code> metric is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates whether the <code>SilentAudio</code> metric is enabled or disabled.
     * @see State
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Specifies the number of consecutive seconds of silence that triggers an event or alert.
     * </p>
     * 
     * @return Specifies the number of consecutive seconds of silence that triggers an event or alert.
     */
    public final Integer thresholdSeconds() {
        return thresholdSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SilentAudio)) {
            return false;
        }
        SilentAudio other = (SilentAudio) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(thresholdSeconds(), other.thresholdSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SilentAudio").add("State", stateAsString()).add("ThresholdSeconds", thresholdSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ThresholdSeconds":
            return Optional.ofNullable(clazz.cast(thresholdSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("state", STATE_FIELD);
        map.put("thresholdSeconds", THRESHOLD_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SilentAudio, T> g) {
        return obj -> g.apply((SilentAudio) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SilentAudio> {
        /**
         * <p>
         * Indicates whether the <code>SilentAudio</code> metric is enabled or disabled.
         * </p>
         * 
         * @param state
         *        Indicates whether the <code>SilentAudio</code> metric is enabled or disabled.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * Indicates whether the <code>SilentAudio</code> metric is enabled or disabled.
         * </p>
         * 
         * @param state
         *        Indicates whether the <code>SilentAudio</code> metric is enabled or disabled.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);

        /**
         * <p>
         * Specifies the number of consecutive seconds of silence that triggers an event or alert.
         * </p>
         * 
         * @param thresholdSeconds
         *        Specifies the number of consecutive seconds of silence that triggers an event or alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdSeconds(Integer thresholdSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private Integer thresholdSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(SilentAudio model) {
            state(model.state);
            thresholdSeconds(model.thresholdSeconds);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getThresholdSeconds() {
            return thresholdSeconds;
        }

        public final void setThresholdSeconds(Integer thresholdSeconds) {
            this.thresholdSeconds = thresholdSeconds;
        }

        @Override
        public final Builder thresholdSeconds(Integer thresholdSeconds) {
            this.thresholdSeconds = thresholdSeconds;
            return this;
        }

        @Override
        public SilentAudio build() {
            return new SilentAudio(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
