/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a Router Input using the RTP (Real-Time Transport Protocol) protocol, including the
 * port and forward error correction state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RtpRouterInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RtpRouterInputConfiguration.Builder, RtpRouterInputConfiguration> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(RtpRouterInputConfiguration::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> FORWARD_ERROR_CORRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForwardErrorCorrection").getter(getter(RtpRouterInputConfiguration::forwardErrorCorrectionAsString))
            .setter(setter(Builder::forwardErrorCorrection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forwardErrorCorrection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD,
            FORWARD_ERROR_CORRECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer port;

    private final String forwardErrorCorrection;

    private RtpRouterInputConfiguration(BuilderImpl builder) {
        this.port = builder.port;
        this.forwardErrorCorrection = builder.forwardErrorCorrection;
    }

    /**
     * <p>
     * The port number used for the RTP protocol in the router input configuration.
     * </p>
     * 
     * @return The port number used for the RTP protocol in the router input configuration.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The state of forward error correction for the RTP protocol in the router input configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #forwardErrorCorrection} will return {@link ForwardErrorCorrectionState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #forwardErrorCorrectionAsString}.
     * </p>
     * 
     * @return The state of forward error correction for the RTP protocol in the router input configuration.
     * @see ForwardErrorCorrectionState
     */
    public final ForwardErrorCorrectionState forwardErrorCorrection() {
        return ForwardErrorCorrectionState.fromValue(forwardErrorCorrection);
    }

    /**
     * <p>
     * The state of forward error correction for the RTP protocol in the router input configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #forwardErrorCorrection} will return {@link ForwardErrorCorrectionState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #forwardErrorCorrectionAsString}.
     * </p>
     * 
     * @return The state of forward error correction for the RTP protocol in the router input configuration.
     * @see ForwardErrorCorrectionState
     */
    public final String forwardErrorCorrectionAsString() {
        return forwardErrorCorrection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(forwardErrorCorrectionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RtpRouterInputConfiguration)) {
            return false;
        }
        RtpRouterInputConfiguration other = (RtpRouterInputConfiguration) obj;
        return Objects.equals(port(), other.port())
                && Objects.equals(forwardErrorCorrectionAsString(), other.forwardErrorCorrectionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RtpRouterInputConfiguration").add("Port", port())
                .add("ForwardErrorCorrection", forwardErrorCorrectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "ForwardErrorCorrection":
            return Optional.ofNullable(clazz.cast(forwardErrorCorrectionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("port", PORT_FIELD);
        map.put("forwardErrorCorrection", FORWARD_ERROR_CORRECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RtpRouterInputConfiguration, T> g) {
        return obj -> g.apply((RtpRouterInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RtpRouterInputConfiguration> {
        /**
         * <p>
         * The port number used for the RTP protocol in the router input configuration.
         * </p>
         * 
         * @param port
         *        The port number used for the RTP protocol in the router input configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The state of forward error correction for the RTP protocol in the router input configuration.
         * </p>
         * 
         * @param forwardErrorCorrection
         *        The state of forward error correction for the RTP protocol in the router input configuration.
         * @see ForwardErrorCorrectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForwardErrorCorrectionState
         */
        Builder forwardErrorCorrection(String forwardErrorCorrection);

        /**
         * <p>
         * The state of forward error correction for the RTP protocol in the router input configuration.
         * </p>
         * 
         * @param forwardErrorCorrection
         *        The state of forward error correction for the RTP protocol in the router input configuration.
         * @see ForwardErrorCorrectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForwardErrorCorrectionState
         */
        Builder forwardErrorCorrection(ForwardErrorCorrectionState forwardErrorCorrection);
    }

    static final class BuilderImpl implements Builder {
        private Integer port;

        private String forwardErrorCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(RtpRouterInputConfiguration model) {
            port(model.port);
            forwardErrorCorrection(model.forwardErrorCorrection);
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getForwardErrorCorrection() {
            return forwardErrorCorrection;
        }

        public final void setForwardErrorCorrection(String forwardErrorCorrection) {
            this.forwardErrorCorrection = forwardErrorCorrection;
        }

        @Override
        public final Builder forwardErrorCorrection(String forwardErrorCorrection) {
            this.forwardErrorCorrection = forwardErrorCorrection;
            return this;
        }

        @Override
        public final Builder forwardErrorCorrection(ForwardErrorCorrectionState forwardErrorCorrection) {
            this.forwardErrorCorrection(forwardErrorCorrection == null ? null : forwardErrorCorrection.toString());
            return this;
        }

        @Override
        public RtpRouterInputConfiguration build() {
            return new RtpRouterInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
