/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The protocol configuration settings for a router output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouterOutputProtocolConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RouterOutputProtocolConfiguration.Builder, RouterOutputProtocolConfiguration> {
    private static final SdkField<RtpRouterOutputConfiguration> RTP_FIELD = SdkField
            .<RtpRouterOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("Rtp")
            .getter(getter(RouterOutputProtocolConfiguration::rtp)).setter(setter(Builder::rtp))
            .constructor(RtpRouterOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtp").build()).build();

    private static final SdkField<RistRouterOutputConfiguration> RIST_FIELD = SdkField
            .<RistRouterOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("Rist")
            .getter(getter(RouterOutputProtocolConfiguration::rist)).setter(setter(Builder::rist))
            .constructor(RistRouterOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rist").build()).build();

    private static final SdkField<SrtListenerRouterOutputConfiguration> SRT_LISTENER_FIELD = SdkField
            .<SrtListenerRouterOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("SrtListener")
            .getter(getter(RouterOutputProtocolConfiguration::srtListener)).setter(setter(Builder::srtListener))
            .constructor(SrtListenerRouterOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtListener").build()).build();

    private static final SdkField<SrtCallerRouterOutputConfiguration> SRT_CALLER_FIELD = SdkField
            .<SrtCallerRouterOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("SrtCaller")
            .getter(getter(RouterOutputProtocolConfiguration::srtCaller)).setter(setter(Builder::srtCaller))
            .constructor(SrtCallerRouterOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtCaller").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RTP_FIELD, RIST_FIELD,
            SRT_LISTENER_FIELD, SRT_CALLER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RtpRouterOutputConfiguration rtp;

    private final RistRouterOutputConfiguration rist;

    private final SrtListenerRouterOutputConfiguration srtListener;

    private final SrtCallerRouterOutputConfiguration srtCaller;

    private final Type type;

    private RouterOutputProtocolConfiguration(BuilderImpl builder) {
        this.rtp = builder.rtp;
        this.rist = builder.rist;
        this.srtListener = builder.srtListener;
        this.srtCaller = builder.srtCaller;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Rtp property for this object.
     * 
     * @return The value of the Rtp property for this object.
     */
    public final RtpRouterOutputConfiguration rtp() {
        return rtp;
    }

    /**
     * Returns the value of the Rist property for this object.
     * 
     * @return The value of the Rist property for this object.
     */
    public final RistRouterOutputConfiguration rist() {
        return rist;
    }

    /**
     * Returns the value of the SrtListener property for this object.
     * 
     * @return The value of the SrtListener property for this object.
     */
    public final SrtListenerRouterOutputConfiguration srtListener() {
        return srtListener;
    }

    /**
     * Returns the value of the SrtCaller property for this object.
     * 
     * @return The value of the SrtCaller property for this object.
     */
    public final SrtCallerRouterOutputConfiguration srtCaller() {
        return srtCaller;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rtp());
        hashCode = 31 * hashCode + Objects.hashCode(rist());
        hashCode = 31 * hashCode + Objects.hashCode(srtListener());
        hashCode = 31 * hashCode + Objects.hashCode(srtCaller());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterOutputProtocolConfiguration)) {
            return false;
        }
        RouterOutputProtocolConfiguration other = (RouterOutputProtocolConfiguration) obj;
        return Objects.equals(rtp(), other.rtp()) && Objects.equals(rist(), other.rist())
                && Objects.equals(srtListener(), other.srtListener()) && Objects.equals(srtCaller(), other.srtCaller());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouterOutputProtocolConfiguration").add("Rtp", rtp()).add("Rist", rist())
                .add("SrtListener", srtListener()).add("SrtCaller", srtCaller()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rtp":
            return Optional.ofNullable(clazz.cast(rtp()));
        case "Rist":
            return Optional.ofNullable(clazz.cast(rist()));
        case "SrtListener":
            return Optional.ofNullable(clazz.cast(srtListener()));
        case "SrtCaller":
            return Optional.ofNullable(clazz.cast(srtCaller()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #rtp()} initialized to the given value.
     *
     * Sets the value of the Rtp property for this object.
     *
     * @param rtp
     *        The new value for the Rtp property for this object.
     */
    public static RouterOutputProtocolConfiguration fromRtp(RtpRouterOutputConfiguration rtp) {
        return builder().rtp(rtp).build();
    }

    /**
     * Create an instance of this class with {@link #rtp()} initialized to the given value.
     *
     * Sets the value of the Rtp property for this object.
     *
     * @param rtp
     *        The new value for the Rtp property for this object.
     */
    public static RouterOutputProtocolConfiguration fromRtp(Consumer<RtpRouterOutputConfiguration.Builder> rtp) {
        RtpRouterOutputConfiguration.Builder builder = RtpRouterOutputConfiguration.builder();
        rtp.accept(builder);
        return fromRtp(builder.build());
    }

    /**
     * Create an instance of this class with {@link #rist()} initialized to the given value.
     *
     * Sets the value of the Rist property for this object.
     *
     * @param rist
     *        The new value for the Rist property for this object.
     */
    public static RouterOutputProtocolConfiguration fromRist(RistRouterOutputConfiguration rist) {
        return builder().rist(rist).build();
    }

    /**
     * Create an instance of this class with {@link #rist()} initialized to the given value.
     *
     * Sets the value of the Rist property for this object.
     *
     * @param rist
     *        The new value for the Rist property for this object.
     */
    public static RouterOutputProtocolConfiguration fromRist(Consumer<RistRouterOutputConfiguration.Builder> rist) {
        RistRouterOutputConfiguration.Builder builder = RistRouterOutputConfiguration.builder();
        rist.accept(builder);
        return fromRist(builder.build());
    }

    /**
     * Create an instance of this class with {@link #srtListener()} initialized to the given value.
     *
     * Sets the value of the SrtListener property for this object.
     *
     * @param srtListener
     *        The new value for the SrtListener property for this object.
     */
    public static RouterOutputProtocolConfiguration fromSrtListener(SrtListenerRouterOutputConfiguration srtListener) {
        return builder().srtListener(srtListener).build();
    }

    /**
     * Create an instance of this class with {@link #srtListener()} initialized to the given value.
     *
     * Sets the value of the SrtListener property for this object.
     *
     * @param srtListener
     *        The new value for the SrtListener property for this object.
     */
    public static RouterOutputProtocolConfiguration fromSrtListener(
            Consumer<SrtListenerRouterOutputConfiguration.Builder> srtListener) {
        SrtListenerRouterOutputConfiguration.Builder builder = SrtListenerRouterOutputConfiguration.builder();
        srtListener.accept(builder);
        return fromSrtListener(builder.build());
    }

    /**
     * Create an instance of this class with {@link #srtCaller()} initialized to the given value.
     *
     * Sets the value of the SrtCaller property for this object.
     *
     * @param srtCaller
     *        The new value for the SrtCaller property for this object.
     */
    public static RouterOutputProtocolConfiguration fromSrtCaller(SrtCallerRouterOutputConfiguration srtCaller) {
        return builder().srtCaller(srtCaller).build();
    }

    /**
     * Create an instance of this class with {@link #srtCaller()} initialized to the given value.
     *
     * Sets the value of the SrtCaller property for this object.
     *
     * @param srtCaller
     *        The new value for the SrtCaller property for this object.
     */
    public static RouterOutputProtocolConfiguration fromSrtCaller(Consumer<SrtCallerRouterOutputConfiguration.Builder> srtCaller) {
        SrtCallerRouterOutputConfiguration.Builder builder = SrtCallerRouterOutputConfiguration.builder();
        srtCaller.accept(builder);
        return fromSrtCaller(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rtp", RTP_FIELD);
        map.put("rist", RIST_FIELD);
        map.put("srtListener", SRT_LISTENER_FIELD);
        map.put("srtCaller", SRT_CALLER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterOutputProtocolConfiguration, T> g) {
        return obj -> g.apply((RouterOutputProtocolConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouterOutputProtocolConfiguration> {
        /**
         * Sets the value of the Rtp property for this object.
         *
         * @param rtp
         *        The new value for the Rtp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rtp(RtpRouterOutputConfiguration rtp);

        /**
         * Sets the value of the Rtp property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RtpRouterOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link RtpRouterOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RtpRouterOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #rtp(RtpRouterOutputConfiguration)}.
         * 
         * @param rtp
         *        a consumer that will call methods on {@link RtpRouterOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rtp(RtpRouterOutputConfiguration)
         */
        default Builder rtp(Consumer<RtpRouterOutputConfiguration.Builder> rtp) {
            return rtp(RtpRouterOutputConfiguration.builder().applyMutation(rtp).build());
        }

        /**
         * Sets the value of the Rist property for this object.
         *
         * @param rist
         *        The new value for the Rist property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rist(RistRouterOutputConfiguration rist);

        /**
         * Sets the value of the Rist property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RistRouterOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link RistRouterOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RistRouterOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #rist(RistRouterOutputConfiguration)}.
         * 
         * @param rist
         *        a consumer that will call methods on {@link RistRouterOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rist(RistRouterOutputConfiguration)
         */
        default Builder rist(Consumer<RistRouterOutputConfiguration.Builder> rist) {
            return rist(RistRouterOutputConfiguration.builder().applyMutation(rist).build());
        }

        /**
         * Sets the value of the SrtListener property for this object.
         *
         * @param srtListener
         *        The new value for the SrtListener property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder srtListener(SrtListenerRouterOutputConfiguration srtListener);

        /**
         * Sets the value of the SrtListener property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link SrtListenerRouterOutputConfiguration.Builder} avoiding the need to create one manually via
         * {@link SrtListenerRouterOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SrtListenerRouterOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #srtListener(SrtListenerRouterOutputConfiguration)}.
         * 
         * @param srtListener
         *        a consumer that will call methods on {@link SrtListenerRouterOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #srtListener(SrtListenerRouterOutputConfiguration)
         */
        default Builder srtListener(Consumer<SrtListenerRouterOutputConfiguration.Builder> srtListener) {
            return srtListener(SrtListenerRouterOutputConfiguration.builder().applyMutation(srtListener).build());
        }

        /**
         * Sets the value of the SrtCaller property for this object.
         *
         * @param srtCaller
         *        The new value for the SrtCaller property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder srtCaller(SrtCallerRouterOutputConfiguration srtCaller);

        /**
         * Sets the value of the SrtCaller property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link SrtCallerRouterOutputConfiguration.Builder} avoiding the need to create one manually via
         * {@link SrtCallerRouterOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SrtCallerRouterOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #srtCaller(SrtCallerRouterOutputConfiguration)}.
         * 
         * @param srtCaller
         *        a consumer that will call methods on {@link SrtCallerRouterOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #srtCaller(SrtCallerRouterOutputConfiguration)
         */
        default Builder srtCaller(Consumer<SrtCallerRouterOutputConfiguration.Builder> srtCaller) {
            return srtCaller(SrtCallerRouterOutputConfiguration.builder().applyMutation(srtCaller).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RtpRouterOutputConfiguration rtp;

        private RistRouterOutputConfiguration rist;

        private SrtListenerRouterOutputConfiguration srtListener;

        private SrtCallerRouterOutputConfiguration srtCaller;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterOutputProtocolConfiguration model) {
            rtp(model.rtp);
            rist(model.rist);
            srtListener(model.srtListener);
            srtCaller(model.srtCaller);
        }

        public final RtpRouterOutputConfiguration.Builder getRtp() {
            return rtp != null ? rtp.toBuilder() : null;
        }

        public final void setRtp(RtpRouterOutputConfiguration.BuilderImpl rtp) {
            Object oldValue = this.rtp;
            this.rtp = rtp != null ? rtp.build() : null;
            handleUnionValueChange(Type.RTP, oldValue, this.rtp);
        }

        @Override
        public final Builder rtp(RtpRouterOutputConfiguration rtp) {
            Object oldValue = this.rtp;
            this.rtp = rtp;
            handleUnionValueChange(Type.RTP, oldValue, this.rtp);
            return this;
        }

        public final RistRouterOutputConfiguration.Builder getRist() {
            return rist != null ? rist.toBuilder() : null;
        }

        public final void setRist(RistRouterOutputConfiguration.BuilderImpl rist) {
            Object oldValue = this.rist;
            this.rist = rist != null ? rist.build() : null;
            handleUnionValueChange(Type.RIST, oldValue, this.rist);
        }

        @Override
        public final Builder rist(RistRouterOutputConfiguration rist) {
            Object oldValue = this.rist;
            this.rist = rist;
            handleUnionValueChange(Type.RIST, oldValue, this.rist);
            return this;
        }

        public final SrtListenerRouterOutputConfiguration.Builder getSrtListener() {
            return srtListener != null ? srtListener.toBuilder() : null;
        }

        public final void setSrtListener(SrtListenerRouterOutputConfiguration.BuilderImpl srtListener) {
            Object oldValue = this.srtListener;
            this.srtListener = srtListener != null ? srtListener.build() : null;
            handleUnionValueChange(Type.SRT_LISTENER, oldValue, this.srtListener);
        }

        @Override
        public final Builder srtListener(SrtListenerRouterOutputConfiguration srtListener) {
            Object oldValue = this.srtListener;
            this.srtListener = srtListener;
            handleUnionValueChange(Type.SRT_LISTENER, oldValue, this.srtListener);
            return this;
        }

        public final SrtCallerRouterOutputConfiguration.Builder getSrtCaller() {
            return srtCaller != null ? srtCaller.toBuilder() : null;
        }

        public final void setSrtCaller(SrtCallerRouterOutputConfiguration.BuilderImpl srtCaller) {
            Object oldValue = this.srtCaller;
            this.srtCaller = srtCaller != null ? srtCaller.build() : null;
            handleUnionValueChange(Type.SRT_CALLER, oldValue, this.srtCaller);
        }

        @Override
        public final Builder srtCaller(SrtCallerRouterOutputConfiguration srtCaller) {
            Object oldValue = this.srtCaller;
            this.srtCaller = srtCaller;
            handleUnionValueChange(Type.SRT_CALLER, oldValue, this.srtCaller);
            return this;
        }

        @Override
        public RouterOutputProtocolConfiguration build() {
            return new RouterOutputProtocolConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RouterOutputProtocolConfiguration#type()
     */
    public enum Type {
        RTP,

        RIST,

        SRT_LISTENER,

        SRT_CALLER,

        UNKNOWN_TO_SDK_VERSION
    }
}
