/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter that can be used to retrieve a list of router network interfaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouterNetworkInterfaceFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<RouterNetworkInterfaceFilter.Builder, RouterNetworkInterfaceFilter> {
    private static final SdkField<List<String>> REGION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RegionNames")
            .getter(getter(RouterNetworkInterfaceFilter::regionNames))
            .setter(setter(Builder::regionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NETWORK_INTERFACE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaceTypes")
            .getter(getter(RouterNetworkInterfaceFilter::networkInterfaceTypesAsStrings))
            .setter(setter(Builder::networkInterfaceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NAME_CONTAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NameContains")
            .getter(getter(RouterNetworkInterfaceFilter::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameContains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAMES_FIELD,
            NETWORK_INTERFACE_TYPES_FIELD, NAME_CONTAINS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> regionNames;

    private final List<String> networkInterfaceTypes;

    private final List<String> nameContains;

    private final Type type;

    private RouterNetworkInterfaceFilter(BuilderImpl builder) {
        this.regionNames = builder.regionNames;
        this.networkInterfaceTypes = builder.networkInterfaceTypes;
        this.nameContains = builder.nameContains;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegionNames() {
        return regionNames != null && !(regionNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS Regions of the router network interfaces to include in the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionNames} method.
     * </p>
     * 
     * @return The AWS Regions of the router network interfaces to include in the filter.
     */
    public final List<String> regionNames() {
        return regionNames;
    }

    /**
     * <p>
     * The types of router network interfaces to include in the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaceTypes} method.
     * </p>
     * 
     * @return The types of router network interfaces to include in the filter.
     */
    public final List<RouterNetworkInterfaceType> networkInterfaceTypes() {
        return RouterNetworkInterfaceTypeListCopier.copyStringToEnum(networkInterfaceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfaceTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNetworkInterfaceTypes() {
        return networkInterfaceTypes != null && !(networkInterfaceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of router network interfaces to include in the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaceTypes} method.
     * </p>
     * 
     * @return The types of router network interfaces to include in the filter.
     */
    public final List<String> networkInterfaceTypesAsStrings() {
        return networkInterfaceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the NameContains property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNameContains() {
        return nameContains != null && !(nameContains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the router network interfaces to include in the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNameContains} method.
     * </p>
     * 
     * @return The names of the router network interfaces to include in the filter.
     */
    public final List<String> nameContains() {
        return nameContains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionNames() ? regionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaceTypes() ? networkInterfaceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNameContains() ? nameContains() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterNetworkInterfaceFilter)) {
            return false;
        }
        RouterNetworkInterfaceFilter other = (RouterNetworkInterfaceFilter) obj;
        return hasRegionNames() == other.hasRegionNames() && Objects.equals(regionNames(), other.regionNames())
                && hasNetworkInterfaceTypes() == other.hasNetworkInterfaceTypes()
                && Objects.equals(networkInterfaceTypesAsStrings(), other.networkInterfaceTypesAsStrings())
                && hasNameContains() == other.hasNameContains() && Objects.equals(nameContains(), other.nameContains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouterNetworkInterfaceFilter").add("RegionNames", hasRegionNames() ? regionNames() : null)
                .add("NetworkInterfaceTypes", hasNetworkInterfaceTypes() ? networkInterfaceTypesAsStrings() : null)
                .add("NameContains", hasNameContains() ? nameContains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionNames":
            return Optional.ofNullable(clazz.cast(regionNames()));
        case "NetworkInterfaceTypes":
            return Optional.ofNullable(clazz.cast(networkInterfaceTypesAsStrings()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #regionNames()} initialized to the given value.
     *
     * <p>
     * The AWS Regions of the router network interfaces to include in the filter.
     * </p>
     * 
     * @param regionNames
     *        The AWS Regions of the router network interfaces to include in the filter.
     */
    public static RouterNetworkInterfaceFilter fromRegionNames(List<String> regionNames) {
        return builder().regionNames(regionNames).build();
    }

    /**
     * Create an instance of this class with {@link #networkInterfaceTypesAsStrings()} initialized to the given value.
     *
     * <p>
     * The types of router network interfaces to include in the filter.
     * </p>
     * 
     * @param networkInterfaceTypes
     *        The types of router network interfaces to include in the filter.
     */
    public static RouterNetworkInterfaceFilter fromNetworkInterfaceTypesWithStrings(List<String> networkInterfaceTypesWithStrings) {
        return builder().networkInterfaceTypesWithStrings(networkInterfaceTypesWithStrings).build();
    }

    /**
     * Create an instance of this class with {@link #networkInterfaceTypesAsStrings()} initialized to the given value.
     *
     * <p>
     * The types of router network interfaces to include in the filter.
     * </p>
     * 
     * @param networkInterfaceTypes
     *        The types of router network interfaces to include in the filter.
     */
    public static RouterNetworkInterfaceFilter fromNetworkInterfaceTypes(
            List<RouterNetworkInterfaceType> networkInterfaceTypesWithStrings) {
        return builder().networkInterfaceTypes(networkInterfaceTypesWithStrings).build();
    }

    /**
     * Create an instance of this class with {@link #nameContains()} initialized to the given value.
     *
     * <p>
     * The names of the router network interfaces to include in the filter.
     * </p>
     * 
     * @param nameContains
     *        The names of the router network interfaces to include in the filter.
     */
    public static RouterNetworkInterfaceFilter fromNameContains(List<String> nameContains) {
        return builder().nameContains(nameContains).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("regionNames", REGION_NAMES_FIELD);
        map.put("networkInterfaceTypes", NETWORK_INTERFACE_TYPES_FIELD);
        map.put("nameContains", NAME_CONTAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterNetworkInterfaceFilter, T> g) {
        return obj -> g.apply((RouterNetworkInterfaceFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouterNetworkInterfaceFilter> {
        /**
         * <p>
         * The AWS Regions of the router network interfaces to include in the filter.
         * </p>
         * 
         * @param regionNames
         *        The AWS Regions of the router network interfaces to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionNames(Collection<String> regionNames);

        /**
         * <p>
         * The AWS Regions of the router network interfaces to include in the filter.
         * </p>
         * 
         * @param regionNames
         *        The AWS Regions of the router network interfaces to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionNames(String... regionNames);

        /**
         * <p>
         * The types of router network interfaces to include in the filter.
         * </p>
         * 
         * @param networkInterfaceTypes
         *        The types of router network interfaces to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceTypesWithStrings(Collection<String> networkInterfaceTypes);

        /**
         * <p>
         * The types of router network interfaces to include in the filter.
         * </p>
         * 
         * @param networkInterfaceTypes
         *        The types of router network interfaces to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceTypesWithStrings(String... networkInterfaceTypes);

        /**
         * <p>
         * The types of router network interfaces to include in the filter.
         * </p>
         * 
         * @param networkInterfaceTypes
         *        The types of router network interfaces to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceTypes(Collection<RouterNetworkInterfaceType> networkInterfaceTypes);

        /**
         * <p>
         * The types of router network interfaces to include in the filter.
         * </p>
         * 
         * @param networkInterfaceTypes
         *        The types of router network interfaces to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceTypes(RouterNetworkInterfaceType... networkInterfaceTypes);

        /**
         * <p>
         * The names of the router network interfaces to include in the filter.
         * </p>
         * 
         * @param nameContains
         *        The names of the router network interfaces to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(Collection<String> nameContains);

        /**
         * <p>
         * The names of the router network interfaces to include in the filter.
         * </p>
         * 
         * @param nameContains
         *        The names of the router network interfaces to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String... nameContains);
    }

    static final class BuilderImpl implements Builder {
        private List<String> regionNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> networkInterfaceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> nameContains = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterNetworkInterfaceFilter model) {
            regionNames(model.regionNames);
            networkInterfaceTypesWithStrings(model.networkInterfaceTypes);
            nameContains(model.nameContains);
        }

        public final Collection<String> getRegionNames() {
            if (regionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return regionNames;
        }

        public final void setRegionNames(Collection<String> regionNames) {
            Object oldValue = this.regionNames;
            this.regionNames = StringListCopier.copy(regionNames);
            handleUnionValueChange(Type.REGION_NAMES, oldValue, this.regionNames);
        }

        @Override
        public final Builder regionNames(Collection<String> regionNames) {
            Object oldValue = this.regionNames;
            this.regionNames = StringListCopier.copy(regionNames);
            handleUnionValueChange(Type.REGION_NAMES, oldValue, this.regionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionNames(String... regionNames) {
            regionNames(Arrays.asList(regionNames));
            return this;
        }

        public final Collection<String> getNetworkInterfaceTypes() {
            if (networkInterfaceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return networkInterfaceTypes;
        }

        public final void setNetworkInterfaceTypes(Collection<String> networkInterfaceTypes) {
            Object oldValue = this.networkInterfaceTypes;
            this.networkInterfaceTypes = RouterNetworkInterfaceTypeListCopier.copy(networkInterfaceTypes);
            handleUnionValueChange(Type.NETWORK_INTERFACE_TYPES, oldValue, this.networkInterfaceTypes);
        }

        @Override
        public final Builder networkInterfaceTypesWithStrings(Collection<String> networkInterfaceTypes) {
            Object oldValue = this.networkInterfaceTypes;
            this.networkInterfaceTypes = RouterNetworkInterfaceTypeListCopier.copy(networkInterfaceTypes);
            handleUnionValueChange(Type.NETWORK_INTERFACE_TYPES, oldValue, this.networkInterfaceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceTypesWithStrings(String... networkInterfaceTypes) {
            networkInterfaceTypesWithStrings(Arrays.asList(networkInterfaceTypes));
            return this;
        }

        @Override
        public final Builder networkInterfaceTypes(Collection<RouterNetworkInterfaceType> networkInterfaceTypes) {
            Object oldValue = this.networkInterfaceTypes;
            this.networkInterfaceTypes = RouterNetworkInterfaceTypeListCopier.copyEnumToString(networkInterfaceTypes);
            handleUnionValueChange(Type.NETWORK_INTERFACE_TYPES, oldValue, this.networkInterfaceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceTypes(RouterNetworkInterfaceType... networkInterfaceTypes) {
            networkInterfaceTypes(Arrays.asList(networkInterfaceTypes));
            return this;
        }

        public final Collection<String> getNameContains() {
            if (nameContains instanceof SdkAutoConstructList) {
                return null;
            }
            return nameContains;
        }

        public final void setNameContains(Collection<String> nameContains) {
            Object oldValue = this.nameContains;
            this.nameContains = StringListCopier.copy(nameContains);
            handleUnionValueChange(Type.NAME_CONTAINS, oldValue, this.nameContains);
        }

        @Override
        public final Builder nameContains(Collection<String> nameContains) {
            Object oldValue = this.nameContains;
            this.nameContains = StringListCopier.copy(nameContains);
            handleUnionValueChange(Type.NAME_CONTAINS, oldValue, this.nameContains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameContains(String... nameContains) {
            nameContains(Arrays.asList(nameContains));
            return this;
        }

        @Override
        public RouterNetworkInterfaceFilter build() {
            return new RouterNetworkInterfaceFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RouterNetworkInterfaceFilter#type()
     */
    public enum Type {
        REGION_NAMES,

        NETWORK_INTERFACE_TYPES,

        NAME_CONTAINS,

        UNKNOWN_TO_SDK_VERSION
    }
}
