/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The transit encryption settings for a router input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouterInputTransitEncryption implements SdkPojo, Serializable,
        ToCopyableBuilder<RouterInputTransitEncryption.Builder, RouterInputTransitEncryption> {
    private static final SdkField<String> ENCRYPTION_KEY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyType").getter(getter(RouterInputTransitEncryption::encryptionKeyTypeAsString))
            .setter(setter(Builder::encryptionKeyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyType").build()).build();

    private static final SdkField<RouterInputTransitEncryptionKeyConfiguration> ENCRYPTION_KEY_CONFIGURATION_FIELD = SdkField
            .<RouterInputTransitEncryptionKeyConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("EncryptionKeyConfiguration")
            .getter(getter(RouterInputTransitEncryption::encryptionKeyConfiguration))
            .setter(setter(Builder::encryptionKeyConfiguration))
            .constructor(RouterInputTransitEncryptionKeyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_KEY_TYPE_FIELD,
            ENCRYPTION_KEY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String encryptionKeyType;

    private final RouterInputTransitEncryptionKeyConfiguration encryptionKeyConfiguration;

    private RouterInputTransitEncryption(BuilderImpl builder) {
        this.encryptionKeyType = builder.encryptionKeyType;
        this.encryptionKeyConfiguration = builder.encryptionKeyConfiguration;
    }

    /**
     * <p>
     * Specifies the type of encryption key to use for transit encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionKeyType}
     * will return {@link RouterInputTransitEncryptionKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #encryptionKeyTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of encryption key to use for transit encryption.
     * @see RouterInputTransitEncryptionKeyType
     */
    public final RouterInputTransitEncryptionKeyType encryptionKeyType() {
        return RouterInputTransitEncryptionKeyType.fromValue(encryptionKeyType);
    }

    /**
     * <p>
     * Specifies the type of encryption key to use for transit encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionKeyType}
     * will return {@link RouterInputTransitEncryptionKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #encryptionKeyTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of encryption key to use for transit encryption.
     * @see RouterInputTransitEncryptionKeyType
     */
    public final String encryptionKeyTypeAsString() {
        return encryptionKeyType;
    }

    /**
     * <p>
     * Contains the configuration details for the encryption key used in transit encryption, including the key source
     * and associated parameters.
     * </p>
     * 
     * @return Contains the configuration details for the encryption key used in transit encryption, including the key
     *         source and associated parameters.
     */
    public final RouterInputTransitEncryptionKeyConfiguration encryptionKeyConfiguration() {
        return encryptionKeyConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInputTransitEncryption)) {
            return false;
        }
        RouterInputTransitEncryption other = (RouterInputTransitEncryption) obj;
        return Objects.equals(encryptionKeyTypeAsString(), other.encryptionKeyTypeAsString())
                && Objects.equals(encryptionKeyConfiguration(), other.encryptionKeyConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouterInputTransitEncryption").add("EncryptionKeyType", encryptionKeyTypeAsString())
                .add("EncryptionKeyConfiguration", encryptionKeyConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionKeyType":
            return Optional.ofNullable(clazz.cast(encryptionKeyTypeAsString()));
        case "EncryptionKeyConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionKeyConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("encryptionKeyType", ENCRYPTION_KEY_TYPE_FIELD);
        map.put("encryptionKeyConfiguration", ENCRYPTION_KEY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInputTransitEncryption, T> g) {
        return obj -> g.apply((RouterInputTransitEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouterInputTransitEncryption> {
        /**
         * <p>
         * Specifies the type of encryption key to use for transit encryption.
         * </p>
         * 
         * @param encryptionKeyType
         *        Specifies the type of encryption key to use for transit encryption.
         * @see RouterInputTransitEncryptionKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterInputTransitEncryptionKeyType
         */
        Builder encryptionKeyType(String encryptionKeyType);

        /**
         * <p>
         * Specifies the type of encryption key to use for transit encryption.
         * </p>
         * 
         * @param encryptionKeyType
         *        Specifies the type of encryption key to use for transit encryption.
         * @see RouterInputTransitEncryptionKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterInputTransitEncryptionKeyType
         */
        Builder encryptionKeyType(RouterInputTransitEncryptionKeyType encryptionKeyType);

        /**
         * <p>
         * Contains the configuration details for the encryption key used in transit encryption, including the key
         * source and associated parameters.
         * </p>
         * 
         * @param encryptionKeyConfiguration
         *        Contains the configuration details for the encryption key used in transit encryption, including the
         *        key source and associated parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyConfiguration(RouterInputTransitEncryptionKeyConfiguration encryptionKeyConfiguration);

        /**
         * <p>
         * Contains the configuration details for the encryption key used in transit encryption, including the key
         * source and associated parameters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RouterInputTransitEncryptionKeyConfiguration.Builder} avoiding the need to create one manually via
         * {@link RouterInputTransitEncryptionKeyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouterInputTransitEncryptionKeyConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #encryptionKeyConfiguration(RouterInputTransitEncryptionKeyConfiguration)}.
         * 
         * @param encryptionKeyConfiguration
         *        a consumer that will call methods on {@link RouterInputTransitEncryptionKeyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionKeyConfiguration(RouterInputTransitEncryptionKeyConfiguration)
         */
        default Builder encryptionKeyConfiguration(
                Consumer<RouterInputTransitEncryptionKeyConfiguration.Builder> encryptionKeyConfiguration) {
            return encryptionKeyConfiguration(RouterInputTransitEncryptionKeyConfiguration.builder()
                    .applyMutation(encryptionKeyConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String encryptionKeyType;

        private RouterInputTransitEncryptionKeyConfiguration encryptionKeyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInputTransitEncryption model) {
            encryptionKeyType(model.encryptionKeyType);
            encryptionKeyConfiguration(model.encryptionKeyConfiguration);
        }

        public final String getEncryptionKeyType() {
            return encryptionKeyType;
        }

        public final void setEncryptionKeyType(String encryptionKeyType) {
            this.encryptionKeyType = encryptionKeyType;
        }

        @Override
        public final Builder encryptionKeyType(String encryptionKeyType) {
            this.encryptionKeyType = encryptionKeyType;
            return this;
        }

        @Override
        public final Builder encryptionKeyType(RouterInputTransitEncryptionKeyType encryptionKeyType) {
            this.encryptionKeyType(encryptionKeyType == null ? null : encryptionKeyType.toString());
            return this;
        }

        public final RouterInputTransitEncryptionKeyConfiguration.Builder getEncryptionKeyConfiguration() {
            return encryptionKeyConfiguration != null ? encryptionKeyConfiguration.toBuilder() : null;
        }

        public final void setEncryptionKeyConfiguration(
                RouterInputTransitEncryptionKeyConfiguration.BuilderImpl encryptionKeyConfiguration) {
            this.encryptionKeyConfiguration = encryptionKeyConfiguration != null ? encryptionKeyConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionKeyConfiguration(RouterInputTransitEncryptionKeyConfiguration encryptionKeyConfiguration) {
            this.encryptionKeyConfiguration = encryptionKeyConfiguration;
            return this;
        }

        @Override
        public RouterInputTransitEncryption build() {
            return new RouterInputTransitEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
