/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a public router network interface, including the list of allowed CIDR blocks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicRouterNetworkInterfaceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PublicRouterNetworkInterfaceConfiguration.Builder, PublicRouterNetworkInterfaceConfiguration> {
    private static final SdkField<List<PublicRouterNetworkInterfaceRule>> ALLOW_RULES_FIELD = SdkField
            .<List<PublicRouterNetworkInterfaceRule>> builder(MarshallingType.LIST)
            .memberName("AllowRules")
            .getter(getter(PublicRouterNetworkInterfaceConfiguration::allowRules))
            .setter(setter(Builder::allowRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PublicRouterNetworkInterfaceRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(PublicRouterNetworkInterfaceRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PublicRouterNetworkInterfaceRule> allowRules;

    private PublicRouterNetworkInterfaceConfiguration(BuilderImpl builder) {
        this.allowRules = builder.allowRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowRules property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAllowRules() {
        return allowRules != null && !(allowRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of allowed CIDR blocks for the public router network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowRules} method.
     * </p>
     * 
     * @return The list of allowed CIDR blocks for the public router network interface.
     */
    public final List<PublicRouterNetworkInterfaceRule> allowRules() {
        return allowRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowRules() ? allowRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicRouterNetworkInterfaceConfiguration)) {
            return false;
        }
        PublicRouterNetworkInterfaceConfiguration other = (PublicRouterNetworkInterfaceConfiguration) obj;
        return hasAllowRules() == other.hasAllowRules() && Objects.equals(allowRules(), other.allowRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublicRouterNetworkInterfaceConfiguration")
                .add("AllowRules", hasAllowRules() ? allowRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowRules":
            return Optional.ofNullable(clazz.cast(allowRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowRules", ALLOW_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PublicRouterNetworkInterfaceConfiguration, T> g) {
        return obj -> g.apply((PublicRouterNetworkInterfaceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicRouterNetworkInterfaceConfiguration> {
        /**
         * <p>
         * The list of allowed CIDR blocks for the public router network interface.
         * </p>
         * 
         * @param allowRules
         *        The list of allowed CIDR blocks for the public router network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowRules(Collection<PublicRouterNetworkInterfaceRule> allowRules);

        /**
         * <p>
         * The list of allowed CIDR blocks for the public router network interface.
         * </p>
         * 
         * @param allowRules
         *        The list of allowed CIDR blocks for the public router network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowRules(PublicRouterNetworkInterfaceRule... allowRules);

        /**
         * <p>
         * The list of allowed CIDR blocks for the public router network interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.PublicRouterNetworkInterfaceRule.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.PublicRouterNetworkInterfaceRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.PublicRouterNetworkInterfaceRule.Builder#build()}
         * is called immediately and its result is passed to {@link #allowRules(List<PublicRouterNetworkInterfaceRule>)}.
         * 
         * @param allowRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.PublicRouterNetworkInterfaceRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowRules(java.util.Collection<PublicRouterNetworkInterfaceRule>)
         */
        Builder allowRules(Consumer<PublicRouterNetworkInterfaceRule.Builder>... allowRules);
    }

    static final class BuilderImpl implements Builder {
        private List<PublicRouterNetworkInterfaceRule> allowRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PublicRouterNetworkInterfaceConfiguration model) {
            allowRules(model.allowRules);
        }

        public final List<PublicRouterNetworkInterfaceRule.Builder> getAllowRules() {
            List<PublicRouterNetworkInterfaceRule.Builder> result = PublicRouterNetworkInterfaceConfigurationAllowRulesListCopier
                    .copyToBuilder(this.allowRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowRules(Collection<PublicRouterNetworkInterfaceRule.BuilderImpl> allowRules) {
            this.allowRules = PublicRouterNetworkInterfaceConfigurationAllowRulesListCopier.copyFromBuilder(allowRules);
        }

        @Override
        public final Builder allowRules(Collection<PublicRouterNetworkInterfaceRule> allowRules) {
            this.allowRules = PublicRouterNetworkInterfaceConfigurationAllowRulesListCopier.copy(allowRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowRules(PublicRouterNetworkInterfaceRule... allowRules) {
            allowRules(Arrays.asList(allowRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowRules(Consumer<PublicRouterNetworkInterfaceRule.Builder>... allowRules) {
            allowRules(Stream.of(allowRules).map(c -> PublicRouterNetworkInterfaceRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PublicRouterNetworkInterfaceConfiguration build() {
            return new PublicRouterNetworkInterfaceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
