/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration details for a merge router input that combines two input sources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeRouterInputStreamDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<MergeRouterInputStreamDetails.Builder, MergeRouterInputStreamDetails> {
    private static final SdkField<MergeRouterInputIndexedStreamDetails> SOURCE_INDEX_ZERO_STREAM_DETAILS_FIELD = SdkField
            .<MergeRouterInputIndexedStreamDetails> builder(MarshallingType.SDK_POJO)
            .memberName("SourceIndexZeroStreamDetails")
            .getter(getter(MergeRouterInputStreamDetails::sourceIndexZeroStreamDetails))
            .setter(setter(Builder::sourceIndexZeroStreamDetails))
            .constructor(MergeRouterInputIndexedStreamDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIndexZeroStreamDetails")
                    .build()).build();

    private static final SdkField<MergeRouterInputIndexedStreamDetails> SOURCE_INDEX_ONE_STREAM_DETAILS_FIELD = SdkField
            .<MergeRouterInputIndexedStreamDetails> builder(MarshallingType.SDK_POJO)
            .memberName("SourceIndexOneStreamDetails")
            .getter(getter(MergeRouterInputStreamDetails::sourceIndexOneStreamDetails))
            .setter(setter(Builder::sourceIndexOneStreamDetails))
            .constructor(MergeRouterInputIndexedStreamDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIndexOneStreamDetails")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_INDEX_ZERO_STREAM_DETAILS_FIELD, SOURCE_INDEX_ONE_STREAM_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MergeRouterInputIndexedStreamDetails sourceIndexZeroStreamDetails;

    private final MergeRouterInputIndexedStreamDetails sourceIndexOneStreamDetails;

    private MergeRouterInputStreamDetails(BuilderImpl builder) {
        this.sourceIndexZeroStreamDetails = builder.sourceIndexZeroStreamDetails;
        this.sourceIndexOneStreamDetails = builder.sourceIndexOneStreamDetails;
    }

    /**
     * <p>
     * Configuration details for the first source (index 0) in the merge setup.
     * </p>
     * 
     * @return Configuration details for the first source (index 0) in the merge setup.
     */
    public final MergeRouterInputIndexedStreamDetails sourceIndexZeroStreamDetails() {
        return sourceIndexZeroStreamDetails;
    }

    /**
     * <p>
     * Configuration details for the second source (index 1) in the merge setup.
     * </p>
     * 
     * @return Configuration details for the second source (index 1) in the merge setup.
     */
    public final MergeRouterInputIndexedStreamDetails sourceIndexOneStreamDetails() {
        return sourceIndexOneStreamDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceIndexZeroStreamDetails());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIndexOneStreamDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeRouterInputStreamDetails)) {
            return false;
        }
        MergeRouterInputStreamDetails other = (MergeRouterInputStreamDetails) obj;
        return Objects.equals(sourceIndexZeroStreamDetails(), other.sourceIndexZeroStreamDetails())
                && Objects.equals(sourceIndexOneStreamDetails(), other.sourceIndexOneStreamDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MergeRouterInputStreamDetails")
                .add("SourceIndexZeroStreamDetails", sourceIndexZeroStreamDetails())
                .add("SourceIndexOneStreamDetails", sourceIndexOneStreamDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceIndexZeroStreamDetails":
            return Optional.ofNullable(clazz.cast(sourceIndexZeroStreamDetails()));
        case "SourceIndexOneStreamDetails":
            return Optional.ofNullable(clazz.cast(sourceIndexOneStreamDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceIndexZeroStreamDetails", SOURCE_INDEX_ZERO_STREAM_DETAILS_FIELD);
        map.put("sourceIndexOneStreamDetails", SOURCE_INDEX_ONE_STREAM_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MergeRouterInputStreamDetails, T> g) {
        return obj -> g.apply((MergeRouterInputStreamDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MergeRouterInputStreamDetails> {
        /**
         * <p>
         * Configuration details for the first source (index 0) in the merge setup.
         * </p>
         * 
         * @param sourceIndexZeroStreamDetails
         *        Configuration details for the first source (index 0) in the merge setup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIndexZeroStreamDetails(MergeRouterInputIndexedStreamDetails sourceIndexZeroStreamDetails);

        /**
         * <p>
         * Configuration details for the first source (index 0) in the merge setup.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MergeRouterInputIndexedStreamDetails.Builder} avoiding the need to create one manually via
         * {@link MergeRouterInputIndexedStreamDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MergeRouterInputIndexedStreamDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #sourceIndexZeroStreamDetails(MergeRouterInputIndexedStreamDetails)}.
         * 
         * @param sourceIndexZeroStreamDetails
         *        a consumer that will call methods on {@link MergeRouterInputIndexedStreamDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceIndexZeroStreamDetails(MergeRouterInputIndexedStreamDetails)
         */
        default Builder sourceIndexZeroStreamDetails(
                Consumer<MergeRouterInputIndexedStreamDetails.Builder> sourceIndexZeroStreamDetails) {
            return sourceIndexZeroStreamDetails(MergeRouterInputIndexedStreamDetails.builder()
                    .applyMutation(sourceIndexZeroStreamDetails).build());
        }

        /**
         * <p>
         * Configuration details for the second source (index 1) in the merge setup.
         * </p>
         * 
         * @param sourceIndexOneStreamDetails
         *        Configuration details for the second source (index 1) in the merge setup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIndexOneStreamDetails(MergeRouterInputIndexedStreamDetails sourceIndexOneStreamDetails);

        /**
         * <p>
         * Configuration details for the second source (index 1) in the merge setup.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MergeRouterInputIndexedStreamDetails.Builder} avoiding the need to create one manually via
         * {@link MergeRouterInputIndexedStreamDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MergeRouterInputIndexedStreamDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #sourceIndexOneStreamDetails(MergeRouterInputIndexedStreamDetails)}.
         * 
         * @param sourceIndexOneStreamDetails
         *        a consumer that will call methods on {@link MergeRouterInputIndexedStreamDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceIndexOneStreamDetails(MergeRouterInputIndexedStreamDetails)
         */
        default Builder sourceIndexOneStreamDetails(
                Consumer<MergeRouterInputIndexedStreamDetails.Builder> sourceIndexOneStreamDetails) {
            return sourceIndexOneStreamDetails(MergeRouterInputIndexedStreamDetails.builder()
                    .applyMutation(sourceIndexOneStreamDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MergeRouterInputIndexedStreamDetails sourceIndexZeroStreamDetails;

        private MergeRouterInputIndexedStreamDetails sourceIndexOneStreamDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeRouterInputStreamDetails model) {
            sourceIndexZeroStreamDetails(model.sourceIndexZeroStreamDetails);
            sourceIndexOneStreamDetails(model.sourceIndexOneStreamDetails);
        }

        public final MergeRouterInputIndexedStreamDetails.Builder getSourceIndexZeroStreamDetails() {
            return sourceIndexZeroStreamDetails != null ? sourceIndexZeroStreamDetails.toBuilder() : null;
        }

        public final void setSourceIndexZeroStreamDetails(
                MergeRouterInputIndexedStreamDetails.BuilderImpl sourceIndexZeroStreamDetails) {
            this.sourceIndexZeroStreamDetails = sourceIndexZeroStreamDetails != null ? sourceIndexZeroStreamDetails.build()
                    : null;
        }

        @Override
        public final Builder sourceIndexZeroStreamDetails(MergeRouterInputIndexedStreamDetails sourceIndexZeroStreamDetails) {
            this.sourceIndexZeroStreamDetails = sourceIndexZeroStreamDetails;
            return this;
        }

        public final MergeRouterInputIndexedStreamDetails.Builder getSourceIndexOneStreamDetails() {
            return sourceIndexOneStreamDetails != null ? sourceIndexOneStreamDetails.toBuilder() : null;
        }

        public final void setSourceIndexOneStreamDetails(
                MergeRouterInputIndexedStreamDetails.BuilderImpl sourceIndexOneStreamDetails) {
            this.sourceIndexOneStreamDetails = sourceIndexOneStreamDetails != null ? sourceIndexOneStreamDetails.build() : null;
        }

        @Override
        public final Builder sourceIndexOneStreamDetails(MergeRouterInputIndexedStreamDetails sourceIndexOneStreamDetails) {
            this.sourceIndexOneStreamDetails = sourceIndexOneStreamDetails;
            return this;
        }

        @Override
        public MergeRouterInputStreamDetails build() {
            return new MergeRouterInputStreamDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
