/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for the MediaLive transit encryption key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaLiveTransitEncryptionKeyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaLiveTransitEncryptionKeyConfiguration.Builder, MediaLiveTransitEncryptionKeyConfiguration> {
    private static final SdkField<SecretsManagerEncryptionKeyConfiguration> SECRETS_MANAGER_FIELD = SdkField
            .<SecretsManagerEncryptionKeyConfiguration> builder(MarshallingType.SDK_POJO).memberName("SecretsManager")
            .getter(getter(MediaLiveTransitEncryptionKeyConfiguration::secretsManager)).setter(setter(Builder::secretsManager))
            .constructor(SecretsManagerEncryptionKeyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsManager").build()).build();

    private static final SdkField<AutomaticEncryptionKeyConfiguration> AUTOMATIC_FIELD = SdkField
            .<AutomaticEncryptionKeyConfiguration> builder(MarshallingType.SDK_POJO).memberName("Automatic")
            .getter(getter(MediaLiveTransitEncryptionKeyConfiguration::automatic)).setter(setter(Builder::automatic))
            .constructor(AutomaticEncryptionKeyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automatic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRETS_MANAGER_FIELD,
            AUTOMATIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SecretsManagerEncryptionKeyConfiguration secretsManager;

    private final AutomaticEncryptionKeyConfiguration automatic;

    private final Type type;

    private MediaLiveTransitEncryptionKeyConfiguration(BuilderImpl builder) {
        this.secretsManager = builder.secretsManager;
        this.automatic = builder.automatic;
        this.type = builder.type;
    }

    /**
     * Returns the value of the SecretsManager property for this object.
     * 
     * @return The value of the SecretsManager property for this object.
     */
    public final SecretsManagerEncryptionKeyConfiguration secretsManager() {
        return secretsManager;
    }

    /**
     * Returns the value of the Automatic property for this object.
     * 
     * @return The value of the Automatic property for this object.
     */
    public final AutomaticEncryptionKeyConfiguration automatic() {
        return automatic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretsManager());
        hashCode = 31 * hashCode + Objects.hashCode(automatic());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaLiveTransitEncryptionKeyConfiguration)) {
            return false;
        }
        MediaLiveTransitEncryptionKeyConfiguration other = (MediaLiveTransitEncryptionKeyConfiguration) obj;
        return Objects.equals(secretsManager(), other.secretsManager()) && Objects.equals(automatic(), other.automatic());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaLiveTransitEncryptionKeyConfiguration").add("SecretsManager", secretsManager())
                .add("Automatic", automatic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretsManager":
            return Optional.ofNullable(clazz.cast(secretsManager()));
        case "Automatic":
            return Optional.ofNullable(clazz.cast(automatic()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #secretsManager()} initialized to the given value.
     *
     * Sets the value of the SecretsManager property for this object.
     *
     * @param secretsManager
     *        The new value for the SecretsManager property for this object.
     */
    public static MediaLiveTransitEncryptionKeyConfiguration fromSecretsManager(
            SecretsManagerEncryptionKeyConfiguration secretsManager) {
        return builder().secretsManager(secretsManager).build();
    }

    /**
     * Create an instance of this class with {@link #secretsManager()} initialized to the given value.
     *
     * Sets the value of the SecretsManager property for this object.
     *
     * @param secretsManager
     *        The new value for the SecretsManager property for this object.
     */
    public static MediaLiveTransitEncryptionKeyConfiguration fromSecretsManager(
            Consumer<SecretsManagerEncryptionKeyConfiguration.Builder> secretsManager) {
        SecretsManagerEncryptionKeyConfiguration.Builder builder = SecretsManagerEncryptionKeyConfiguration.builder();
        secretsManager.accept(builder);
        return fromSecretsManager(builder.build());
    }

    /**
     * Create an instance of this class with {@link #automatic()} initialized to the given value.
     *
     * Sets the value of the Automatic property for this object.
     *
     * @param automatic
     *        The new value for the Automatic property for this object.
     */
    public static MediaLiveTransitEncryptionKeyConfiguration fromAutomatic(AutomaticEncryptionKeyConfiguration automatic) {
        return builder().automatic(automatic).build();
    }

    /**
     * Create an instance of this class with {@link #automatic()} initialized to the given value.
     *
     * Sets the value of the Automatic property for this object.
     *
     * @param automatic
     *        The new value for the Automatic property for this object.
     */
    public static MediaLiveTransitEncryptionKeyConfiguration fromAutomatic(
            Consumer<AutomaticEncryptionKeyConfiguration.Builder> automatic) {
        AutomaticEncryptionKeyConfiguration.Builder builder = AutomaticEncryptionKeyConfiguration.builder();
        automatic.accept(builder);
        return fromAutomatic(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("secretsManager", SECRETS_MANAGER_FIELD);
        map.put("automatic", AUTOMATIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaLiveTransitEncryptionKeyConfiguration, T> g) {
        return obj -> g.apply((MediaLiveTransitEncryptionKeyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaLiveTransitEncryptionKeyConfiguration> {
        /**
         * Sets the value of the SecretsManager property for this object.
         *
         * @param secretsManager
         *        The new value for the SecretsManager property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManager(SecretsManagerEncryptionKeyConfiguration secretsManager);

        /**
         * Sets the value of the SecretsManager property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link SecretsManagerEncryptionKeyConfiguration.Builder} avoiding the need to create one manually via
         * {@link SecretsManagerEncryptionKeyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecretsManagerEncryptionKeyConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #secretsManager(SecretsManagerEncryptionKeyConfiguration)}.
         * 
         * @param secretsManager
         *        a consumer that will call methods on {@link SecretsManagerEncryptionKeyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretsManager(SecretsManagerEncryptionKeyConfiguration)
         */
        default Builder secretsManager(Consumer<SecretsManagerEncryptionKeyConfiguration.Builder> secretsManager) {
            return secretsManager(SecretsManagerEncryptionKeyConfiguration.builder().applyMutation(secretsManager).build());
        }

        /**
         * Sets the value of the Automatic property for this object.
         *
         * @param automatic
         *        The new value for the Automatic property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatic(AutomaticEncryptionKeyConfiguration automatic);

        /**
         * Sets the value of the Automatic property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link AutomaticEncryptionKeyConfiguration.Builder} avoiding the need to create one manually via
         * {@link AutomaticEncryptionKeyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomaticEncryptionKeyConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #automatic(AutomaticEncryptionKeyConfiguration)}.
         * 
         * @param automatic
         *        a consumer that will call methods on {@link AutomaticEncryptionKeyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automatic(AutomaticEncryptionKeyConfiguration)
         */
        default Builder automatic(Consumer<AutomaticEncryptionKeyConfiguration.Builder> automatic) {
            return automatic(AutomaticEncryptionKeyConfiguration.builder().applyMutation(automatic).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SecretsManagerEncryptionKeyConfiguration secretsManager;

        private AutomaticEncryptionKeyConfiguration automatic;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MediaLiveTransitEncryptionKeyConfiguration model) {
            secretsManager(model.secretsManager);
            automatic(model.automatic);
        }

        public final SecretsManagerEncryptionKeyConfiguration.Builder getSecretsManager() {
            return secretsManager != null ? secretsManager.toBuilder() : null;
        }

        public final void setSecretsManager(SecretsManagerEncryptionKeyConfiguration.BuilderImpl secretsManager) {
            Object oldValue = this.secretsManager;
            this.secretsManager = secretsManager != null ? secretsManager.build() : null;
            handleUnionValueChange(Type.SECRETS_MANAGER, oldValue, this.secretsManager);
        }

        @Override
        public final Builder secretsManager(SecretsManagerEncryptionKeyConfiguration secretsManager) {
            Object oldValue = this.secretsManager;
            this.secretsManager = secretsManager;
            handleUnionValueChange(Type.SECRETS_MANAGER, oldValue, this.secretsManager);
            return this;
        }

        public final AutomaticEncryptionKeyConfiguration.Builder getAutomatic() {
            return automatic != null ? automatic.toBuilder() : null;
        }

        public final void setAutomatic(AutomaticEncryptionKeyConfiguration.BuilderImpl automatic) {
            Object oldValue = this.automatic;
            this.automatic = automatic != null ? automatic.build() : null;
            handleUnionValueChange(Type.AUTOMATIC, oldValue, this.automatic);
        }

        @Override
        public final Builder automatic(AutomaticEncryptionKeyConfiguration automatic) {
            Object oldValue = this.automatic;
            this.automatic = automatic;
            handleUnionValueChange(Type.AUTOMATIC, oldValue, this.automatic);
            return this;
        }

        @Override
        public MediaLiveTransitEncryptionKeyConfiguration build() {
            return new MediaLiveTransitEncryptionKeyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see MediaLiveTransitEncryptionKeyConfiguration#type()
     */
    public enum Type {
        SECRETS_MANAGER,

        AUTOMATIC,

        UNKNOWN_TO_SDK_VERSION
    }
}
