/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for connecting a router output to a MediaLive input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaLiveInputRouterOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaLiveInputRouterOutputConfiguration.Builder, MediaLiveInputRouterOutputConfiguration> {
    private static final SdkField<String> MEDIA_LIVE_INPUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaLiveInputArn").getter(getter(MediaLiveInputRouterOutputConfiguration::mediaLiveInputArn))
            .setter(setter(Builder::mediaLiveInputArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaLiveInputArn").build()).build();

    private static final SdkField<String> MEDIA_LIVE_PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaLivePipelineId")
            .getter(getter(MediaLiveInputRouterOutputConfiguration::mediaLivePipelineIdAsString))
            .setter(setter(Builder::mediaLivePipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaLivePipelineId").build())
            .build();

    private static final SdkField<MediaLiveTransitEncryption> DESTINATION_TRANSIT_ENCRYPTION_FIELD = SdkField
            .<MediaLiveTransitEncryption> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationTransitEncryption")
            .getter(getter(MediaLiveInputRouterOutputConfiguration::destinationTransitEncryption))
            .setter(setter(Builder::destinationTransitEncryption))
            .constructor(MediaLiveTransitEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationTransitEncryption")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_LIVE_INPUT_ARN_FIELD,
            MEDIA_LIVE_PIPELINE_ID_FIELD, DESTINATION_TRANSIT_ENCRYPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mediaLiveInputArn;

    private final String mediaLivePipelineId;

    private final MediaLiveTransitEncryption destinationTransitEncryption;

    private MediaLiveInputRouterOutputConfiguration(BuilderImpl builder) {
        this.mediaLiveInputArn = builder.mediaLiveInputArn;
        this.mediaLivePipelineId = builder.mediaLivePipelineId;
        this.destinationTransitEncryption = builder.destinationTransitEncryption;
    }

    /**
     * <p>
     * The ARN of the MediaLive input to connect to this router output.
     * </p>
     * 
     * @return The ARN of the MediaLive input to connect to this router output.
     */
    public final String mediaLiveInputArn() {
        return mediaLiveInputArn;
    }

    /**
     * <p>
     * The index of the MediaLive pipeline to connect to this router output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mediaLivePipelineId} will return {@link MediaLiveInputPipelineId#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mediaLivePipelineIdAsString}.
     * </p>
     * 
     * @return The index of the MediaLive pipeline to connect to this router output.
     * @see MediaLiveInputPipelineId
     */
    public final MediaLiveInputPipelineId mediaLivePipelineId() {
        return MediaLiveInputPipelineId.fromValue(mediaLivePipelineId);
    }

    /**
     * <p>
     * The index of the MediaLive pipeline to connect to this router output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mediaLivePipelineId} will return {@link MediaLiveInputPipelineId#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mediaLivePipelineIdAsString}.
     * </p>
     * 
     * @return The index of the MediaLive pipeline to connect to this router output.
     * @see MediaLiveInputPipelineId
     */
    public final String mediaLivePipelineIdAsString() {
        return mediaLivePipelineId;
    }

    /**
     * <p>
     * The encryption configuration for the MediaLive input when connected to this router output.
     * </p>
     * 
     * @return The encryption configuration for the MediaLive input when connected to this router output.
     */
    public final MediaLiveTransitEncryption destinationTransitEncryption() {
        return destinationTransitEncryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaLiveInputArn());
        hashCode = 31 * hashCode + Objects.hashCode(mediaLivePipelineIdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTransitEncryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaLiveInputRouterOutputConfiguration)) {
            return false;
        }
        MediaLiveInputRouterOutputConfiguration other = (MediaLiveInputRouterOutputConfiguration) obj;
        return Objects.equals(mediaLiveInputArn(), other.mediaLiveInputArn())
                && Objects.equals(mediaLivePipelineIdAsString(), other.mediaLivePipelineIdAsString())
                && Objects.equals(destinationTransitEncryption(), other.destinationTransitEncryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaLiveInputRouterOutputConfiguration").add("MediaLiveInputArn", mediaLiveInputArn())
                .add("MediaLivePipelineId", mediaLivePipelineIdAsString())
                .add("DestinationTransitEncryption", destinationTransitEncryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaLiveInputArn":
            return Optional.ofNullable(clazz.cast(mediaLiveInputArn()));
        case "MediaLivePipelineId":
            return Optional.ofNullable(clazz.cast(mediaLivePipelineIdAsString()));
        case "DestinationTransitEncryption":
            return Optional.ofNullable(clazz.cast(destinationTransitEncryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mediaLiveInputArn", MEDIA_LIVE_INPUT_ARN_FIELD);
        map.put("mediaLivePipelineId", MEDIA_LIVE_PIPELINE_ID_FIELD);
        map.put("destinationTransitEncryption", DESTINATION_TRANSIT_ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaLiveInputRouterOutputConfiguration, T> g) {
        return obj -> g.apply((MediaLiveInputRouterOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaLiveInputRouterOutputConfiguration> {
        /**
         * <p>
         * The ARN of the MediaLive input to connect to this router output.
         * </p>
         * 
         * @param mediaLiveInputArn
         *        The ARN of the MediaLive input to connect to this router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaLiveInputArn(String mediaLiveInputArn);

        /**
         * <p>
         * The index of the MediaLive pipeline to connect to this router output.
         * </p>
         * 
         * @param mediaLivePipelineId
         *        The index of the MediaLive pipeline to connect to this router output.
         * @see MediaLiveInputPipelineId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaLiveInputPipelineId
         */
        Builder mediaLivePipelineId(String mediaLivePipelineId);

        /**
         * <p>
         * The index of the MediaLive pipeline to connect to this router output.
         * </p>
         * 
         * @param mediaLivePipelineId
         *        The index of the MediaLive pipeline to connect to this router output.
         * @see MediaLiveInputPipelineId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaLiveInputPipelineId
         */
        Builder mediaLivePipelineId(MediaLiveInputPipelineId mediaLivePipelineId);

        /**
         * <p>
         * The encryption configuration for the MediaLive input when connected to this router output.
         * </p>
         * 
         * @param destinationTransitEncryption
         *        The encryption configuration for the MediaLive input when connected to this router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTransitEncryption(MediaLiveTransitEncryption destinationTransitEncryption);

        /**
         * <p>
         * The encryption configuration for the MediaLive input when connected to this router output.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaLiveTransitEncryption.Builder}
         * avoiding the need to create one manually via {@link MediaLiveTransitEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaLiveTransitEncryption.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationTransitEncryption(MediaLiveTransitEncryption)}.
         * 
         * @param destinationTransitEncryption
         *        a consumer that will call methods on {@link MediaLiveTransitEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationTransitEncryption(MediaLiveTransitEncryption)
         */
        default Builder destinationTransitEncryption(Consumer<MediaLiveTransitEncryption.Builder> destinationTransitEncryption) {
            return destinationTransitEncryption(MediaLiveTransitEncryption.builder().applyMutation(destinationTransitEncryption)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String mediaLiveInputArn;

        private String mediaLivePipelineId;

        private MediaLiveTransitEncryption destinationTransitEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaLiveInputRouterOutputConfiguration model) {
            mediaLiveInputArn(model.mediaLiveInputArn);
            mediaLivePipelineId(model.mediaLivePipelineId);
            destinationTransitEncryption(model.destinationTransitEncryption);
        }

        public final String getMediaLiveInputArn() {
            return mediaLiveInputArn;
        }

        public final void setMediaLiveInputArn(String mediaLiveInputArn) {
            this.mediaLiveInputArn = mediaLiveInputArn;
        }

        @Override
        public final Builder mediaLiveInputArn(String mediaLiveInputArn) {
            this.mediaLiveInputArn = mediaLiveInputArn;
            return this;
        }

        public final String getMediaLivePipelineId() {
            return mediaLivePipelineId;
        }

        public final void setMediaLivePipelineId(String mediaLivePipelineId) {
            this.mediaLivePipelineId = mediaLivePipelineId;
        }

        @Override
        public final Builder mediaLivePipelineId(String mediaLivePipelineId) {
            this.mediaLivePipelineId = mediaLivePipelineId;
            return this;
        }

        @Override
        public final Builder mediaLivePipelineId(MediaLiveInputPipelineId mediaLivePipelineId) {
            this.mediaLivePipelineId(mediaLivePipelineId == null ? null : mediaLivePipelineId.toString());
            return this;
        }

        public final MediaLiveTransitEncryption.Builder getDestinationTransitEncryption() {
            return destinationTransitEncryption != null ? destinationTransitEncryption.toBuilder() : null;
        }

        public final void setDestinationTransitEncryption(MediaLiveTransitEncryption.BuilderImpl destinationTransitEncryption) {
            this.destinationTransitEncryption = destinationTransitEncryption != null ? destinationTransitEncryption.build()
                    : null;
        }

        @Override
        public final Builder destinationTransitEncryption(MediaLiveTransitEncryption destinationTransitEncryption) {
            this.destinationTransitEncryption = destinationTransitEncryption;
            return this;
        }

        @Override
        public MediaLiveInputRouterOutputConfiguration build() {
            return new MediaLiveInputRouterOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
