/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for connecting a router input to a flow output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaConnectFlowRouterInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaConnectFlowRouterInputConfiguration.Builder, MediaConnectFlowRouterInputConfiguration> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(MediaConnectFlowRouterInputConfiguration::flowArn))
            .setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<String> FLOW_OUTPUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowOutputArn").getter(getter(MediaConnectFlowRouterInputConfiguration::flowOutputArn))
            .setter(setter(Builder::flowOutputArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowOutputArn").build()).build();

    private static final SdkField<FlowTransitEncryption> SOURCE_TRANSIT_DECRYPTION_FIELD = SdkField
            .<FlowTransitEncryption> builder(MarshallingType.SDK_POJO).memberName("SourceTransitDecryption")
            .getter(getter(MediaConnectFlowRouterInputConfiguration::sourceTransitDecryption))
            .setter(setter(Builder::sourceTransitDecryption)).constructor(FlowTransitEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTransitDecryption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            FLOW_OUTPUT_ARN_FIELD, SOURCE_TRANSIT_DECRYPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String flowArn;

    private final String flowOutputArn;

    private final FlowTransitEncryption sourceTransitDecryption;

    private MediaConnectFlowRouterInputConfiguration(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.flowOutputArn = builder.flowOutputArn;
        this.sourceTransitDecryption = builder.sourceTransitDecryption;
    }

    /**
     * <p>
     * The ARN of the flow to connect to.
     * </p>
     * 
     * @return The ARN of the flow to connect to.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * <p>
     * The ARN of the flow output to connect to this router input.
     * </p>
     * 
     * @return The ARN of the flow output to connect to this router input.
     */
    public final String flowOutputArn() {
        return flowOutputArn;
    }

    /**
     * <p>
     * The decryption configuration for the flow source when connected to this router input.
     * </p>
     * 
     * @return The decryption configuration for the flow source when connected to this router input.
     */
    public final FlowTransitEncryption sourceTransitDecryption() {
        return sourceTransitDecryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowOutputArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTransitDecryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaConnectFlowRouterInputConfiguration)) {
            return false;
        }
        MediaConnectFlowRouterInputConfiguration other = (MediaConnectFlowRouterInputConfiguration) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(flowOutputArn(), other.flowOutputArn())
                && Objects.equals(sourceTransitDecryption(), other.sourceTransitDecryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaConnectFlowRouterInputConfiguration").add("FlowArn", flowArn())
                .add("FlowOutputArn", flowOutputArn()).add("SourceTransitDecryption", sourceTransitDecryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "FlowOutputArn":
            return Optional.ofNullable(clazz.cast(flowOutputArn()));
        case "SourceTransitDecryption":
            return Optional.ofNullable(clazz.cast(sourceTransitDecryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowArn", FLOW_ARN_FIELD);
        map.put("flowOutputArn", FLOW_OUTPUT_ARN_FIELD);
        map.put("sourceTransitDecryption", SOURCE_TRANSIT_DECRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaConnectFlowRouterInputConfiguration, T> g) {
        return obj -> g.apply((MediaConnectFlowRouterInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaConnectFlowRouterInputConfiguration> {
        /**
         * <p>
         * The ARN of the flow to connect to.
         * </p>
         * 
         * @param flowArn
         *        The ARN of the flow to connect to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * <p>
         * The ARN of the flow output to connect to this router input.
         * </p>
         * 
         * @param flowOutputArn
         *        The ARN of the flow output to connect to this router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowOutputArn(String flowOutputArn);

        /**
         * <p>
         * The decryption configuration for the flow source when connected to this router input.
         * </p>
         * 
         * @param sourceTransitDecryption
         *        The decryption configuration for the flow source when connected to this router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTransitDecryption(FlowTransitEncryption sourceTransitDecryption);

        /**
         * <p>
         * The decryption configuration for the flow source when connected to this router input.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowTransitEncryption.Builder} avoiding
         * the need to create one manually via {@link FlowTransitEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowTransitEncryption.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceTransitDecryption(FlowTransitEncryption)}.
         * 
         * @param sourceTransitDecryption
         *        a consumer that will call methods on {@link FlowTransitEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceTransitDecryption(FlowTransitEncryption)
         */
        default Builder sourceTransitDecryption(Consumer<FlowTransitEncryption.Builder> sourceTransitDecryption) {
            return sourceTransitDecryption(FlowTransitEncryption.builder().applyMutation(sourceTransitDecryption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String flowArn;

        private String flowOutputArn;

        private FlowTransitEncryption sourceTransitDecryption;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaConnectFlowRouterInputConfiguration model) {
            flowArn(model.flowArn);
            flowOutputArn(model.flowOutputArn);
            sourceTransitDecryption(model.sourceTransitDecryption);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getFlowOutputArn() {
            return flowOutputArn;
        }

        public final void setFlowOutputArn(String flowOutputArn) {
            this.flowOutputArn = flowOutputArn;
        }

        @Override
        public final Builder flowOutputArn(String flowOutputArn) {
            this.flowOutputArn = flowOutputArn;
            return this;
        }

        public final FlowTransitEncryption.Builder getSourceTransitDecryption() {
            return sourceTransitDecryption != null ? sourceTransitDecryption.toBuilder() : null;
        }

        public final void setSourceTransitDecryption(FlowTransitEncryption.BuilderImpl sourceTransitDecryption) {
            this.sourceTransitDecryption = sourceTransitDecryption != null ? sourceTransitDecryption.build() : null;
        }

        @Override
        public final Builder sourceTransitDecryption(FlowTransitEncryption sourceTransitDecryption) {
            this.sourceTransitDecryption = sourceTransitDecryption;
            return this;
        }

        @Override
        public MediaConnectFlowRouterInputConfiguration build() {
            return new MediaConnectFlowRouterInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
