/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a router output, including its name, type, ARN, ID, state, routed state, and other key details. This
 * structure is used in the response of the ListRouterOutputs operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedRouterOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<ListedRouterOutput.Builder, ListedRouterOutput> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListedRouterOutput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListedRouterOutput::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ListedRouterOutput::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputType").getter(getter(ListedRouterOutput::outputTypeAsString)).setter(setter(Builder::outputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputType").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ListedRouterOutput::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> ROUTED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutedState").getter(getter(ListedRouterOutput::routedStateAsString))
            .setter(setter(Builder::routedState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routedState").build()).build();

    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(ListedRouterOutput::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(ListedRouterOutput::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<Long> MAXIMUM_BITRATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaximumBitrate").getter(getter(ListedRouterOutput::maximumBitrate))
            .setter(setter(Builder::maximumBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBitrate").build()).build();

    private static final SdkField<String> ROUTING_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingScope").getter(getter(ListedRouterOutput::routingScopeAsString))
            .setter(setter(Builder::routingScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingScope").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(ListedRouterOutput::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt")
            .getter(getter(ListedRouterOutput::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> MESSAGE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MessageCount").getter(getter(ListedRouterOutput::messageCount)).setter(setter(Builder::messageCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageCount").build()).build();

    private static final SdkField<String> ROUTED_INPUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutedInputArn").getter(getter(ListedRouterOutput::routedInputArn))
            .setter(setter(Builder::routedInputArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routedInputArn").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceArn").getter(getter(ListedRouterOutput::networkInterfaceArn))
            .setter(setter(Builder::networkInterfaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceArn").build())
            .build();

    private static final SdkField<String> MAINTENANCE_SCHEDULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceScheduleType").getter(getter(ListedRouterOutput::maintenanceScheduleTypeAsString))
            .setter(setter(Builder::maintenanceScheduleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceScheduleType").build())
            .build();

    private static final SdkField<MaintenanceSchedule> MAINTENANCE_SCHEDULE_FIELD = SdkField
            .<MaintenanceSchedule> builder(MarshallingType.SDK_POJO).memberName("MaintenanceSchedule")
            .getter(getter(ListedRouterOutput::maintenanceSchedule)).setter(setter(Builder::maintenanceSchedule))
            .constructor(MaintenanceSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceSchedule").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            ID_FIELD, OUTPUT_TYPE_FIELD, STATE_FIELD, ROUTED_STATE_FIELD, REGION_NAME_FIELD, AVAILABILITY_ZONE_FIELD,
            MAXIMUM_BITRATE_FIELD, ROUTING_SCOPE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, MESSAGE_COUNT_FIELD,
            ROUTED_INPUT_ARN_FIELD, NETWORK_INTERFACE_ARN_FIELD, MAINTENANCE_SCHEDULE_TYPE_FIELD, MAINTENANCE_SCHEDULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String id;

    private final String outputType;

    private final String state;

    private final String routedState;

    private final String regionName;

    private final String availabilityZone;

    private final Long maximumBitrate;

    private final String routingScope;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final Integer messageCount;

    private final String routedInputArn;

    private final String networkInterfaceArn;

    private final String maintenanceScheduleType;

    private final MaintenanceSchedule maintenanceSchedule;

    private ListedRouterOutput(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.id = builder.id;
        this.outputType = builder.outputType;
        this.state = builder.state;
        this.routedState = builder.routedState;
        this.regionName = builder.regionName;
        this.availabilityZone = builder.availabilityZone;
        this.maximumBitrate = builder.maximumBitrate;
        this.routingScope = builder.routingScope;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.messageCount = builder.messageCount;
        this.routedInputArn = builder.routedInputArn;
        this.networkInterfaceArn = builder.networkInterfaceArn;
        this.maintenanceScheduleType = builder.maintenanceScheduleType;
        this.maintenanceSchedule = builder.maintenanceSchedule;
    }

    /**
     * <p>
     * The name of the router output.
     * </p>
     * 
     * @return The name of the router output.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the router output.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the router output.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier of the router output.
     * </p>
     * 
     * @return The unique identifier of the router output.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the router output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputType} will
     * return {@link RouterOutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputTypeAsString}.
     * </p>
     * 
     * @return The type of the router output.
     * @see RouterOutputType
     */
    public final RouterOutputType outputType() {
        return RouterOutputType.fromValue(outputType);
    }

    /**
     * <p>
     * The type of the router output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputType} will
     * return {@link RouterOutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputTypeAsString}.
     * </p>
     * 
     * @return The type of the router output.
     * @see RouterOutputType
     */
    public final String outputTypeAsString() {
        return outputType;
    }

    /**
     * <p>
     * The overall state of the router output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouterOutputState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The overall state of the router output.
     * @see RouterOutputState
     */
    public final RouterOutputState state() {
        return RouterOutputState.fromValue(state);
    }

    /**
     * <p>
     * The overall state of the router output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouterOutputState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The overall state of the router output.
     * @see RouterOutputState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The current state of the association between the router output and its input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routedState} will
     * return {@link RouterOutputRoutedState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #routedStateAsString}.
     * </p>
     * 
     * @return The current state of the association between the router output and its input.
     * @see RouterOutputRoutedState
     */
    public final RouterOutputRoutedState routedState() {
        return RouterOutputRoutedState.fromValue(routedState);
    }

    /**
     * <p>
     * The current state of the association between the router output and its input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routedState} will
     * return {@link RouterOutputRoutedState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #routedStateAsString}.
     * </p>
     * 
     * @return The current state of the association between the router output and its input.
     * @see RouterOutputRoutedState
     */
    public final String routedStateAsString() {
        return routedState;
    }

    /**
     * <p>
     * The AWS Region where the router output is located.
     * </p>
     * 
     * @return The AWS Region where the router output is located.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The Availability Zone of the router output.
     * </p>
     * 
     * @return The Availability Zone of the router output.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The maximum bitrate of the router output.
     * </p>
     * 
     * @return The maximum bitrate of the router output.
     */
    public final Long maximumBitrate() {
        return maximumBitrate;
    }

    /**
     * <p>
     * Indicates whether the router output is configured for Regional or global routing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routingScope} will
     * return {@link RoutingScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routingScopeAsString}.
     * </p>
     * 
     * @return Indicates whether the router output is configured for Regional or global routing.
     * @see RoutingScope
     */
    public final RoutingScope routingScope() {
        return RoutingScope.fromValue(routingScope);
    }

    /**
     * <p>
     * Indicates whether the router output is configured for Regional or global routing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routingScope} will
     * return {@link RoutingScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routingScopeAsString}.
     * </p>
     * 
     * @return Indicates whether the router output is configured for Regional or global routing.
     * @see RoutingScope
     */
    public final String routingScopeAsString() {
        return routingScope;
    }

    /**
     * <p>
     * The timestamp when the router output was created.
     * </p>
     * 
     * @return The timestamp when the router output was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the router output was last updated.
     * </p>
     * 
     * @return The timestamp when the router output was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The number of messages associated with the router output.
     * </p>
     * 
     * @return The number of messages associated with the router output.
     */
    public final Integer messageCount() {
        return messageCount;
    }

    /**
     * <p>
     * The ARN of the router input associated with the output.
     * </p>
     * 
     * @return The ARN of the router input associated with the output.
     */
    public final String routedInputArn() {
        return routedInputArn;
    }

    /**
     * <p>
     * The ARN of the network interface associated with the router output.
     * </p>
     * 
     * @return The ARN of the network interface associated with the router output.
     */
    public final String networkInterfaceArn() {
        return networkInterfaceArn;
    }

    /**
     * <p>
     * The type of maintenance schedule currently associated with the listed router output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maintenanceScheduleType} will return {@link MaintenanceScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maintenanceScheduleTypeAsString}.
     * </p>
     * 
     * @return The type of maintenance schedule currently associated with the listed router output.
     * @see MaintenanceScheduleType
     */
    public final MaintenanceScheduleType maintenanceScheduleType() {
        return MaintenanceScheduleType.fromValue(maintenanceScheduleType);
    }

    /**
     * <p>
     * The type of maintenance schedule currently associated with the listed router output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maintenanceScheduleType} will return {@link MaintenanceScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #maintenanceScheduleTypeAsString}.
     * </p>
     * 
     * @return The type of maintenance schedule currently associated with the listed router output.
     * @see MaintenanceScheduleType
     */
    public final String maintenanceScheduleTypeAsString() {
        return maintenanceScheduleType;
    }

    /**
     * <p>
     * The details of the maintenance schedule for the listed router output.
     * </p>
     * 
     * @return The details of the maintenance schedule for the listed router output.
     */
    public final MaintenanceSchedule maintenanceSchedule() {
        return maintenanceSchedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(outputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(routedStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(routingScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(messageCount());
        hashCode = 31 * hashCode + Objects.hashCode(routedInputArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceScheduleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceSchedule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedRouterOutput)) {
            return false;
        }
        ListedRouterOutput other = (ListedRouterOutput) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(outputTypeAsString(), other.outputTypeAsString())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(routedStateAsString(), other.routedStateAsString())
                && Objects.equals(regionName(), other.regionName())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(maximumBitrate(), other.maximumBitrate())
                && Objects.equals(routingScopeAsString(), other.routingScopeAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(messageCount(), other.messageCount())
                && Objects.equals(routedInputArn(), other.routedInputArn())
                && Objects.equals(networkInterfaceArn(), other.networkInterfaceArn())
                && Objects.equals(maintenanceScheduleTypeAsString(), other.maintenanceScheduleTypeAsString())
                && Objects.equals(maintenanceSchedule(), other.maintenanceSchedule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListedRouterOutput").add("Name", name()).add("Arn", arn()).add("Id", id())
                .add("OutputType", outputTypeAsString()).add("State", stateAsString()).add("RoutedState", routedStateAsString())
                .add("RegionName", regionName()).add("AvailabilityZone", availabilityZone())
                .add("MaximumBitrate", maximumBitrate()).add("RoutingScope", routingScopeAsString())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("MessageCount", messageCount())
                .add("RoutedInputArn", routedInputArn()).add("NetworkInterfaceArn", networkInterfaceArn())
                .add("MaintenanceScheduleType", maintenanceScheduleTypeAsString())
                .add("MaintenanceSchedule", maintenanceSchedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "OutputType":
            return Optional.ofNullable(clazz.cast(outputTypeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "RoutedState":
            return Optional.ofNullable(clazz.cast(routedStateAsString()));
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "MaximumBitrate":
            return Optional.ofNullable(clazz.cast(maximumBitrate()));
        case "RoutingScope":
            return Optional.ofNullable(clazz.cast(routingScopeAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "MessageCount":
            return Optional.ofNullable(clazz.cast(messageCount()));
        case "RoutedInputArn":
            return Optional.ofNullable(clazz.cast(routedInputArn()));
        case "NetworkInterfaceArn":
            return Optional.ofNullable(clazz.cast(networkInterfaceArn()));
        case "MaintenanceScheduleType":
            return Optional.ofNullable(clazz.cast(maintenanceScheduleTypeAsString()));
        case "MaintenanceSchedule":
            return Optional.ofNullable(clazz.cast(maintenanceSchedule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("outputType", OUTPUT_TYPE_FIELD);
        map.put("state", STATE_FIELD);
        map.put("routedState", ROUTED_STATE_FIELD);
        map.put("regionName", REGION_NAME_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("maximumBitrate", MAXIMUM_BITRATE_FIELD);
        map.put("routingScope", ROUTING_SCOPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("messageCount", MESSAGE_COUNT_FIELD);
        map.put("routedInputArn", ROUTED_INPUT_ARN_FIELD);
        map.put("networkInterfaceArn", NETWORK_INTERFACE_ARN_FIELD);
        map.put("maintenanceScheduleType", MAINTENANCE_SCHEDULE_TYPE_FIELD);
        map.put("maintenanceSchedule", MAINTENANCE_SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListedRouterOutput, T> g) {
        return obj -> g.apply((ListedRouterOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedRouterOutput> {
        /**
         * <p>
         * The name of the router output.
         * </p>
         * 
         * @param name
         *        The name of the router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the router output.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier of the router output.
         * </p>
         * 
         * @param id
         *        The unique identifier of the router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the router output.
         * </p>
         * 
         * @param outputType
         *        The type of the router output.
         * @see RouterOutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterOutputType
         */
        Builder outputType(String outputType);

        /**
         * <p>
         * The type of the router output.
         * </p>
         * 
         * @param outputType
         *        The type of the router output.
         * @see RouterOutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterOutputType
         */
        Builder outputType(RouterOutputType outputType);

        /**
         * <p>
         * The overall state of the router output.
         * </p>
         * 
         * @param state
         *        The overall state of the router output.
         * @see RouterOutputState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterOutputState
         */
        Builder state(String state);

        /**
         * <p>
         * The overall state of the router output.
         * </p>
         * 
         * @param state
         *        The overall state of the router output.
         * @see RouterOutputState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterOutputState
         */
        Builder state(RouterOutputState state);

        /**
         * <p>
         * The current state of the association between the router output and its input.
         * </p>
         * 
         * @param routedState
         *        The current state of the association between the router output and its input.
         * @see RouterOutputRoutedState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterOutputRoutedState
         */
        Builder routedState(String routedState);

        /**
         * <p>
         * The current state of the association between the router output and its input.
         * </p>
         * 
         * @param routedState
         *        The current state of the association between the router output and its input.
         * @see RouterOutputRoutedState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterOutputRoutedState
         */
        Builder routedState(RouterOutputRoutedState routedState);

        /**
         * <p>
         * The AWS Region where the router output is located.
         * </p>
         * 
         * @param regionName
         *        The AWS Region where the router output is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The Availability Zone of the router output.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The maximum bitrate of the router output.
         * </p>
         * 
         * @param maximumBitrate
         *        The maximum bitrate of the router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBitrate(Long maximumBitrate);

        /**
         * <p>
         * Indicates whether the router output is configured for Regional or global routing.
         * </p>
         * 
         * @param routingScope
         *        Indicates whether the router output is configured for Regional or global routing.
         * @see RoutingScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingScope
         */
        Builder routingScope(String routingScope);

        /**
         * <p>
         * Indicates whether the router output is configured for Regional or global routing.
         * </p>
         * 
         * @param routingScope
         *        Indicates whether the router output is configured for Regional or global routing.
         * @see RoutingScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingScope
         */
        Builder routingScope(RoutingScope routingScope);

        /**
         * <p>
         * The timestamp when the router output was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the router output was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the router output was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the router output was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The number of messages associated with the router output.
         * </p>
         * 
         * @param messageCount
         *        The number of messages associated with the router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageCount(Integer messageCount);

        /**
         * <p>
         * The ARN of the router input associated with the output.
         * </p>
         * 
         * @param routedInputArn
         *        The ARN of the router input associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routedInputArn(String routedInputArn);

        /**
         * <p>
         * The ARN of the network interface associated with the router output.
         * </p>
         * 
         * @param networkInterfaceArn
         *        The ARN of the network interface associated with the router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceArn(String networkInterfaceArn);

        /**
         * <p>
         * The type of maintenance schedule currently associated with the listed router output.
         * </p>
         * 
         * @param maintenanceScheduleType
         *        The type of maintenance schedule currently associated with the listed router output.
         * @see MaintenanceScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceScheduleType
         */
        Builder maintenanceScheduleType(String maintenanceScheduleType);

        /**
         * <p>
         * The type of maintenance schedule currently associated with the listed router output.
         * </p>
         * 
         * @param maintenanceScheduleType
         *        The type of maintenance schedule currently associated with the listed router output.
         * @see MaintenanceScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceScheduleType
         */
        Builder maintenanceScheduleType(MaintenanceScheduleType maintenanceScheduleType);

        /**
         * <p>
         * The details of the maintenance schedule for the listed router output.
         * </p>
         * 
         * @param maintenanceSchedule
         *        The details of the maintenance schedule for the listed router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceSchedule(MaintenanceSchedule maintenanceSchedule);

        /**
         * <p>
         * The details of the maintenance schedule for the listed router output.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaintenanceSchedule.Builder} avoiding the
         * need to create one manually via {@link MaintenanceSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceSchedule.Builder#build()} is called immediately and
         * its result is passed to {@link #maintenanceSchedule(MaintenanceSchedule)}.
         * 
         * @param maintenanceSchedule
         *        a consumer that will call methods on {@link MaintenanceSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceSchedule(MaintenanceSchedule)
         */
        default Builder maintenanceSchedule(Consumer<MaintenanceSchedule.Builder> maintenanceSchedule) {
            return maintenanceSchedule(MaintenanceSchedule.builder().applyMutation(maintenanceSchedule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String id;

        private String outputType;

        private String state;

        private String routedState;

        private String regionName;

        private String availabilityZone;

        private Long maximumBitrate;

        private String routingScope;

        private Instant createdAt;

        private Instant updatedAt;

        private Integer messageCount;

        private String routedInputArn;

        private String networkInterfaceArn;

        private String maintenanceScheduleType;

        private MaintenanceSchedule maintenanceSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedRouterOutput model) {
            name(model.name);
            arn(model.arn);
            id(model.id);
            outputType(model.outputType);
            state(model.state);
            routedState(model.routedState);
            regionName(model.regionName);
            availabilityZone(model.availabilityZone);
            maximumBitrate(model.maximumBitrate);
            routingScope(model.routingScope);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            messageCount(model.messageCount);
            routedInputArn(model.routedInputArn);
            networkInterfaceArn(model.networkInterfaceArn);
            maintenanceScheduleType(model.maintenanceScheduleType);
            maintenanceSchedule(model.maintenanceSchedule);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOutputType() {
            return outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        @Override
        public final Builder outputType(RouterOutputType outputType) {
            this.outputType(outputType == null ? null : outputType.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouterOutputState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getRoutedState() {
            return routedState;
        }

        public final void setRoutedState(String routedState) {
            this.routedState = routedState;
        }

        @Override
        public final Builder routedState(String routedState) {
            this.routedState = routedState;
            return this;
        }

        @Override
        public final Builder routedState(RouterOutputRoutedState routedState) {
            this.routedState(routedState == null ? null : routedState.toString());
            return this;
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Long getMaximumBitrate() {
            return maximumBitrate;
        }

        public final void setMaximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        public final String getRoutingScope() {
            return routingScope;
        }

        public final void setRoutingScope(String routingScope) {
            this.routingScope = routingScope;
        }

        @Override
        public final Builder routingScope(String routingScope) {
            this.routingScope = routingScope;
            return this;
        }

        @Override
        public final Builder routingScope(RoutingScope routingScope) {
            this.routingScope(routingScope == null ? null : routingScope.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Integer getMessageCount() {
            return messageCount;
        }

        public final void setMessageCount(Integer messageCount) {
            this.messageCount = messageCount;
        }

        @Override
        public final Builder messageCount(Integer messageCount) {
            this.messageCount = messageCount;
            return this;
        }

        public final String getRoutedInputArn() {
            return routedInputArn;
        }

        public final void setRoutedInputArn(String routedInputArn) {
            this.routedInputArn = routedInputArn;
        }

        @Override
        public final Builder routedInputArn(String routedInputArn) {
            this.routedInputArn = routedInputArn;
            return this;
        }

        public final String getNetworkInterfaceArn() {
            return networkInterfaceArn;
        }

        public final void setNetworkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
        }

        @Override
        public final Builder networkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
            return this;
        }

        public final String getMaintenanceScheduleType() {
            return maintenanceScheduleType;
        }

        public final void setMaintenanceScheduleType(String maintenanceScheduleType) {
            this.maintenanceScheduleType = maintenanceScheduleType;
        }

        @Override
        public final Builder maintenanceScheduleType(String maintenanceScheduleType) {
            this.maintenanceScheduleType = maintenanceScheduleType;
            return this;
        }

        @Override
        public final Builder maintenanceScheduleType(MaintenanceScheduleType maintenanceScheduleType) {
            this.maintenanceScheduleType(maintenanceScheduleType == null ? null : maintenanceScheduleType.toString());
            return this;
        }

        public final MaintenanceSchedule.Builder getMaintenanceSchedule() {
            return maintenanceSchedule != null ? maintenanceSchedule.toBuilder() : null;
        }

        public final void setMaintenanceSchedule(MaintenanceSchedule.BuilderImpl maintenanceSchedule) {
            this.maintenanceSchedule = maintenanceSchedule != null ? maintenanceSchedule.build() : null;
        }

        @Override
        public final Builder maintenanceSchedule(MaintenanceSchedule maintenanceSchedule) {
            this.maintenanceSchedule = maintenanceSchedule;
            return this;
        }

        @Override
        public ListedRouterOutput build() {
            return new ListedRouterOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
