/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRouterOutputResponse extends MediaConnectResponse implements
        ToCopyableBuilder<GetRouterOutputResponse.Builder, GetRouterOutputResponse> {
    private static final SdkField<RouterOutput> ROUTER_OUTPUT_FIELD = SdkField.<RouterOutput> builder(MarshallingType.SDK_POJO)
            .memberName("RouterOutput").getter(getter(GetRouterOutputResponse::routerOutput))
            .setter(setter(Builder::routerOutput)).constructor(RouterOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTER_OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RouterOutput routerOutput;

    private GetRouterOutputResponse(BuilderImpl builder) {
        super(builder);
        this.routerOutput = builder.routerOutput;
    }

    /**
     * <p>
     * The details of the requested router output, including its configuration, state, and other attributes.
     * </p>
     * 
     * @return The details of the requested router output, including its configuration, state, and other attributes.
     */
    public final RouterOutput routerOutput() {
        return routerOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routerOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRouterOutputResponse)) {
            return false;
        }
        GetRouterOutputResponse other = (GetRouterOutputResponse) obj;
        return Objects.equals(routerOutput(), other.routerOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRouterOutputResponse").add("RouterOutput", routerOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouterOutput":
            return Optional.ofNullable(clazz.cast(routerOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("routerOutput", ROUTER_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRouterOutputResponse, T> g) {
        return obj -> g.apply((GetRouterOutputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRouterOutputResponse> {
        /**
         * <p>
         * The details of the requested router output, including its configuration, state, and other attributes.
         * </p>
         * 
         * @param routerOutput
         *        The details of the requested router output, including its configuration, state, and other attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routerOutput(RouterOutput routerOutput);

        /**
         * <p>
         * The details of the requested router output, including its configuration, state, and other attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouterOutput.Builder} avoiding the need
         * to create one manually via {@link RouterOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouterOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #routerOutput(RouterOutput)}.
         * 
         * @param routerOutput
         *        a consumer that will call methods on {@link RouterOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routerOutput(RouterOutput)
         */
        default Builder routerOutput(Consumer<RouterOutput.Builder> routerOutput) {
            return routerOutput(RouterOutput.builder().applyMutation(routerOutput).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private RouterOutput routerOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRouterOutputResponse model) {
            super(model);
            routerOutput(model.routerOutput);
        }

        public final RouterOutput.Builder getRouterOutput() {
            return routerOutput != null ? routerOutput.toBuilder() : null;
        }

        public final void setRouterOutput(RouterOutput.BuilderImpl routerOutput) {
            this.routerOutput = routerOutput != null ? routerOutput.build() : null;
        }

        @Override
        public final Builder routerOutput(RouterOutput routerOutput) {
            this.routerOutput = routerOutput;
            return this;
        }

        @Override
        public GetRouterOutputResponse build() {
            return new GetRouterOutputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
