/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRouterNetworkInterfaceResponse extends MediaConnectResponse implements
        ToCopyableBuilder<GetRouterNetworkInterfaceResponse.Builder, GetRouterNetworkInterfaceResponse> {
    private static final SdkField<RouterNetworkInterface> ROUTER_NETWORK_INTERFACE_FIELD = SdkField
            .<RouterNetworkInterface> builder(MarshallingType.SDK_POJO).memberName("RouterNetworkInterface")
            .getter(getter(GetRouterNetworkInterfaceResponse::routerNetworkInterface))
            .setter(setter(Builder::routerNetworkInterface)).constructor(RouterNetworkInterface::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerNetworkInterface").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ROUTER_NETWORK_INTERFACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RouterNetworkInterface routerNetworkInterface;

    private GetRouterNetworkInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.routerNetworkInterface = builder.routerNetworkInterface;
    }

    /**
     * <p>
     * The details of the requested router network interface, including its configuration and other attributes.
     * </p>
     * 
     * @return The details of the requested router network interface, including its configuration and other attributes.
     */
    public final RouterNetworkInterface routerNetworkInterface() {
        return routerNetworkInterface;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routerNetworkInterface());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRouterNetworkInterfaceResponse)) {
            return false;
        }
        GetRouterNetworkInterfaceResponse other = (GetRouterNetworkInterfaceResponse) obj;
        return Objects.equals(routerNetworkInterface(), other.routerNetworkInterface());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRouterNetworkInterfaceResponse").add("RouterNetworkInterface", routerNetworkInterface())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouterNetworkInterface":
            return Optional.ofNullable(clazz.cast(routerNetworkInterface()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("routerNetworkInterface", ROUTER_NETWORK_INTERFACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRouterNetworkInterfaceResponse, T> g) {
        return obj -> g.apply((GetRouterNetworkInterfaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRouterNetworkInterfaceResponse> {
        /**
         * <p>
         * The details of the requested router network interface, including its configuration and other attributes.
         * </p>
         * 
         * @param routerNetworkInterface
         *        The details of the requested router network interface, including its configuration and other
         *        attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routerNetworkInterface(RouterNetworkInterface routerNetworkInterface);

        /**
         * <p>
         * The details of the requested router network interface, including its configuration and other attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouterNetworkInterface.Builder} avoiding
         * the need to create one manually via {@link RouterNetworkInterface#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouterNetworkInterface.Builder#build()} is called immediately and
         * its result is passed to {@link #routerNetworkInterface(RouterNetworkInterface)}.
         * 
         * @param routerNetworkInterface
         *        a consumer that will call methods on {@link RouterNetworkInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routerNetworkInterface(RouterNetworkInterface)
         */
        default Builder routerNetworkInterface(Consumer<RouterNetworkInterface.Builder> routerNetworkInterface) {
            return routerNetworkInterface(RouterNetworkInterface.builder().applyMutation(routerNetworkInterface).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private RouterNetworkInterface routerNetworkInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRouterNetworkInterfaceResponse model) {
            super(model);
            routerNetworkInterface(model.routerNetworkInterface);
        }

        public final RouterNetworkInterface.Builder getRouterNetworkInterface() {
            return routerNetworkInterface != null ? routerNetworkInterface.toBuilder() : null;
        }

        public final void setRouterNetworkInterface(RouterNetworkInterface.BuilderImpl routerNetworkInterface) {
            this.routerNetworkInterface = routerNetworkInterface != null ? routerNetworkInterface.build() : null;
        }

        @Override
        public final Builder routerNetworkInterface(RouterNetworkInterface routerNetworkInterface) {
            this.routerNetworkInterface = routerNetworkInterface;
            return this;
        }

        @Override
        public GetRouterNetworkInterfaceResponse build() {
            return new GetRouterNetworkInterfaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
