/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for a flow, including its source, outputs, and entitlements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Flow implements SdkPojo, Serializable, ToCopyableBuilder<Flow.Builder, Flow> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(Flow::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Flow::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> EGRESS_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EgressIp").getter(getter(Flow::egressIp)).setter(setter(Builder::egressIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressIp").build()).build();

    private static final SdkField<List<Entitlement>> ENTITLEMENTS_FIELD = SdkField
            .<List<Entitlement>> builder(MarshallingType.LIST)
            .memberName("Entitlements")
            .getter(getter(Flow::entitlements))
            .setter(setter(Builder::entitlements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entitlement> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entitlement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(Flow::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<List<MediaStream>> MEDIA_STREAMS_FIELD = SdkField
            .<List<MediaStream>> builder(MarshallingType.LIST)
            .memberName("MediaStreams")
            .getter(getter(Flow::mediaStreams))
            .setter(setter(Builder::mediaStreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaStream> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaStream::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Flow::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField
            .<List<Output>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(Flow::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Output> builder(MarshallingType.SDK_POJO)
                                            .constructor(Output::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(Flow::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<FailoverConfig> SOURCE_FAILOVER_CONFIG_FIELD = SdkField
            .<FailoverConfig> builder(MarshallingType.SDK_POJO).memberName("SourceFailoverConfig")
            .getter(getter(Flow::sourceFailoverConfig)).setter(setter(Builder::sourceFailoverConfig))
            .constructor(FailoverConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFailoverConfig").build())
            .build();

    private static final SdkField<List<Source>> SOURCES_FIELD = SdkField
            .<List<Source>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(Flow::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Source> builder(MarshallingType.SDK_POJO)
                                            .constructor(Source::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Flow::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<VpcInterface>> VPC_INTERFACES_FIELD = SdkField
            .<List<VpcInterface>> builder(MarshallingType.LIST)
            .memberName("VpcInterfaces")
            .getter(getter(Flow::vpcInterfaces))
            .setter(setter(Builder::vpcInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Maintenance> MAINTENANCE_FIELD = SdkField.<Maintenance> builder(MarshallingType.SDK_POJO)
            .memberName("Maintenance").getter(getter(Flow::maintenance)).setter(setter(Builder::maintenance))
            .constructor(Maintenance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenance").build()).build();

    private static final SdkField<MonitoringConfig> SOURCE_MONITORING_CONFIG_FIELD = SdkField
            .<MonitoringConfig> builder(MarshallingType.SDK_POJO).memberName("SourceMonitoringConfig")
            .getter(getter(Flow::sourceMonitoringConfig)).setter(setter(Builder::sourceMonitoringConfig))
            .constructor(MonitoringConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceMonitoringConfig").build())
            .build();

    private static final SdkField<String> FLOW_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowSize").getter(getter(Flow::flowSizeAsString)).setter(setter(Builder::flowSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowSize").build()).build();

    private static final SdkField<NdiConfig> NDI_CONFIG_FIELD = SdkField.<NdiConfig> builder(MarshallingType.SDK_POJO)
            .memberName("NdiConfig").getter(getter(Flow::ndiConfig)).setter(setter(Builder::ndiConfig))
            .constructor(NdiConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ndiConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            DESCRIPTION_FIELD, EGRESS_IP_FIELD, ENTITLEMENTS_FIELD, FLOW_ARN_FIELD, MEDIA_STREAMS_FIELD, NAME_FIELD,
            OUTPUTS_FIELD, SOURCE_FIELD, SOURCE_FAILOVER_CONFIG_FIELD, SOURCES_FIELD, STATUS_FIELD, VPC_INTERFACES_FIELD,
            MAINTENANCE_FIELD, SOURCE_MONITORING_CONFIG_FIELD, FLOW_SIZE_FIELD, NDI_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String description;

    private final String egressIp;

    private final List<Entitlement> entitlements;

    private final String flowArn;

    private final List<MediaStream> mediaStreams;

    private final String name;

    private final List<Output> outputs;

    private final Source source;

    private final FailoverConfig sourceFailoverConfig;

    private final List<Source> sources;

    private final String status;

    private final List<VpcInterface> vpcInterfaces;

    private final Maintenance maintenance;

    private final MonitoringConfig sourceMonitoringConfig;

    private final String flowSize;

    private final NdiConfig ndiConfig;

    private Flow(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.egressIp = builder.egressIp;
        this.entitlements = builder.entitlements;
        this.flowArn = builder.flowArn;
        this.mediaStreams = builder.mediaStreams;
        this.name = builder.name;
        this.outputs = builder.outputs;
        this.source = builder.source;
        this.sourceFailoverConfig = builder.sourceFailoverConfig;
        this.sources = builder.sources;
        this.status = builder.status;
        this.vpcInterfaces = builder.vpcInterfaces;
        this.maintenance = builder.maintenance;
        this.sourceMonitoringConfig = builder.sourceMonitoringConfig;
        this.flowSize = builder.flowSize;
        this.ndiConfig = builder.ndiConfig;
    }

    /**
     * <p>
     * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones
     * within the current Amazon Web Services Region.
     * </p>
     * 
     * @return The Availability Zone that you want to create the flow in. These options are limited to the Availability
     *         Zones within the current Amazon Web Services Region.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * A description of the flow. This value is not used or seen outside of the current MediaConnect account.
     * </p>
     * 
     * @return A description of the flow. This value is not used or seen outside of the current MediaConnect account.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The IP address from which video will be sent to output destinations.
     * </p>
     * 
     * @return The IP address from which video will be sent to output destinations.
     */
    public final String egressIp() {
        return egressIp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entitlements property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntitlements() {
        return entitlements != null && !(entitlements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The entitlements in this flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntitlements} method.
     * </p>
     * 
     * @return The entitlements in this flow.
     */
    public final List<Entitlement> entitlements() {
        return entitlements;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaStreams property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMediaStreams() {
        return mediaStreams != null && !(mediaStreams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The media streams that are associated with the flow. After you associate a media stream with a source, you can
     * also associate it with outputs on the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaStreams} method.
     * </p>
     * 
     * @return The media streams that are associated with the flow. After you associate a media stream with a source,
     *         you can also associate it with outputs on the flow.
     */
    public final List<MediaStream> mediaStreams() {
        return mediaStreams;
    }

    /**
     * <p>
     * The name of the flow.
     * </p>
     * 
     * @return The name of the flow.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outputs in this flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The outputs in this flow.
     */
    public final List<Output> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The source for the flow.
     * </p>
     * 
     * @return The source for the flow.
     */
    public final Source source() {
        return source;
    }

    /**
     * <p>
     * The settings for the source failover.
     * </p>
     * 
     * @return The settings for the source failover.
     */
    public final FailoverConfig sourceFailoverConfig() {
        return sourceFailoverConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The settings for the sources that are assigned to the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The settings for the sources that are assigned to the flow.
     */
    public final List<Source> sources() {
        return sources;
    }

    /**
     * <p>
     * The current status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The current status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcInterfaces property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcInterfaces() {
        return vpcInterfaces != null && !(vpcInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC Interfaces for this flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcInterfaces} method.
     * </p>
     * 
     * @return The VPC Interfaces for this flow.
     */
    public final List<VpcInterface> vpcInterfaces() {
        return vpcInterfaces;
    }

    /**
     * <p>
     * The maintenance settings for the flow.
     * </p>
     * 
     * @return The maintenance settings for the flow.
     */
    public final Maintenance maintenance() {
        return maintenance;
    }

    /**
     * <p>
     * The settings for source monitoring.
     * </p>
     * 
     * @return The settings for source monitoring.
     */
    public final MonitoringConfig sourceMonitoringConfig() {
        return sourceMonitoringConfig;
    }

    /**
     * <p>
     * Determines the processing capacity and feature set of the flow. Set this optional parameter to LARGE if you want
     * to enable NDI outputs on the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flowSize} will
     * return {@link FlowSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flowSizeAsString}.
     * </p>
     * 
     * @return Determines the processing capacity and feature set of the flow. Set this optional parameter to LARGE if
     *         you want to enable NDI outputs on the flow.
     * @see FlowSize
     */
    public final FlowSize flowSize() {
        return FlowSize.fromValue(flowSize);
    }

    /**
     * <p>
     * Determines the processing capacity and feature set of the flow. Set this optional parameter to LARGE if you want
     * to enable NDI outputs on the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flowSize} will
     * return {@link FlowSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flowSizeAsString}.
     * </p>
     * 
     * @return Determines the processing capacity and feature set of the flow. Set this optional parameter to LARGE if
     *         you want to enable NDI outputs on the flow.
     * @see FlowSize
     */
    public final String flowSizeAsString() {
        return flowSize;
    }

    /**
     * <p>
     * Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
     * </p>
     * 
     * @return Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
     */
    public final NdiConfig ndiConfig() {
        return ndiConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(egressIp());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitlements() ? entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaStreams() ? mediaStreams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFailoverConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcInterfaces() ? vpcInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maintenance());
        hashCode = 31 * hashCode + Objects.hashCode(sourceMonitoringConfig());
        hashCode = 31 * hashCode + Objects.hashCode(flowSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ndiConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Flow)) {
            return false;
        }
        Flow other = (Flow) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(description(), other.description())
                && Objects.equals(egressIp(), other.egressIp()) && hasEntitlements() == other.hasEntitlements()
                && Objects.equals(entitlements(), other.entitlements()) && Objects.equals(flowArn(), other.flowArn())
                && hasMediaStreams() == other.hasMediaStreams() && Objects.equals(mediaStreams(), other.mediaStreams())
                && Objects.equals(name(), other.name()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs()) && Objects.equals(source(), other.source())
                && Objects.equals(sourceFailoverConfig(), other.sourceFailoverConfig()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasVpcInterfaces() == other.hasVpcInterfaces() && Objects.equals(vpcInterfaces(), other.vpcInterfaces())
                && Objects.equals(maintenance(), other.maintenance())
                && Objects.equals(sourceMonitoringConfig(), other.sourceMonitoringConfig())
                && Objects.equals(flowSizeAsString(), other.flowSizeAsString()) && Objects.equals(ndiConfig(), other.ndiConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Flow").add("AvailabilityZone", availabilityZone()).add("Description", description())
                .add("EgressIp", egressIp()).add("Entitlements", hasEntitlements() ? entitlements() : null)
                .add("FlowArn", flowArn()).add("MediaStreams", hasMediaStreams() ? mediaStreams() : null).add("Name", name())
                .add("Outputs", hasOutputs() ? outputs() : null).add("Source", source())
                .add("SourceFailoverConfig", sourceFailoverConfig()).add("Sources", hasSources() ? sources() : null)
                .add("Status", statusAsString()).add("VpcInterfaces", hasVpcInterfaces() ? vpcInterfaces() : null)
                .add("Maintenance", maintenance()).add("SourceMonitoringConfig", sourceMonitoringConfig())
                .add("FlowSize", flowSizeAsString()).add("NdiConfig", ndiConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EgressIp":
            return Optional.ofNullable(clazz.cast(egressIp()));
        case "Entitlements":
            return Optional.ofNullable(clazz.cast(entitlements()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "MediaStreams":
            return Optional.ofNullable(clazz.cast(mediaStreams()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "SourceFailoverConfig":
            return Optional.ofNullable(clazz.cast(sourceFailoverConfig()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "VpcInterfaces":
            return Optional.ofNullable(clazz.cast(vpcInterfaces()));
        case "Maintenance":
            return Optional.ofNullable(clazz.cast(maintenance()));
        case "SourceMonitoringConfig":
            return Optional.ofNullable(clazz.cast(sourceMonitoringConfig()));
        case "FlowSize":
            return Optional.ofNullable(clazz.cast(flowSizeAsString()));
        case "NdiConfig":
            return Optional.ofNullable(clazz.cast(ndiConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("egressIp", EGRESS_IP_FIELD);
        map.put("entitlements", ENTITLEMENTS_FIELD);
        map.put("flowArn", FLOW_ARN_FIELD);
        map.put("mediaStreams", MEDIA_STREAMS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("outputs", OUTPUTS_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("sourceFailoverConfig", SOURCE_FAILOVER_CONFIG_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("vpcInterfaces", VPC_INTERFACES_FIELD);
        map.put("maintenance", MAINTENANCE_FIELD);
        map.put("sourceMonitoringConfig", SOURCE_MONITORING_CONFIG_FIELD);
        map.put("flowSize", FLOW_SIZE_FIELD);
        map.put("ndiConfig", NDI_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Flow, T> g) {
        return obj -> g.apply((Flow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Flow> {
        /**
         * <p>
         * The Availability Zone that you want to create the flow in. These options are limited to the Availability
         * Zones within the current Amazon Web Services Region.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone that you want to create the flow in. These options are limited to the
         *        Availability Zones within the current Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * A description of the flow. This value is not used or seen outside of the current MediaConnect account.
         * </p>
         * 
         * @param description
         *        A description of the flow. This value is not used or seen outside of the current MediaConnect account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The IP address from which video will be sent to output destinations.
         * </p>
         * 
         * @param egressIp
         *        The IP address from which video will be sent to output destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressIp(String egressIp);

        /**
         * <p>
         * The entitlements in this flow.
         * </p>
         * 
         * @param entitlements
         *        The entitlements in this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Collection<Entitlement> entitlements);

        /**
         * <p>
         * The entitlements in this flow.
         * </p>
         * 
         * @param entitlements
         *        The entitlements in this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Entitlement... entitlements);

        /**
         * <p>
         * The entitlements in this flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.Entitlement.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediaconnect.model.Entitlement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.Entitlement.Builder#build()} is called immediately
         * and its result is passed to {@link #entitlements(List<Entitlement>)}.
         * 
         * @param entitlements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.Entitlement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlements(java.util.Collection<Entitlement>)
         */
        Builder entitlements(Consumer<Entitlement.Builder>... entitlements);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow.
         * </p>
         * 
         * @param flowArn
         *        The Amazon Resource Name (ARN) of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * <p>
         * The media streams that are associated with the flow. After you associate a media stream with a source, you
         * can also associate it with outputs on the flow.
         * </p>
         * 
         * @param mediaStreams
         *        The media streams that are associated with the flow. After you associate a media stream with a source,
         *        you can also associate it with outputs on the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreams(Collection<MediaStream> mediaStreams);

        /**
         * <p>
         * The media streams that are associated with the flow. After you associate a media stream with a source, you
         * can also associate it with outputs on the flow.
         * </p>
         * 
         * @param mediaStreams
         *        The media streams that are associated with the flow. After you associate a media stream with a source,
         *        you can also associate it with outputs on the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreams(MediaStream... mediaStreams);

        /**
         * <p>
         * The media streams that are associated with the flow. After you associate a media stream with a source, you
         * can also associate it with outputs on the flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.MediaStream.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediaconnect.model.MediaStream#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.MediaStream.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaStreams(List<MediaStream>)}.
         * 
         * @param mediaStreams
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.MediaStream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaStreams(java.util.Collection<MediaStream>)
         */
        Builder mediaStreams(Consumer<MediaStream.Builder>... mediaStreams);

        /**
         * <p>
         * The name of the flow.
         * </p>
         * 
         * @param name
         *        The name of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The outputs in this flow.
         * </p>
         * 
         * @param outputs
         *        The outputs in this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * <p>
         * The outputs in this flow.
         * </p>
         * 
         * @param outputs
         *        The outputs in this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * <p>
         * The outputs in this flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.Output.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mediaconnect.model.Output#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.Output.Builder#build()} is called immediately and
         * its result is passed to {@link #outputs(List<Output>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.Output.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<Output>)
         */
        Builder outputs(Consumer<Output.Builder>... outputs);

        /**
         * <p>
         * The source for the flow.
         * </p>
         * 
         * @param source
         *        The source for the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * The source for the flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link Source.Builder} avoiding the need to
         * create one manually via {@link Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The settings for the source failover.
         * </p>
         * 
         * @param sourceFailoverConfig
         *        The settings for the source failover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig);

        /**
         * <p>
         * The settings for the source failover.
         * </p>
         * This is a convenience method that creates an instance of the {@link FailoverConfig.Builder} avoiding the need
         * to create one manually via {@link FailoverConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailoverConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceFailoverConfig(FailoverConfig)}.
         * 
         * @param sourceFailoverConfig
         *        a consumer that will call methods on {@link FailoverConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceFailoverConfig(FailoverConfig)
         */
        default Builder sourceFailoverConfig(Consumer<FailoverConfig.Builder> sourceFailoverConfig) {
            return sourceFailoverConfig(FailoverConfig.builder().applyMutation(sourceFailoverConfig).build());
        }

        /**
         * <p>
         * The settings for the sources that are assigned to the flow.
         * </p>
         * 
         * @param sources
         *        The settings for the sources that are assigned to the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<Source> sources);

        /**
         * <p>
         * The settings for the sources that are assigned to the flow.
         * </p>
         * 
         * @param sources
         *        The settings for the sources that are assigned to the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Source... sources);

        /**
         * <p>
         * The settings for the sources that are assigned to the flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.Source.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mediaconnect.model.Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.Source.Builder#build()} is called immediately and
         * its result is passed to {@link #sources(List<Source>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<Source>)
         */
        Builder sources(Consumer<Source.Builder>... sources);

        /**
         * <p>
         * The current status of the flow.
         * </p>
         * 
         * @param status
         *        The current status of the flow.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the flow.
         * </p>
         * 
         * @param status
         *        The current status of the flow.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The VPC Interfaces for this flow.
         * </p>
         * 
         * @param vpcInterfaces
         *        The VPC Interfaces for this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaces(Collection<VpcInterface> vpcInterfaces);

        /**
         * <p>
         * The VPC Interfaces for this flow.
         * </p>
         * 
         * @param vpcInterfaces
         *        The VPC Interfaces for this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaces(VpcInterface... vpcInterfaces);

        /**
         * <p>
         * The VPC Interfaces for this flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.VpcInterface.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediaconnect.model.VpcInterface#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.VpcInterface.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcInterfaces(List<VpcInterface>)}.
         * 
         * @param vpcInterfaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.VpcInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcInterfaces(java.util.Collection<VpcInterface>)
         */
        Builder vpcInterfaces(Consumer<VpcInterface.Builder>... vpcInterfaces);

        /**
         * <p>
         * The maintenance settings for the flow.
         * </p>
         * 
         * @param maintenance
         *        The maintenance settings for the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenance(Maintenance maintenance);

        /**
         * <p>
         * The maintenance settings for the flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link Maintenance.Builder} avoiding the need to
         * create one manually via {@link Maintenance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Maintenance.Builder#build()} is called immediately and its result
         * is passed to {@link #maintenance(Maintenance)}.
         * 
         * @param maintenance
         *        a consumer that will call methods on {@link Maintenance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenance(Maintenance)
         */
        default Builder maintenance(Consumer<Maintenance.Builder> maintenance) {
            return maintenance(Maintenance.builder().applyMutation(maintenance).build());
        }

        /**
         * <p>
         * The settings for source monitoring.
         * </p>
         * 
         * @param sourceMonitoringConfig
         *        The settings for source monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceMonitoringConfig(MonitoringConfig sourceMonitoringConfig);

        /**
         * <p>
         * The settings for source monitoring.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceMonitoringConfig(MonitoringConfig)}.
         * 
         * @param sourceMonitoringConfig
         *        a consumer that will call methods on {@link MonitoringConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceMonitoringConfig(MonitoringConfig)
         */
        default Builder sourceMonitoringConfig(Consumer<MonitoringConfig.Builder> sourceMonitoringConfig) {
            return sourceMonitoringConfig(MonitoringConfig.builder().applyMutation(sourceMonitoringConfig).build());
        }

        /**
         * <p>
         * Determines the processing capacity and feature set of the flow. Set this optional parameter to LARGE if you
         * want to enable NDI outputs on the flow.
         * </p>
         * 
         * @param flowSize
         *        Determines the processing capacity and feature set of the flow. Set this optional parameter to LARGE
         *        if you want to enable NDI outputs on the flow.
         * @see FlowSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowSize
         */
        Builder flowSize(String flowSize);

        /**
         * <p>
         * Determines the processing capacity and feature set of the flow. Set this optional parameter to LARGE if you
         * want to enable NDI outputs on the flow.
         * </p>
         * 
         * @param flowSize
         *        Determines the processing capacity and feature set of the flow. Set this optional parameter to LARGE
         *        if you want to enable NDI outputs on the flow.
         * @see FlowSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowSize
         */
        Builder flowSize(FlowSize flowSize);

        /**
         * <p>
         * Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
         * </p>
         * 
         * @param ndiConfig
         *        Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ndiConfig(NdiConfig ndiConfig);

        /**
         * <p>
         * Specifies the configuration settings for NDI outputs. Required when the flow includes NDI outputs.
         * </p>
         * This is a convenience method that creates an instance of the {@link NdiConfig.Builder} avoiding the need to
         * create one manually via {@link NdiConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NdiConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #ndiConfig(NdiConfig)}.
         * 
         * @param ndiConfig
         *        a consumer that will call methods on {@link NdiConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ndiConfig(NdiConfig)
         */
        default Builder ndiConfig(Consumer<NdiConfig.Builder> ndiConfig) {
            return ndiConfig(NdiConfig.builder().applyMutation(ndiConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String description;

        private String egressIp;

        private List<Entitlement> entitlements = DefaultSdkAutoConstructList.getInstance();

        private String flowArn;

        private List<MediaStream> mediaStreams = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private Source source;

        private FailoverConfig sourceFailoverConfig;

        private List<Source> sources = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private List<VpcInterface> vpcInterfaces = DefaultSdkAutoConstructList.getInstance();

        private Maintenance maintenance;

        private MonitoringConfig sourceMonitoringConfig;

        private String flowSize;

        private NdiConfig ndiConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Flow model) {
            availabilityZone(model.availabilityZone);
            description(model.description);
            egressIp(model.egressIp);
            entitlements(model.entitlements);
            flowArn(model.flowArn);
            mediaStreams(model.mediaStreams);
            name(model.name);
            outputs(model.outputs);
            source(model.source);
            sourceFailoverConfig(model.sourceFailoverConfig);
            sources(model.sources);
            status(model.status);
            vpcInterfaces(model.vpcInterfaces);
            maintenance(model.maintenance);
            sourceMonitoringConfig(model.sourceMonitoringConfig);
            flowSize(model.flowSize);
            ndiConfig(model.ndiConfig);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEgressIp() {
            return egressIp;
        }

        public final void setEgressIp(String egressIp) {
            this.egressIp = egressIp;
        }

        @Override
        public final Builder egressIp(String egressIp) {
            this.egressIp = egressIp;
            return this;
        }

        public final List<Entitlement.Builder> getEntitlements() {
            List<Entitlement.Builder> result = ___listOfEntitlementCopier.copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlements(Collection<Entitlement.BuilderImpl> entitlements) {
            this.entitlements = ___listOfEntitlementCopier.copyFromBuilder(entitlements);
        }

        @Override
        public final Builder entitlements(Collection<Entitlement> entitlements) {
            this.entitlements = ___listOfEntitlementCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Entitlement... entitlements) {
            entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<Entitlement.Builder>... entitlements) {
            entitlements(Stream.of(entitlements).map(c -> Entitlement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final List<MediaStream.Builder> getMediaStreams() {
            List<MediaStream.Builder> result = ___listOfMediaStreamCopier.copyToBuilder(this.mediaStreams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaStreams(Collection<MediaStream.BuilderImpl> mediaStreams) {
            this.mediaStreams = ___listOfMediaStreamCopier.copyFromBuilder(mediaStreams);
        }

        @Override
        public final Builder mediaStreams(Collection<MediaStream> mediaStreams) {
            this.mediaStreams = ___listOfMediaStreamCopier.copy(mediaStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreams(MediaStream... mediaStreams) {
            mediaStreams(Arrays.asList(mediaStreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreams(Consumer<MediaStream.Builder>... mediaStreams) {
            mediaStreams(Stream.of(mediaStreams).map(c -> MediaStream.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = ___listOfOutputCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = ___listOfOutputCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = ___listOfOutputCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> Output.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final FailoverConfig.Builder getSourceFailoverConfig() {
            return sourceFailoverConfig != null ? sourceFailoverConfig.toBuilder() : null;
        }

        public final void setSourceFailoverConfig(FailoverConfig.BuilderImpl sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig != null ? sourceFailoverConfig.build() : null;
        }

        @Override
        public final Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        public final List<Source.Builder> getSources() {
            List<Source.Builder> result = ___listOfSourceCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<Source.BuilderImpl> sources) {
            this.sources = ___listOfSourceCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<Source> sources) {
            this.sources = ___listOfSourceCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Source... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<Source.Builder>... sources) {
            sources(Stream.of(sources).map(c -> Source.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<VpcInterface.Builder> getVpcInterfaces() {
            List<VpcInterface.Builder> result = ___listOfVpcInterfaceCopier.copyToBuilder(this.vpcInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcInterfaces(Collection<VpcInterface.BuilderImpl> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceCopier.copyFromBuilder(vpcInterfaces);
        }

        @Override
        public final Builder vpcInterfaces(Collection<VpcInterface> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceCopier.copy(vpcInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcInterfaces(VpcInterface... vpcInterfaces) {
            vpcInterfaces(Arrays.asList(vpcInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcInterfaces(Consumer<VpcInterface.Builder>... vpcInterfaces) {
            vpcInterfaces(Stream.of(vpcInterfaces).map(c -> VpcInterface.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Maintenance.Builder getMaintenance() {
            return maintenance != null ? maintenance.toBuilder() : null;
        }

        public final void setMaintenance(Maintenance.BuilderImpl maintenance) {
            this.maintenance = maintenance != null ? maintenance.build() : null;
        }

        @Override
        public final Builder maintenance(Maintenance maintenance) {
            this.maintenance = maintenance;
            return this;
        }

        public final MonitoringConfig.Builder getSourceMonitoringConfig() {
            return sourceMonitoringConfig != null ? sourceMonitoringConfig.toBuilder() : null;
        }

        public final void setSourceMonitoringConfig(MonitoringConfig.BuilderImpl sourceMonitoringConfig) {
            this.sourceMonitoringConfig = sourceMonitoringConfig != null ? sourceMonitoringConfig.build() : null;
        }

        @Override
        public final Builder sourceMonitoringConfig(MonitoringConfig sourceMonitoringConfig) {
            this.sourceMonitoringConfig = sourceMonitoringConfig;
            return this;
        }

        public final String getFlowSize() {
            return flowSize;
        }

        public final void setFlowSize(String flowSize) {
            this.flowSize = flowSize;
        }

        @Override
        public final Builder flowSize(String flowSize) {
            this.flowSize = flowSize;
            return this;
        }

        @Override
        public final Builder flowSize(FlowSize flowSize) {
            this.flowSize(flowSize == null ? null : flowSize.toString());
            return this;
        }

        public final NdiConfig.Builder getNdiConfig() {
            return ndiConfig != null ? ndiConfig.toBuilder() : null;
        }

        public final void setNdiConfig(NdiConfig.BuilderImpl ndiConfig) {
            this.ndiConfig = ndiConfig != null ? ndiConfig.build() : null;
        }

        @Override
        public final Builder ndiConfig(NdiConfig ndiConfig) {
            this.ndiConfig = ndiConfig;
            return this;
        }

        @Override
        public Flow build() {
            return new Flow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
