/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The transport parameters that you want to associate with an outbound media stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationConfiguration.Builder, DestinationConfiguration> {
    private static final SdkField<String> DESTINATION_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationIp").getter(getter(DestinationConfiguration::destinationIp))
            .setter(setter(Builder::destinationIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationIp").build()).build();

    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DestinationPort").getter(getter(DestinationConfiguration::destinationPort))
            .setter(setter(Builder::destinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPort").build()).build();

    private static final SdkField<Interface> INTERFACE_FIELD = SdkField.<Interface> builder(MarshallingType.SDK_POJO)
            .memberName("Interface").getter(getter(DestinationConfiguration::interfaceValue))
            .setter(setter(Builder::interfaceValue)).constructor(Interface::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interface").build()).build();

    private static final SdkField<String> OUTBOUND_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutboundIp").getter(getter(DestinationConfiguration::outboundIp)).setter(setter(Builder::outboundIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outboundIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_IP_FIELD,
            DESTINATION_PORT_FIELD, INTERFACE_FIELD, OUTBOUND_IP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationIp;

    private final Integer destinationPort;

    private final Interface interfaceValue;

    private final String outboundIp;

    private DestinationConfiguration(BuilderImpl builder) {
        this.destinationIp = builder.destinationIp;
        this.destinationPort = builder.destinationPort;
        this.interfaceValue = builder.interfaceValue;
        this.outboundIp = builder.outboundIp;
    }

    /**
     * <p>
     * The IP address where you want MediaConnect to send contents of the media stream.
     * </p>
     * 
     * @return The IP address where you want MediaConnect to send contents of the media stream.
     */
    public final String destinationIp() {
        return destinationIp;
    }

    /**
     * <p>
     * The port that you want MediaConnect to use when it distributes the media stream to the output.
     * </p>
     * 
     * @return The port that you want MediaConnect to use when it distributes the media stream to the output.
     */
    public final Integer destinationPort() {
        return destinationPort;
    }

    /**
     * <p>
     * The VPC interface that you want to use for the media stream associated with the output.
     * </p>
     * 
     * @return The VPC interface that you want to use for the media stream associated with the output.
     */
    public final Interface interfaceValue() {
        return interfaceValue;
    }

    /**
     * <p>
     * The IP address that the receiver requires in order to establish a connection with the flow. This value is
     * represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use
     * the CDI or ST 2110 JPEG XS or protocol.
     * </p>
     * 
     * @return The IP address that the receiver requires in order to establish a connection with the flow. This value is
     *         represented by the elastic network interface IP address of the VPC. This field applies only to outputs
     *         that use the CDI or ST 2110 JPEG XS or protocol.
     */
    public final String outboundIp() {
        return outboundIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationIp());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceValue());
        hashCode = 31 * hashCode + Objects.hashCode(outboundIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConfiguration)) {
            return false;
        }
        DestinationConfiguration other = (DestinationConfiguration) obj;
        return Objects.equals(destinationIp(), other.destinationIp())
                && Objects.equals(destinationPort(), other.destinationPort())
                && Objects.equals(interfaceValue(), other.interfaceValue()) && Objects.equals(outboundIp(), other.outboundIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationConfiguration").add("DestinationIp", destinationIp())
                .add("DestinationPort", destinationPort()).add("Interface", interfaceValue()).add("OutboundIp", outboundIp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationIp":
            return Optional.ofNullable(clazz.cast(destinationIp()));
        case "DestinationPort":
            return Optional.ofNullable(clazz.cast(destinationPort()));
        case "Interface":
            return Optional.ofNullable(clazz.cast(interfaceValue()));
        case "OutboundIp":
            return Optional.ofNullable(clazz.cast(outboundIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationIp", DESTINATION_IP_FIELD);
        map.put("destinationPort", DESTINATION_PORT_FIELD);
        map.put("interface", INTERFACE_FIELD);
        map.put("outboundIp", OUTBOUND_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationConfiguration, T> g) {
        return obj -> g.apply((DestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationConfiguration> {
        /**
         * <p>
         * The IP address where you want MediaConnect to send contents of the media stream.
         * </p>
         * 
         * @param destinationIp
         *        The IP address where you want MediaConnect to send contents of the media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIp(String destinationIp);

        /**
         * <p>
         * The port that you want MediaConnect to use when it distributes the media stream to the output.
         * </p>
         * 
         * @param destinationPort
         *        The port that you want MediaConnect to use when it distributes the media stream to the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPort(Integer destinationPort);

        /**
         * <p>
         * The VPC interface that you want to use for the media stream associated with the output.
         * </p>
         * 
         * @param interfaceValue
         *        The VPC interface that you want to use for the media stream associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceValue(Interface interfaceValue);

        /**
         * <p>
         * The VPC interface that you want to use for the media stream associated with the output.
         * </p>
         * This is a convenience method that creates an instance of the {@link Interface.Builder} avoiding the need to
         * create one manually via {@link Interface#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Interface.Builder#build()} is called immediately and its result
         * is passed to {@link #interfaceValue(Interface)}.
         * 
         * @param interfaceValue
         *        a consumer that will call methods on {@link Interface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interfaceValue(Interface)
         */
        default Builder interfaceValue(Consumer<Interface.Builder> interfaceValue) {
            return interfaceValue(Interface.builder().applyMutation(interfaceValue).build());
        }

        /**
         * <p>
         * The IP address that the receiver requires in order to establish a connection with the flow. This value is
         * represented by the elastic network interface IP address of the VPC. This field applies only to outputs that
         * use the CDI or ST 2110 JPEG XS or protocol.
         * </p>
         * 
         * @param outboundIp
         *        The IP address that the receiver requires in order to establish a connection with the flow. This value
         *        is represented by the elastic network interface IP address of the VPC. This field applies only to
         *        outputs that use the CDI or ST 2110 JPEG XS or protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundIp(String outboundIp);
    }

    static final class BuilderImpl implements Builder {
        private String destinationIp;

        private Integer destinationPort;

        private Interface interfaceValue;

        private String outboundIp;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConfiguration model) {
            destinationIp(model.destinationIp);
            destinationPort(model.destinationPort);
            interfaceValue(model.interfaceValue);
            outboundIp(model.outboundIp);
        }

        public final String getDestinationIp() {
            return destinationIp;
        }

        public final void setDestinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
        }

        @Override
        public final Builder destinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
            return this;
        }

        public final Integer getDestinationPort() {
            return destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final Interface.Builder getInterfaceValue() {
            return interfaceValue != null ? interfaceValue.toBuilder() : null;
        }

        public final void setInterfaceValue(Interface.BuilderImpl interfaceValue) {
            this.interfaceValue = interfaceValue != null ? interfaceValue.build() : null;
        }

        @Override
        public final Builder interfaceValue(Interface interfaceValue) {
            this.interfaceValue = interfaceValue;
            return this;
        }

        public final String getOutboundIp() {
            return outboundIp;
        }

        public final void setOutboundIp(String outboundIp) {
            this.outboundIp = outboundIp;
        }

        @Override
        public final Builder outboundIp(String outboundIp) {
            this.outboundIp = outboundIp;
            return this;
        }

        @Override
        public DestinationConfiguration build() {
            return new DestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
