/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterGatewayInstanceRequest extends MediaConnectRequest implements
        ToCopyableBuilder<DeregisterGatewayInstanceRequest.Builder, DeregisterGatewayInstanceRequest> {
    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Force")
            .getter(getter(DeregisterGatewayInstanceRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("force").build()).build();

    private static final SdkField<String> GATEWAY_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayInstanceArn").getter(getter(DeregisterGatewayInstanceRequest::gatewayInstanceArn))
            .setter(setter(Builder::gatewayInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("GatewayInstanceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORCE_FIELD,
            GATEWAY_INSTANCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean force;

    private final String gatewayInstanceArn;

    private DeregisterGatewayInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.force = builder.force;
        this.gatewayInstanceArn = builder.gatewayInstanceArn;
    }

    /**
     * <p>
     * Force the deregistration of an instance. Force will deregister an instance, even if there are bridges running on
     * it.
     * </p>
     * 
     * @return Force the deregistration of an instance. Force will deregister an instance, even if there are bridges
     *         running on it.
     */
    public final Boolean force() {
        return force;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gateway that contains the instance that you want to deregister.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gateway that contains the instance that you want to deregister.
     */
    public final String gatewayInstanceArn() {
        return gatewayInstanceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(force());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayInstanceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterGatewayInstanceRequest)) {
            return false;
        }
        DeregisterGatewayInstanceRequest other = (DeregisterGatewayInstanceRequest) obj;
        return Objects.equals(force(), other.force()) && Objects.equals(gatewayInstanceArn(), other.gatewayInstanceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregisterGatewayInstanceRequest").add("Force", force())
                .add("GatewayInstanceArn", gatewayInstanceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Force":
            return Optional.ofNullable(clazz.cast(force()));
        case "GatewayInstanceArn":
            return Optional.ofNullable(clazz.cast(gatewayInstanceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("force", FORCE_FIELD);
        map.put("GatewayInstanceArn", GATEWAY_INSTANCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeregisterGatewayInstanceRequest, T> g) {
        return obj -> g.apply((DeregisterGatewayInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeregisterGatewayInstanceRequest> {
        /**
         * <p>
         * Force the deregistration of an instance. Force will deregister an instance, even if there are bridges running
         * on it.
         * </p>
         * 
         * @param force
         *        Force the deregistration of an instance. Force will deregister an instance, even if there are bridges
         *        running on it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gateway that contains the instance that you want to deregister.
         * </p>
         * 
         * @param gatewayInstanceArn
         *        The Amazon Resource Name (ARN) of the gateway that contains the instance that you want to deregister.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayInstanceArn(String gatewayInstanceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private Boolean force;

        private String gatewayInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterGatewayInstanceRequest model) {
            super(model);
            force(model.force);
            gatewayInstanceArn(model.gatewayInstanceArn);
        }

        public final Boolean getForce() {
            return force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final String getGatewayInstanceArn() {
            return gatewayInstanceArn;
        }

        public final void setGatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
        }

        @Override
        public final Builder gatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterGatewayInstanceRequest build() {
            return new DeregisterGatewayInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
