/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRouterOutputRequest extends MediaConnectRequest implements
        ToCopyableBuilder<CreateRouterOutputRequest.Builder, CreateRouterOutputRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateRouterOutputRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<RouterOutputConfiguration> CONFIGURATION_FIELD = SdkField
            .<RouterOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(CreateRouterOutputRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(RouterOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<Long> MAXIMUM_BITRATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaximumBitrate").getter(getter(CreateRouterOutputRequest::maximumBitrate))
            .setter(setter(Builder::maximumBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBitrate").build()).build();

    private static final SdkField<String> ROUTING_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingScope").getter(getter(CreateRouterOutputRequest::routingScopeAsString))
            .setter(setter(Builder::routingScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingScope").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tier")
            .getter(getter(CreateRouterOutputRequest::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()).build();

    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(CreateRouterOutputRequest::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(CreateRouterOutputRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<MaintenanceConfiguration> MAINTENANCE_CONFIGURATION_FIELD = SdkField
            .<MaintenanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("MaintenanceConfiguration")
            .getter(getter(CreateRouterOutputRequest::maintenanceConfiguration))
            .setter(setter(Builder::maintenanceConfiguration)).constructor(MaintenanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateRouterOutputRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateRouterOutputRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CONFIGURATION_FIELD, MAXIMUM_BITRATE_FIELD, ROUTING_SCOPE_FIELD, TIER_FIELD, REGION_NAME_FIELD,
            AVAILABILITY_ZONE_FIELD, MAINTENANCE_CONFIGURATION_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final RouterOutputConfiguration configuration;

    private final Long maximumBitrate;

    private final String routingScope;

    private final String tier;

    private final String regionName;

    private final String availabilityZone;

    private final MaintenanceConfiguration maintenanceConfiguration;

    private final Map<String, String> tags;

    private final String clientToken;

    private CreateRouterOutputRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.maximumBitrate = builder.maximumBitrate;
        this.routingScope = builder.routingScope;
        this.tier = builder.tier;
        this.regionName = builder.regionName;
        this.availabilityZone = builder.availabilityZone;
        this.maintenanceConfiguration = builder.maintenanceConfiguration;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the router output.
     * </p>
     * 
     * @return The name of the router output.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The configuration settings for the router output.
     * </p>
     * 
     * @return The configuration settings for the router output.
     */
    public final RouterOutputConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The maximum bitrate for the router output.
     * </p>
     * 
     * @return The maximum bitrate for the router output.
     */
    public final Long maximumBitrate() {
        return maximumBitrate;
    }

    /**
     * <p>
     * Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default) - can only
     * take inputs from same Region. GLOBAL - can take inputs from any Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routingScope} will
     * return {@link RoutingScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routingScopeAsString}.
     * </p>
     * 
     * @return Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default) -
     *         can only take inputs from same Region. GLOBAL - can take inputs from any Region.
     * @see RoutingScope
     */
    public final RoutingScope routingScope() {
        return RoutingScope.fromValue(routingScope);
    }

    /**
     * <p>
     * Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default) - can only
     * take inputs from same Region. GLOBAL - can take inputs from any Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #routingScope} will
     * return {@link RoutingScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #routingScopeAsString}.
     * </p>
     * 
     * @return Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default) -
     *         can only take inputs from same Region. GLOBAL - can take inputs from any Region.
     * @see RoutingScope
     */
    public final String routingScopeAsString() {
        return routingScope;
    }

    /**
     * <p>
     * The tier level for the router output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link RouterOutputTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier level for the router output.
     * @see RouterOutputTier
     */
    public final RouterOutputTier tier() {
        return RouterOutputTier.fromValue(tier);
    }

    /**
     * <p>
     * The tier level for the router output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link RouterOutputTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier level for the router output.
     * @see RouterOutputTier
     */
    public final String tierAsString() {
        return tier;
    }

    /**
     * <p>
     * The AWS Region for the router output. Defaults to the current region if not specified.
     * </p>
     * 
     * @return The AWS Region for the router output. Defaults to the current region if not specified.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The Availability Zone where you want to create the router output. This must be a valid Availability Zone for the
     * region specified by <code>regionName</code>, or the current region if no <code>regionName</code> is provided.
     * </p>
     * 
     * @return The Availability Zone where you want to create the router output. This must be a valid Availability Zone
     *         for the region specified by <code>regionName</code>, or the current region if no <code>regionName</code>
     *         is provided.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The maintenance configuration settings for the router output, including preferred maintenance windows and
     * schedules.
     * </p>
     * 
     * @return The maintenance configuration settings for the router output, including preferred maintenance windows and
     *         schedules.
     */
    public final MaintenanceConfiguration maintenanceConfiguration() {
        return maintenanceConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Key-value pairs that can be used to tag this router output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs that can be used to tag this router output.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique identifier for the request to ensure idempotency.
     * </p>
     * 
     * @return A unique identifier for the request to ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(routingScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouterOutputRequest)) {
            return false;
        }
        CreateRouterOutputRequest other = (CreateRouterOutputRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(maximumBitrate(), other.maximumBitrate())
                && Objects.equals(routingScopeAsString(), other.routingScopeAsString())
                && Objects.equals(tierAsString(), other.tierAsString()) && Objects.equals(regionName(), other.regionName())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(maintenanceConfiguration(), other.maintenanceConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRouterOutputRequest").add("Name", name()).add("Configuration", configuration())
                .add("MaximumBitrate", maximumBitrate()).add("RoutingScope", routingScopeAsString()).add("Tier", tierAsString())
                .add("RegionName", regionName()).add("AvailabilityZone", availabilityZone())
                .add("MaintenanceConfiguration", maintenanceConfiguration()).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "MaximumBitrate":
            return Optional.ofNullable(clazz.cast(maximumBitrate()));
        case "RoutingScope":
            return Optional.ofNullable(clazz.cast(routingScopeAsString()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "MaintenanceConfiguration":
            return Optional.ofNullable(clazz.cast(maintenanceConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("maximumBitrate", MAXIMUM_BITRATE_FIELD);
        map.put("routingScope", ROUTING_SCOPE_FIELD);
        map.put("tier", TIER_FIELD);
        map.put("regionName", REGION_NAME_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("maintenanceConfiguration", MAINTENANCE_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRouterOutputRequest, T> g) {
        return obj -> g.apply((CreateRouterOutputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRouterOutputRequest> {
        /**
         * <p>
         * The name of the router output.
         * </p>
         * 
         * @param name
         *        The name of the router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration settings for the router output.
         * </p>
         * 
         * @param configuration
         *        The configuration settings for the router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(RouterOutputConfiguration configuration);

        /**
         * <p>
         * The configuration settings for the router output.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouterOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link RouterOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouterOutputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(RouterOutputConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link RouterOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(RouterOutputConfiguration)
         */
        default Builder configuration(Consumer<RouterOutputConfiguration.Builder> configuration) {
            return configuration(RouterOutputConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The maximum bitrate for the router output.
         * </p>
         * 
         * @param maximumBitrate
         *        The maximum bitrate for the router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBitrate(Long maximumBitrate);

        /**
         * <p>
         * Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default) - can
         * only take inputs from same Region. GLOBAL - can take inputs from any Region.
         * </p>
         * 
         * @param routingScope
         *        Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default)
         *        - can only take inputs from same Region. GLOBAL - can take inputs from any Region.
         * @see RoutingScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingScope
         */
        Builder routingScope(String routingScope);

        /**
         * <p>
         * Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default) - can
         * only take inputs from same Region. GLOBAL - can take inputs from any Region.
         * </p>
         * 
         * @param routingScope
         *        Specifies whether the router output can take inputs that are in different Regions. REGIONAL (default)
         *        - can only take inputs from same Region. GLOBAL - can take inputs from any Region.
         * @see RoutingScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingScope
         */
        Builder routingScope(RoutingScope routingScope);

        /**
         * <p>
         * The tier level for the router output.
         * </p>
         * 
         * @param tier
         *        The tier level for the router output.
         * @see RouterOutputTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterOutputTier
         */
        Builder tier(String tier);

        /**
         * <p>
         * The tier level for the router output.
         * </p>
         * 
         * @param tier
         *        The tier level for the router output.
         * @see RouterOutputTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouterOutputTier
         */
        Builder tier(RouterOutputTier tier);

        /**
         * <p>
         * The AWS Region for the router output. Defaults to the current region if not specified.
         * </p>
         * 
         * @param regionName
         *        The AWS Region for the router output. Defaults to the current region if not specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The Availability Zone where you want to create the router output. This must be a valid Availability Zone for
         * the region specified by <code>regionName</code>, or the current region if no <code>regionName</code> is
         * provided.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where you want to create the router output. This must be a valid Availability
         *        Zone for the region specified by <code>regionName</code>, or the current region if no
         *        <code>regionName</code> is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The maintenance configuration settings for the router output, including preferred maintenance windows and
         * schedules.
         * </p>
         * 
         * @param maintenanceConfiguration
         *        The maintenance configuration settings for the router output, including preferred maintenance windows
         *        and schedules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceConfiguration(MaintenanceConfiguration maintenanceConfiguration);

        /**
         * <p>
         * The maintenance configuration settings for the router output, including preferred maintenance windows and
         * schedules.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaintenanceConfiguration.Builder}
         * avoiding the need to create one manually via {@link MaintenanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #maintenanceConfiguration(MaintenanceConfiguration)}.
         * 
         * @param maintenanceConfiguration
         *        a consumer that will call methods on {@link MaintenanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceConfiguration(MaintenanceConfiguration)
         */
        default Builder maintenanceConfiguration(Consumer<MaintenanceConfiguration.Builder> maintenanceConfiguration) {
            return maintenanceConfiguration(MaintenanceConfiguration.builder().applyMutation(maintenanceConfiguration).build());
        }

        /**
         * <p>
         * Key-value pairs that can be used to tag this router output.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to tag this router output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A unique identifier for the request to ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for the request to ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String name;

        private RouterOutputConfiguration configuration;

        private Long maximumBitrate;

        private String routingScope;

        private String tier;

        private String regionName;

        private String availabilityZone;

        private MaintenanceConfiguration maintenanceConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouterOutputRequest model) {
            super(model);
            name(model.name);
            configuration(model.configuration);
            maximumBitrate(model.maximumBitrate);
            routingScope(model.routingScope);
            tier(model.tier);
            regionName(model.regionName);
            availabilityZone(model.availabilityZone);
            maintenanceConfiguration(model.maintenanceConfiguration);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RouterOutputConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(RouterOutputConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RouterOutputConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Long getMaximumBitrate() {
            return maximumBitrate;
        }

        public final void setMaximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        public final String getRoutingScope() {
            return routingScope;
        }

        public final void setRoutingScope(String routingScope) {
            this.routingScope = routingScope;
        }

        @Override
        public final Builder routingScope(String routingScope) {
            this.routingScope = routingScope;
            return this;
        }

        @Override
        public final Builder routingScope(RoutingScope routingScope) {
            this.routingScope(routingScope == null ? null : routingScope.toString());
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(RouterOutputTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final MaintenanceConfiguration.Builder getMaintenanceConfiguration() {
            return maintenanceConfiguration != null ? maintenanceConfiguration.toBuilder() : null;
        }

        public final void setMaintenanceConfiguration(MaintenanceConfiguration.BuilderImpl maintenanceConfiguration) {
            this.maintenanceConfiguration = maintenanceConfiguration != null ? maintenanceConfiguration.build() : null;
        }

        @Override
        public final Builder maintenanceConfiguration(MaintenanceConfiguration maintenanceConfiguration) {
            this.maintenanceConfiguration = maintenanceConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOfStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOfStringCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRouterOutputRequest build() {
            return new CreateRouterOutputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
