/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRouterInputResponse extends MediaConnectResponse implements
        ToCopyableBuilder<CreateRouterInputResponse.Builder, CreateRouterInputResponse> {
    private static final SdkField<RouterInput> ROUTER_INPUT_FIELD = SdkField.<RouterInput> builder(MarshallingType.SDK_POJO)
            .memberName("RouterInput").getter(getter(CreateRouterInputResponse::routerInput))
            .setter(setter(Builder::routerInput)).constructor(RouterInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTER_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RouterInput routerInput;

    private CreateRouterInputResponse(BuilderImpl builder) {
        super(builder);
        this.routerInput = builder.routerInput;
    }

    /**
     * <p>
     * The newly-created router input.
     * </p>
     * 
     * @return The newly-created router input.
     */
    public final RouterInput routerInput() {
        return routerInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routerInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouterInputResponse)) {
            return false;
        }
        CreateRouterInputResponse other = (CreateRouterInputResponse) obj;
        return Objects.equals(routerInput(), other.routerInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRouterInputResponse").add("RouterInput", routerInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouterInput":
            return Optional.ofNullable(clazz.cast(routerInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("routerInput", ROUTER_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRouterInputResponse, T> g) {
        return obj -> g.apply((CreateRouterInputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRouterInputResponse> {
        /**
         * <p>
         * The newly-created router input.
         * </p>
         * 
         * @param routerInput
         *        The newly-created router input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routerInput(RouterInput routerInput);

        /**
         * <p>
         * The newly-created router input.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouterInput.Builder} avoiding the need to
         * create one manually via {@link RouterInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouterInput.Builder#build()} is called immediately and its result
         * is passed to {@link #routerInput(RouterInput)}.
         * 
         * @param routerInput
         *        a consumer that will call methods on {@link RouterInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routerInput(RouterInput)
         */
        default Builder routerInput(Consumer<RouterInput.Builder> routerInput) {
            return routerInput(RouterInput.builder().applyMutation(routerInput).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private RouterInput routerInput;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouterInputResponse model) {
            super(model);
            routerInput(model.routerInput);
        }

        public final RouterInput.Builder getRouterInput() {
            return routerInput != null ? routerInput.toBuilder() : null;
        }

        public final void setRouterInput(RouterInput.BuilderImpl routerInput) {
            this.routerInput = routerInput != null ? routerInput.build() : null;
        }

        @Override
        public final Builder routerInput(RouterInput routerInput) {
            this.routerInput = routerInput;
            return this;
        }

        @Override
        public CreateRouterInputResponse build() {
            return new CreateRouterInputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
