/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGatewayRequest extends MediaConnectRequest implements
        ToCopyableBuilder<CreateGatewayRequest.Builder, CreateGatewayRequest> {
    private static final SdkField<List<String>> EGRESS_CIDR_BLOCKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EgressCidrBlocks")
            .getter(getter(CreateGatewayRequest::egressCidrBlocks))
            .setter(setter(Builder::egressCidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressCidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateGatewayRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<GatewayNetwork>> NETWORKS_FIELD = SdkField
            .<List<GatewayNetwork>> builder(MarshallingType.LIST)
            .memberName("Networks")
            .getter(getter(CreateGatewayRequest::networks))
            .setter(setter(Builder::networks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GatewayNetwork> builder(MarshallingType.SDK_POJO)
                                            .constructor(GatewayNetwork::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_CIDR_BLOCKS_FIELD,
            NAME_FIELD, NETWORKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> egressCidrBlocks;

    private final String name;

    private final List<GatewayNetwork> networks;

    private CreateGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.egressCidrBlocks = builder.egressCidrBlocks;
        this.name = builder.name;
        this.networks = builder.networks;
    }

    /**
     * For responses, this returns true if the service returned a value for the EgressCidrBlocks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEgressCidrBlocks() {
        return egressCidrBlocks != null && !(egressCidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The range of IP addresses that are allowed to contribute content or initiate output requests for flows
     * communicating with this gateway. These IP addresses should be in the form of a Classless Inter-Domain Routing
     * (CIDR) block; for example, 10.0.0.0/16.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEgressCidrBlocks} method.
     * </p>
     * 
     * @return The range of IP addresses that are allowed to contribute content or initiate output requests for flows
     *         communicating with this gateway. These IP addresses should be in the form of a Classless Inter-Domain
     *         Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    public final List<String> egressCidrBlocks() {
        return egressCidrBlocks;
    }

    /**
     * <p>
     * The name of the gateway. This name can not be modified after the gateway is created.
     * </p>
     * 
     * @return The name of the gateway. This name can not be modified after the gateway is created.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Networks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNetworks() {
        return networks != null && !(networks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of networks that you want to add to the gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworks} method.
     * </p>
     * 
     * @return The list of networks that you want to add to the gateway.
     */
    public final List<GatewayNetwork> networks() {
        return networks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEgressCidrBlocks() ? egressCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworks() ? networks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayRequest)) {
            return false;
        }
        CreateGatewayRequest other = (CreateGatewayRequest) obj;
        return hasEgressCidrBlocks() == other.hasEgressCidrBlocks()
                && Objects.equals(egressCidrBlocks(), other.egressCidrBlocks()) && Objects.equals(name(), other.name())
                && hasNetworks() == other.hasNetworks() && Objects.equals(networks(), other.networks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGatewayRequest")
                .add("EgressCidrBlocks", hasEgressCidrBlocks() ? egressCidrBlocks() : null).add("Name", name())
                .add("Networks", hasNetworks() ? networks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EgressCidrBlocks":
            return Optional.ofNullable(clazz.cast(egressCidrBlocks()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Networks":
            return Optional.ofNullable(clazz.cast(networks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("egressCidrBlocks", EGRESS_CIDR_BLOCKS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("networks", NETWORKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGatewayRequest, T> g) {
        return obj -> g.apply((CreateGatewayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGatewayRequest> {
        /**
         * <p>
         * The range of IP addresses that are allowed to contribute content or initiate output requests for flows
         * communicating with this gateway. These IP addresses should be in the form of a Classless Inter-Domain Routing
         * (CIDR) block; for example, 10.0.0.0/16.
         * </p>
         * 
         * @param egressCidrBlocks
         *        The range of IP addresses that are allowed to contribute content or initiate output requests for flows
         *        communicating with this gateway. These IP addresses should be in the form of a Classless Inter-Domain
         *        Routing (CIDR) block; for example, 10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressCidrBlocks(Collection<String> egressCidrBlocks);

        /**
         * <p>
         * The range of IP addresses that are allowed to contribute content or initiate output requests for flows
         * communicating with this gateway. These IP addresses should be in the form of a Classless Inter-Domain Routing
         * (CIDR) block; for example, 10.0.0.0/16.
         * </p>
         * 
         * @param egressCidrBlocks
         *        The range of IP addresses that are allowed to contribute content or initiate output requests for flows
         *        communicating with this gateway. These IP addresses should be in the form of a Classless Inter-Domain
         *        Routing (CIDR) block; for example, 10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressCidrBlocks(String... egressCidrBlocks);

        /**
         * <p>
         * The name of the gateway. This name can not be modified after the gateway is created.
         * </p>
         * 
         * @param name
         *        The name of the gateway. This name can not be modified after the gateway is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The list of networks that you want to add to the gateway.
         * </p>
         * 
         * @param networks
         *        The list of networks that you want to add to the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networks(Collection<GatewayNetwork> networks);

        /**
         * <p>
         * The list of networks that you want to add to the gateway.
         * </p>
         * 
         * @param networks
         *        The list of networks that you want to add to the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networks(GatewayNetwork... networks);

        /**
         * <p>
         * The list of networks that you want to add to the gateway.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.GatewayNetwork.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediaconnect.model.GatewayNetwork#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.GatewayNetwork.Builder#build()} is called
         * immediately and its result is passed to {@link #networks(List<GatewayNetwork>)}.
         * 
         * @param networks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.GatewayNetwork.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networks(java.util.Collection<GatewayNetwork>)
         */
        Builder networks(Consumer<GatewayNetwork.Builder>... networks);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private List<String> egressCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private List<GatewayNetwork> networks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGatewayRequest model) {
            super(model);
            egressCidrBlocks(model.egressCidrBlocks);
            name(model.name);
            networks(model.networks);
        }

        public final Collection<String> getEgressCidrBlocks() {
            if (egressCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return egressCidrBlocks;
        }

        public final void setEgressCidrBlocks(Collection<String> egressCidrBlocks) {
            this.egressCidrBlocks = ___listOfStringCopier.copy(egressCidrBlocks);
        }

        @Override
        public final Builder egressCidrBlocks(Collection<String> egressCidrBlocks) {
            this.egressCidrBlocks = ___listOfStringCopier.copy(egressCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressCidrBlocks(String... egressCidrBlocks) {
            egressCidrBlocks(Arrays.asList(egressCidrBlocks));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<GatewayNetwork.Builder> getNetworks() {
            List<GatewayNetwork.Builder> result = ___listOfGatewayNetworkCopier.copyToBuilder(this.networks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworks(Collection<GatewayNetwork.BuilderImpl> networks) {
            this.networks = ___listOfGatewayNetworkCopier.copyFromBuilder(networks);
        }

        @Override
        public final Builder networks(Collection<GatewayNetwork> networks) {
            this.networks = ___listOfGatewayNetworkCopier.copy(networks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(GatewayNetwork... networks) {
            networks(Arrays.asList(networks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(Consumer<GatewayNetwork.Builder>... networks) {
            networks(Stream.of(networks).map(c -> GatewayNetwork.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGatewayRequest build() {
            return new CreateGatewayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
