/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBridgeRequest extends MediaConnectRequest implements
        ToCopyableBuilder<CreateBridgeRequest.Builder, CreateBridgeRequest> {
    private static final SdkField<AddEgressGatewayBridgeRequest> EGRESS_GATEWAY_BRIDGE_FIELD = SdkField
            .<AddEgressGatewayBridgeRequest> builder(MarshallingType.SDK_POJO).memberName("EgressGatewayBridge")
            .getter(getter(CreateBridgeRequest::egressGatewayBridge)).setter(setter(Builder::egressGatewayBridge))
            .constructor(AddEgressGatewayBridgeRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressGatewayBridge").build())
            .build();

    private static final SdkField<AddIngressGatewayBridgeRequest> INGRESS_GATEWAY_BRIDGE_FIELD = SdkField
            .<AddIngressGatewayBridgeRequest> builder(MarshallingType.SDK_POJO).memberName("IngressGatewayBridge")
            .getter(getter(CreateBridgeRequest::ingressGatewayBridge)).setter(setter(Builder::ingressGatewayBridge))
            .constructor(AddIngressGatewayBridgeRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressGatewayBridge").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateBridgeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<AddBridgeOutputRequest>> OUTPUTS_FIELD = SdkField
            .<List<AddBridgeOutputRequest>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(CreateBridgeRequest::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddBridgeOutputRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddBridgeOutputRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLACEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlacementArn").getter(getter(CreateBridgeRequest::placementArn)).setter(setter(Builder::placementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementArn").build()).build();

    private static final SdkField<FailoverConfig> SOURCE_FAILOVER_CONFIG_FIELD = SdkField
            .<FailoverConfig> builder(MarshallingType.SDK_POJO).memberName("SourceFailoverConfig")
            .getter(getter(CreateBridgeRequest::sourceFailoverConfig)).setter(setter(Builder::sourceFailoverConfig))
            .constructor(FailoverConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFailoverConfig").build())
            .build();

    private static final SdkField<List<AddBridgeSourceRequest>> SOURCES_FIELD = SdkField
            .<List<AddBridgeSourceRequest>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(CreateBridgeRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddBridgeSourceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddBridgeSourceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_GATEWAY_BRIDGE_FIELD,
            INGRESS_GATEWAY_BRIDGE_FIELD, NAME_FIELD, OUTPUTS_FIELD, PLACEMENT_ARN_FIELD, SOURCE_FAILOVER_CONFIG_FIELD,
            SOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AddEgressGatewayBridgeRequest egressGatewayBridge;

    private final AddIngressGatewayBridgeRequest ingressGatewayBridge;

    private final String name;

    private final List<AddBridgeOutputRequest> outputs;

    private final String placementArn;

    private final FailoverConfig sourceFailoverConfig;

    private final List<AddBridgeSourceRequest> sources;

    private CreateBridgeRequest(BuilderImpl builder) {
        super(builder);
        this.egressGatewayBridge = builder.egressGatewayBridge;
        this.ingressGatewayBridge = builder.ingressGatewayBridge;
        this.name = builder.name;
        this.outputs = builder.outputs;
        this.placementArn = builder.placementArn;
        this.sourceFailoverConfig = builder.sourceFailoverConfig;
        this.sources = builder.sources;
    }

    /**
     * <p>
     * An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is
     * delivered to your premises.
     * </p>
     * 
     * @return An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is
     *         delivered to your premises.
     */
    public final AddEgressGatewayBridgeRequest egressGatewayBridge() {
        return egressGatewayBridge;
    }

    /**
     * <p>
     * An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to the
     * cloud.
     * </p>
     * 
     * @return An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered
     *         to the cloud.
     */
    public final AddIngressGatewayBridgeRequest ingressGatewayBridge() {
        return ingressGatewayBridge;
    }

    /**
     * <p>
     * The name of the bridge. This name can not be modified after the bridge is created.
     * </p>
     * 
     * @return The name of the bridge. This name can not be modified after the bridge is created.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outputs that you want to add to this bridge.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The outputs that you want to add to this bridge.
     */
    public final List<AddBridgeOutputRequest> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The bridge placement Amazon Resource Number (ARN).
     * </p>
     * 
     * @return The bridge placement Amazon Resource Number (ARN).
     */
    public final String placementArn() {
        return placementArn;
    }

    /**
     * <p>
     * The settings for source failover.
     * </p>
     * 
     * @return The settings for source failover.
     */
    public final FailoverConfig sourceFailoverConfig() {
        return sourceFailoverConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sources that you want to add to this bridge.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The sources that you want to add to this bridge.
     */
    public final List<AddBridgeSourceRequest> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(egressGatewayBridge());
        hashCode = 31 * hashCode + Objects.hashCode(ingressGatewayBridge());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(placementArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFailoverConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBridgeRequest)) {
            return false;
        }
        CreateBridgeRequest other = (CreateBridgeRequest) obj;
        return Objects.equals(egressGatewayBridge(), other.egressGatewayBridge())
                && Objects.equals(ingressGatewayBridge(), other.ingressGatewayBridge()) && Objects.equals(name(), other.name())
                && hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs())
                && Objects.equals(placementArn(), other.placementArn())
                && Objects.equals(sourceFailoverConfig(), other.sourceFailoverConfig()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBridgeRequest").add("EgressGatewayBridge", egressGatewayBridge())
                .add("IngressGatewayBridge", ingressGatewayBridge()).add("Name", name())
                .add("Outputs", hasOutputs() ? outputs() : null).add("PlacementArn", placementArn())
                .add("SourceFailoverConfig", sourceFailoverConfig()).add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EgressGatewayBridge":
            return Optional.ofNullable(clazz.cast(egressGatewayBridge()));
        case "IngressGatewayBridge":
            return Optional.ofNullable(clazz.cast(ingressGatewayBridge()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "PlacementArn":
            return Optional.ofNullable(clazz.cast(placementArn()));
        case "SourceFailoverConfig":
            return Optional.ofNullable(clazz.cast(sourceFailoverConfig()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("egressGatewayBridge", EGRESS_GATEWAY_BRIDGE_FIELD);
        map.put("ingressGatewayBridge", INGRESS_GATEWAY_BRIDGE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("outputs", OUTPUTS_FIELD);
        map.put("placementArn", PLACEMENT_ARN_FIELD);
        map.put("sourceFailoverConfig", SOURCE_FAILOVER_CONFIG_FIELD);
        map.put("sources", SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBridgeRequest, T> g) {
        return obj -> g.apply((CreateBridgeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBridgeRequest> {
        /**
         * <p>
         * An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is
         * delivered to your premises.
         * </p>
         * 
         * @param egressGatewayBridge
         *        An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and
         *        is delivered to your premises.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressGatewayBridge(AddEgressGatewayBridgeRequest egressGatewayBridge);

        /**
         * <p>
         * An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is
         * delivered to your premises.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddEgressGatewayBridgeRequest.Builder}
         * avoiding the need to create one manually via {@link AddEgressGatewayBridgeRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddEgressGatewayBridgeRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #egressGatewayBridge(AddEgressGatewayBridgeRequest)}.
         * 
         * @param egressGatewayBridge
         *        a consumer that will call methods on {@link AddEgressGatewayBridgeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressGatewayBridge(AddEgressGatewayBridgeRequest)
         */
        default Builder egressGatewayBridge(Consumer<AddEgressGatewayBridgeRequest.Builder> egressGatewayBridge) {
            return egressGatewayBridge(AddEgressGatewayBridgeRequest.builder().applyMutation(egressGatewayBridge).build());
        }

        /**
         * <p>
         * An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to
         * the cloud.
         * </p>
         * 
         * @param ingressGatewayBridge
         *        An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is
         *        delivered to the cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressGatewayBridge(AddIngressGatewayBridgeRequest ingressGatewayBridge);

        /**
         * <p>
         * An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to
         * the cloud.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddIngressGatewayBridgeRequest.Builder}
         * avoiding the need to create one manually via {@link AddIngressGatewayBridgeRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddIngressGatewayBridgeRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #ingressGatewayBridge(AddIngressGatewayBridgeRequest)}.
         * 
         * @param ingressGatewayBridge
         *        a consumer that will call methods on {@link AddIngressGatewayBridgeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressGatewayBridge(AddIngressGatewayBridgeRequest)
         */
        default Builder ingressGatewayBridge(Consumer<AddIngressGatewayBridgeRequest.Builder> ingressGatewayBridge) {
            return ingressGatewayBridge(AddIngressGatewayBridgeRequest.builder().applyMutation(ingressGatewayBridge).build());
        }

        /**
         * <p>
         * The name of the bridge. This name can not be modified after the bridge is created.
         * </p>
         * 
         * @param name
         *        The name of the bridge. This name can not be modified after the bridge is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The outputs that you want to add to this bridge.
         * </p>
         * 
         * @param outputs
         *        The outputs that you want to add to this bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<AddBridgeOutputRequest> outputs);

        /**
         * <p>
         * The outputs that you want to add to this bridge.
         * </p>
         * 
         * @param outputs
         *        The outputs that you want to add to this bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(AddBridgeOutputRequest... outputs);

        /**
         * <p>
         * The outputs that you want to add to this bridge.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputRequest.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #outputs(List<AddBridgeOutputRequest>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<AddBridgeOutputRequest>)
         */
        Builder outputs(Consumer<AddBridgeOutputRequest.Builder>... outputs);

        /**
         * <p>
         * The bridge placement Amazon Resource Number (ARN).
         * </p>
         * 
         * @param placementArn
         *        The bridge placement Amazon Resource Number (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementArn(String placementArn);

        /**
         * <p>
         * The settings for source failover.
         * </p>
         * 
         * @param sourceFailoverConfig
         *        The settings for source failover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig);

        /**
         * <p>
         * The settings for source failover.
         * </p>
         * This is a convenience method that creates an instance of the {@link FailoverConfig.Builder} avoiding the need
         * to create one manually via {@link FailoverConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailoverConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceFailoverConfig(FailoverConfig)}.
         * 
         * @param sourceFailoverConfig
         *        a consumer that will call methods on {@link FailoverConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceFailoverConfig(FailoverConfig)
         */
        default Builder sourceFailoverConfig(Consumer<FailoverConfig.Builder> sourceFailoverConfig) {
            return sourceFailoverConfig(FailoverConfig.builder().applyMutation(sourceFailoverConfig).build());
        }

        /**
         * <p>
         * The sources that you want to add to this bridge.
         * </p>
         * 
         * @param sources
         *        The sources that you want to add to this bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<AddBridgeSourceRequest> sources);

        /**
         * <p>
         * The sources that you want to add to this bridge.
         * </p>
         * 
         * @param sources
         *        The sources that you want to add to this bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(AddBridgeSourceRequest... sources);

        /**
         * <p>
         * The sources that you want to add to this bridge.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourceRequest.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<AddBridgeSourceRequest>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<AddBridgeSourceRequest>)
         */
        Builder sources(Consumer<AddBridgeSourceRequest.Builder>... sources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private AddEgressGatewayBridgeRequest egressGatewayBridge;

        private AddIngressGatewayBridgeRequest ingressGatewayBridge;

        private String name;

        private List<AddBridgeOutputRequest> outputs = DefaultSdkAutoConstructList.getInstance();

        private String placementArn;

        private FailoverConfig sourceFailoverConfig;

        private List<AddBridgeSourceRequest> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBridgeRequest model) {
            super(model);
            egressGatewayBridge(model.egressGatewayBridge);
            ingressGatewayBridge(model.ingressGatewayBridge);
            name(model.name);
            outputs(model.outputs);
            placementArn(model.placementArn);
            sourceFailoverConfig(model.sourceFailoverConfig);
            sources(model.sources);
        }

        public final AddEgressGatewayBridgeRequest.Builder getEgressGatewayBridge() {
            return egressGatewayBridge != null ? egressGatewayBridge.toBuilder() : null;
        }

        public final void setEgressGatewayBridge(AddEgressGatewayBridgeRequest.BuilderImpl egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge != null ? egressGatewayBridge.build() : null;
        }

        @Override
        public final Builder egressGatewayBridge(AddEgressGatewayBridgeRequest egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge;
            return this;
        }

        public final AddIngressGatewayBridgeRequest.Builder getIngressGatewayBridge() {
            return ingressGatewayBridge != null ? ingressGatewayBridge.toBuilder() : null;
        }

        public final void setIngressGatewayBridge(AddIngressGatewayBridgeRequest.BuilderImpl ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge != null ? ingressGatewayBridge.build() : null;
        }

        @Override
        public final Builder ingressGatewayBridge(AddIngressGatewayBridgeRequest ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AddBridgeOutputRequest.Builder> getOutputs() {
            List<AddBridgeOutputRequest.Builder> result = ___listOfAddBridgeOutputRequestCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<AddBridgeOutputRequest.BuilderImpl> outputs) {
            this.outputs = ___listOfAddBridgeOutputRequestCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<AddBridgeOutputRequest> outputs) {
            this.outputs = ___listOfAddBridgeOutputRequestCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(AddBridgeOutputRequest... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<AddBridgeOutputRequest.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> AddBridgeOutputRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPlacementArn() {
            return placementArn;
        }

        public final void setPlacementArn(String placementArn) {
            this.placementArn = placementArn;
        }

        @Override
        public final Builder placementArn(String placementArn) {
            this.placementArn = placementArn;
            return this;
        }

        public final FailoverConfig.Builder getSourceFailoverConfig() {
            return sourceFailoverConfig != null ? sourceFailoverConfig.toBuilder() : null;
        }

        public final void setSourceFailoverConfig(FailoverConfig.BuilderImpl sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig != null ? sourceFailoverConfig.build() : null;
        }

        @Override
        public final Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        public final List<AddBridgeSourceRequest.Builder> getSources() {
            List<AddBridgeSourceRequest.Builder> result = ___listOfAddBridgeSourceRequestCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<AddBridgeSourceRequest.BuilderImpl> sources) {
            this.sources = ___listOfAddBridgeSourceRequestCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<AddBridgeSourceRequest> sources) {
            this.sources = ___listOfAddBridgeSourceRequestCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(AddBridgeSourceRequest... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<AddBridgeSourceRequest.Builder>... sources) {
            sources(Stream.of(sources).map(c -> AddBridgeSourceRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBridgeRequest build() {
            return new CreateBridgeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
