/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetRouterOutputResponse extends MediaConnectResponse implements
        ToCopyableBuilder<BatchGetRouterOutputResponse.Builder, BatchGetRouterOutputResponse> {
    private static final SdkField<List<RouterOutput>> ROUTER_OUTPUTS_FIELD = SdkField
            .<List<RouterOutput>> builder(MarshallingType.LIST)
            .memberName("RouterOutputs")
            .getter(getter(BatchGetRouterOutputResponse::routerOutputs))
            .setter(setter(Builder::routerOutputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerOutputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouterOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouterOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetRouterOutputError>> ERRORS_FIELD = SdkField
            .<List<BatchGetRouterOutputError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchGetRouterOutputResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetRouterOutputError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetRouterOutputError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTER_OUTPUTS_FIELD,
            ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RouterOutput> routerOutputs;

    private final List<BatchGetRouterOutputError> errors;

    private BatchGetRouterOutputResponse(BuilderImpl builder) {
        super(builder);
        this.routerOutputs = builder.routerOutputs;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouterOutputs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouterOutputs() {
        return routerOutputs != null && !(routerOutputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of router outputs that were successfully retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouterOutputs} method.
     * </p>
     * 
     * @return An array of router outputs that were successfully retrieved.
     */
    public final List<RouterOutput> routerOutputs() {
        return routerOutputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of errors that occurred when retrieving the requested router outputs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return An array of errors that occurred when retrieving the requested router outputs.
     */
    public final List<BatchGetRouterOutputError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRouterOutputs() ? routerOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRouterOutputResponse)) {
            return false;
        }
        BatchGetRouterOutputResponse other = (BatchGetRouterOutputResponse) obj;
        return hasRouterOutputs() == other.hasRouterOutputs() && Objects.equals(routerOutputs(), other.routerOutputs())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetRouterOutputResponse").add("RouterOutputs", hasRouterOutputs() ? routerOutputs() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouterOutputs":
            return Optional.ofNullable(clazz.cast(routerOutputs()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("routerOutputs", ROUTER_OUTPUTS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRouterOutputResponse, T> g) {
        return obj -> g.apply((BatchGetRouterOutputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetRouterOutputResponse> {
        /**
         * <p>
         * An array of router outputs that were successfully retrieved.
         * </p>
         * 
         * @param routerOutputs
         *        An array of router outputs that were successfully retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routerOutputs(Collection<RouterOutput> routerOutputs);

        /**
         * <p>
         * An array of router outputs that were successfully retrieved.
         * </p>
         * 
         * @param routerOutputs
         *        An array of router outputs that were successfully retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routerOutputs(RouterOutput... routerOutputs);

        /**
         * <p>
         * An array of router outputs that were successfully retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.RouterOutput.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediaconnect.model.RouterOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.RouterOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #routerOutputs(List<RouterOutput>)}.
         * 
         * @param routerOutputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.RouterOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routerOutputs(java.util.Collection<RouterOutput>)
         */
        Builder routerOutputs(Consumer<RouterOutput.Builder>... routerOutputs);

        /**
         * <p>
         * An array of errors that occurred when retrieving the requested router outputs.
         * </p>
         * 
         * @param errors
         *        An array of errors that occurred when retrieving the requested router outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetRouterOutputError> errors);

        /**
         * <p>
         * An array of errors that occurred when retrieving the requested router outputs.
         * </p>
         * 
         * @param errors
         *        An array of errors that occurred when retrieving the requested router outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetRouterOutputError... errors);

        /**
         * <p>
         * An array of errors that occurred when retrieving the requested router outputs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputError.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputError.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<BatchGetRouterOutputError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchGetRouterOutputError>)
         */
        Builder errors(Consumer<BatchGetRouterOutputError.Builder>... errors);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private List<RouterOutput> routerOutputs = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetRouterOutputError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRouterOutputResponse model) {
            super(model);
            routerOutputs(model.routerOutputs);
            errors(model.errors);
        }

        public final List<RouterOutput.Builder> getRouterOutputs() {
            List<RouterOutput.Builder> result = RouterOutputListCopier.copyToBuilder(this.routerOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouterOutputs(Collection<RouterOutput.BuilderImpl> routerOutputs) {
            this.routerOutputs = RouterOutputListCopier.copyFromBuilder(routerOutputs);
        }

        @Override
        public final Builder routerOutputs(Collection<RouterOutput> routerOutputs) {
            this.routerOutputs = RouterOutputListCopier.copy(routerOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerOutputs(RouterOutput... routerOutputs) {
            routerOutputs(Arrays.asList(routerOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerOutputs(Consumer<RouterOutput.Builder>... routerOutputs) {
            routerOutputs(Stream.of(routerOutputs).map(c -> RouterOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetRouterOutputError.Builder> getErrors() {
            List<BatchGetRouterOutputError.Builder> result = BatchGetRouterOutputErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetRouterOutputError.BuilderImpl> errors) {
            this.errors = BatchGetRouterOutputErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetRouterOutputError> errors) {
            this.errors = BatchGetRouterOutputErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetRouterOutputError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetRouterOutputError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetRouterOutputError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetRouterOutputResponse build() {
            return new BatchGetRouterOutputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
