/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.Protocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Transport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Transport> {
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Transport.getter(Transport::maxBitrate)).setter(Transport.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Transport.getter(Transport::maxLatency)).setter(Transport.setter(Builder::maxLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Transport.getter(Transport::protocolAsString)).setter(Transport.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<Integer> SMOOTHING_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Transport.getter(Transport::smoothingLatency)).setter(Transport.setter(Builder::smoothingLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smoothingLatency").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Transport.getter(Transport::streamId)).setter(Transport.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_BITRATE_FIELD, MAX_LATENCY_FIELD, PROTOCOL_FIELD, SMOOTHING_LATENCY_FIELD, STREAM_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maxBitrate;
    private final Integer maxLatency;
    private final String protocol;
    private final Integer smoothingLatency;
    private final String streamId;

    private Transport(BuilderImpl builder) {
        this.maxBitrate = builder.maxBitrate;
        this.maxLatency = builder.maxLatency;
        this.protocol = builder.protocol;
        this.smoothingLatency = builder.smoothingLatency;
        this.streamId = builder.streamId;
    }

    public Integer maxBitrate() {
        return this.maxBitrate;
    }

    public Integer maxLatency() {
        return this.maxLatency;
    }

    public Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public Integer smoothingLatency() {
        return this.smoothingLatency;
    }

    public String streamId() {
        return this.streamId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.smoothingLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transport)) {
            return false;
        }
        Transport other = (Transport)obj;
        return Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.maxLatency(), other.maxLatency()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.smoothingLatency(), other.smoothingLatency()) && Objects.equals(this.streamId(), other.streamId());
    }

    public String toString() {
        return ToString.builder((String)"Transport").add("MaxBitrate", (Object)this.maxBitrate()).add("MaxLatency", (Object)this.maxLatency()).add("Protocol", (Object)this.protocolAsString()).add("SmoothingLatency", (Object)this.smoothingLatency()).add("StreamId", (Object)this.streamId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MaxLatency": {
                return Optional.ofNullable(clazz.cast(this.maxLatency()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "SmoothingLatency": {
                return Optional.ofNullable(clazz.cast(this.smoothingLatency()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Transport, T> g) {
        return obj -> g.apply((Transport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxBitrate;
        private Integer maxLatency;
        private String protocol;
        private Integer smoothingLatency;
        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(Transport model) {
            this.maxBitrate(model.maxBitrate);
            this.maxLatency(model.maxLatency);
            this.protocol(model.protocol);
            this.smoothingLatency(model.smoothingLatency);
            this.streamId(model.streamId);
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMaxLatency() {
            return this.maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        public final String getProtocolAsString() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getSmoothingLatency() {
            return this.smoothingLatency;
        }

        @Override
        public final Builder smoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
            return this;
        }

        public final void setSmoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public Transport build() {
            return new Transport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Transport> {
        public Builder maxBitrate(Integer var1);

        public Builder maxLatency(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder smoothingLatency(Integer var1);

        public Builder streamId(String var1);
    }
}

