/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.Encryption;
import software.amazon.awssdk.services.mediaconnect.model.MediaStreamOutputConfigurationRequest;
import software.amazon.awssdk.services.mediaconnect.model.OutputStatus;
import software.amazon.awssdk.services.mediaconnect.model.Protocol;
import software.amazon.awssdk.services.mediaconnect.model.VpcInterfaceAttachment;
import software.amazon.awssdk.services.mediaconnect.model.___listOfMediaStreamOutputConfigurationRequestCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfStringCopier;
import software.amazon.awssdk.services.mediaconnect.model.___mapOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddOutputRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddOutputRequest> {
    private static final SdkField<List<String>> CIDR_ALLOW_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrAllowList").getter(AddOutputRequest.getter(AddOutputRequest::cidrAllowList)).setter(AddOutputRequest.setter(Builder::cidrAllowList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrAllowList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AddOutputRequest.getter(AddOutputRequest::description)).setter(AddOutputRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(AddOutputRequest.getter(AddOutputRequest::destination)).setter(AddOutputRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(AddOutputRequest.getter(AddOutputRequest::encryption)).setter(AddOutputRequest.setter(Builder::encryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxLatency").getter(AddOutputRequest.getter(AddOutputRequest::maxLatency)).setter(AddOutputRequest.setter(Builder::maxLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()}).build();
    private static final SdkField<List<MediaStreamOutputConfigurationRequest>> MEDIA_STREAM_OUTPUT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaStreamOutputConfigurations").getter(AddOutputRequest.getter(AddOutputRequest::mediaStreamOutputConfigurations)).setter(AddOutputRequest.setter(Builder::mediaStreamOutputConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamOutputConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaStreamOutputConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MIN_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinLatency").getter(AddOutputRequest.getter(AddOutputRequest::minLatency)).setter(AddOutputRequest.setter(Builder::minLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minLatency").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AddOutputRequest.getter(AddOutputRequest::name)).setter(AddOutputRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(AddOutputRequest.getter(AddOutputRequest::port)).setter(AddOutputRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(AddOutputRequest.getter(AddOutputRequest::protocolAsString)).setter(AddOutputRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> REMOTE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteId").getter(AddOutputRequest.getter(AddOutputRequest::remoteId)).setter(AddOutputRequest.setter(Builder::remoteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteId").build()}).build();
    private static final SdkField<Integer> SENDER_CONTROL_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SenderControlPort").getter(AddOutputRequest.getter(AddOutputRequest::senderControlPort)).setter(AddOutputRequest.setter(Builder::senderControlPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderControlPort").build()}).build();
    private static final SdkField<Integer> SMOOTHING_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SmoothingLatency").getter(AddOutputRequest.getter(AddOutputRequest::smoothingLatency)).setter(AddOutputRequest.setter(Builder::smoothingLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smoothingLatency").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamId").getter(AddOutputRequest.getter(AddOutputRequest::streamId)).setter(AddOutputRequest.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<VpcInterfaceAttachment> VPC_INTERFACE_ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcInterfaceAttachment").getter(AddOutputRequest.getter(AddOutputRequest::vpcInterfaceAttachment)).setter(AddOutputRequest.setter(Builder::vpcInterfaceAttachment)).constructor(VpcInterfaceAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceAttachment").build()}).build();
    private static final SdkField<String> OUTPUT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputStatus").getter(AddOutputRequest.getter(AddOutputRequest::outputStatusAsString)).setter(AddOutputRequest.setter(Builder::outputStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputStatus").build()}).build();
    private static final SdkField<Integer> NDI_SPEED_HQ_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NdiSpeedHqQuality").getter(AddOutputRequest.getter(AddOutputRequest::ndiSpeedHqQuality)).setter(AddOutputRequest.setter(Builder::ndiSpeedHqQuality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ndiSpeedHqQuality").build()}).build();
    private static final SdkField<String> NDI_PROGRAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NdiProgramName").getter(AddOutputRequest.getter(AddOutputRequest::ndiProgramName)).setter(AddOutputRequest.setter(Builder::ndiProgramName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ndiProgramName").build()}).build();
    private static final SdkField<Map<String, String>> OUTPUT_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OutputTags").getter(AddOutputRequest.getter(AddOutputRequest::outputTags)).setter(AddOutputRequest.setter(Builder::outputTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_ALLOW_LIST_FIELD, DESCRIPTION_FIELD, DESTINATION_FIELD, ENCRYPTION_FIELD, MAX_LATENCY_FIELD, MEDIA_STREAM_OUTPUT_CONFIGURATIONS_FIELD, MIN_LATENCY_FIELD, NAME_FIELD, PORT_FIELD, PROTOCOL_FIELD, REMOTE_ID_FIELD, SENDER_CONTROL_PORT_FIELD, SMOOTHING_LATENCY_FIELD, STREAM_ID_FIELD, VPC_INTERFACE_ATTACHMENT_FIELD, OUTPUT_STATUS_FIELD, NDI_SPEED_HQ_QUALITY_FIELD, NDI_PROGRAM_NAME_FIELD, OUTPUT_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddOutputRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> cidrAllowList;
    private final String description;
    private final String destination;
    private final Encryption encryption;
    private final Integer maxLatency;
    private final List<MediaStreamOutputConfigurationRequest> mediaStreamOutputConfigurations;
    private final Integer minLatency;
    private final String name;
    private final Integer port;
    private final String protocol;
    private final String remoteId;
    private final Integer senderControlPort;
    private final Integer smoothingLatency;
    private final String streamId;
    private final VpcInterfaceAttachment vpcInterfaceAttachment;
    private final String outputStatus;
    private final Integer ndiSpeedHqQuality;
    private final String ndiProgramName;
    private final Map<String, String> outputTags;

    private AddOutputRequest(BuilderImpl builder) {
        this.cidrAllowList = builder.cidrAllowList;
        this.description = builder.description;
        this.destination = builder.destination;
        this.encryption = builder.encryption;
        this.maxLatency = builder.maxLatency;
        this.mediaStreamOutputConfigurations = builder.mediaStreamOutputConfigurations;
        this.minLatency = builder.minLatency;
        this.name = builder.name;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.remoteId = builder.remoteId;
        this.senderControlPort = builder.senderControlPort;
        this.smoothingLatency = builder.smoothingLatency;
        this.streamId = builder.streamId;
        this.vpcInterfaceAttachment = builder.vpcInterfaceAttachment;
        this.outputStatus = builder.outputStatus;
        this.ndiSpeedHqQuality = builder.ndiSpeedHqQuality;
        this.ndiProgramName = builder.ndiProgramName;
        this.outputTags = builder.outputTags;
    }

    public final boolean hasCidrAllowList() {
        return this.cidrAllowList != null && !(this.cidrAllowList instanceof SdkAutoConstructList);
    }

    public final List<String> cidrAllowList() {
        return this.cidrAllowList;
    }

    public final String description() {
        return this.description;
    }

    public final String destination() {
        return this.destination;
    }

    public final Encryption encryption() {
        return this.encryption;
    }

    public final Integer maxLatency() {
        return this.maxLatency;
    }

    public final boolean hasMediaStreamOutputConfigurations() {
        return this.mediaStreamOutputConfigurations != null && !(this.mediaStreamOutputConfigurations instanceof SdkAutoConstructList);
    }

    public final List<MediaStreamOutputConfigurationRequest> mediaStreamOutputConfigurations() {
        return this.mediaStreamOutputConfigurations;
    }

    public final Integer minLatency() {
        return this.minLatency;
    }

    public final String name() {
        return this.name;
    }

    public final Integer port() {
        return this.port;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final String remoteId() {
        return this.remoteId;
    }

    public final Integer senderControlPort() {
        return this.senderControlPort;
    }

    public final Integer smoothingLatency() {
        return this.smoothingLatency;
    }

    public final String streamId() {
        return this.streamId;
    }

    public final VpcInterfaceAttachment vpcInterfaceAttachment() {
        return this.vpcInterfaceAttachment;
    }

    public final OutputStatus outputStatus() {
        return OutputStatus.fromValue(this.outputStatus);
    }

    public final String outputStatusAsString() {
        return this.outputStatus;
    }

    public final Integer ndiSpeedHqQuality() {
        return this.ndiSpeedHqQuality;
    }

    public final String ndiProgramName() {
        return this.ndiProgramName;
    }

    public final boolean hasOutputTags() {
        return this.outputTags != null && !(this.outputTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> outputTags() {
        return this.outputTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrAllowList() ? this.cidrAllowList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaStreamOutputConfigurations() ? this.mediaStreamOutputConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderControlPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.smoothingLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcInterfaceAttachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ndiSpeedHqQuality());
        hashCode = 31 * hashCode + Objects.hashCode(this.ndiProgramName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputTags() ? this.outputTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddOutputRequest)) {
            return false;
        }
        AddOutputRequest other = (AddOutputRequest)obj;
        return this.hasCidrAllowList() == other.hasCidrAllowList() && Objects.equals(this.cidrAllowList(), other.cidrAllowList()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.maxLatency(), other.maxLatency()) && this.hasMediaStreamOutputConfigurations() == other.hasMediaStreamOutputConfigurations() && Objects.equals(this.mediaStreamOutputConfigurations(), other.mediaStreamOutputConfigurations()) && Objects.equals(this.minLatency(), other.minLatency()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.remoteId(), other.remoteId()) && Objects.equals(this.senderControlPort(), other.senderControlPort()) && Objects.equals(this.smoothingLatency(), other.smoothingLatency()) && Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.vpcInterfaceAttachment(), other.vpcInterfaceAttachment()) && Objects.equals(this.outputStatusAsString(), other.outputStatusAsString()) && Objects.equals(this.ndiSpeedHqQuality(), other.ndiSpeedHqQuality()) && Objects.equals(this.ndiProgramName(), other.ndiProgramName()) && this.hasOutputTags() == other.hasOutputTags() && Objects.equals(this.outputTags(), other.outputTags());
    }

    public final String toString() {
        return ToString.builder((String)"AddOutputRequest").add("CidrAllowList", this.hasCidrAllowList() ? this.cidrAllowList() : null).add("Description", (Object)this.description()).add("Destination", (Object)this.destination()).add("Encryption", (Object)this.encryption()).add("MaxLatency", (Object)this.maxLatency()).add("MediaStreamOutputConfigurations", this.hasMediaStreamOutputConfigurations() ? this.mediaStreamOutputConfigurations() : null).add("MinLatency", (Object)this.minLatency()).add("Name", (Object)this.name()).add("Port", (Object)this.port()).add("Protocol", (Object)this.protocolAsString()).add("RemoteId", (Object)this.remoteId()).add("SenderControlPort", (Object)this.senderControlPort()).add("SmoothingLatency", (Object)this.smoothingLatency()).add("StreamId", (Object)this.streamId()).add("VpcInterfaceAttachment", (Object)this.vpcInterfaceAttachment()).add("OutputStatus", (Object)this.outputStatusAsString()).add("NdiSpeedHqQuality", (Object)this.ndiSpeedHqQuality()).add("NdiProgramName", (Object)this.ndiProgramName()).add("OutputTags", this.hasOutputTags() ? this.outputTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrAllowList": {
                return Optional.ofNullable(clazz.cast(this.cidrAllowList()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "MaxLatency": {
                return Optional.ofNullable(clazz.cast(this.maxLatency()));
            }
            case "MediaStreamOutputConfigurations": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamOutputConfigurations()));
            }
            case "MinLatency": {
                return Optional.ofNullable(clazz.cast(this.minLatency()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "RemoteId": {
                return Optional.ofNullable(clazz.cast(this.remoteId()));
            }
            case "SenderControlPort": {
                return Optional.ofNullable(clazz.cast(this.senderControlPort()));
            }
            case "SmoothingLatency": {
                return Optional.ofNullable(clazz.cast(this.smoothingLatency()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "VpcInterfaceAttachment": {
                return Optional.ofNullable(clazz.cast(this.vpcInterfaceAttachment()));
            }
            case "OutputStatus": {
                return Optional.ofNullable(clazz.cast(this.outputStatusAsString()));
            }
            case "NdiSpeedHqQuality": {
                return Optional.ofNullable(clazz.cast(this.ndiSpeedHqQuality()));
            }
            case "NdiProgramName": {
                return Optional.ofNullable(clazz.cast(this.ndiProgramName()));
            }
            case "OutputTags": {
                return Optional.ofNullable(clazz.cast(this.outputTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cidrAllowList", CIDR_ALLOW_LIST_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("encryption", ENCRYPTION_FIELD);
        map.put("maxLatency", MAX_LATENCY_FIELD);
        map.put("mediaStreamOutputConfigurations", MEDIA_STREAM_OUTPUT_CONFIGURATIONS_FIELD);
        map.put("minLatency", MIN_LATENCY_FIELD);
        map.put("name", NAME_FIELD);
        map.put("port", PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("remoteId", REMOTE_ID_FIELD);
        map.put("senderControlPort", SENDER_CONTROL_PORT_FIELD);
        map.put("smoothingLatency", SMOOTHING_LATENCY_FIELD);
        map.put("streamId", STREAM_ID_FIELD);
        map.put("vpcInterfaceAttachment", VPC_INTERFACE_ATTACHMENT_FIELD);
        map.put("outputStatus", OUTPUT_STATUS_FIELD);
        map.put("ndiSpeedHqQuality", NDI_SPEED_HQ_QUALITY_FIELD);
        map.put("ndiProgramName", NDI_PROGRAM_NAME_FIELD);
        map.put("outputTags", OUTPUT_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddOutputRequest, T> g) {
        return obj -> g.apply((AddOutputRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> cidrAllowList = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String destination;
        private Encryption encryption;
        private Integer maxLatency;
        private List<MediaStreamOutputConfigurationRequest> mediaStreamOutputConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Integer minLatency;
        private String name;
        private Integer port;
        private String protocol;
        private String remoteId;
        private Integer senderControlPort;
        private Integer smoothingLatency;
        private String streamId;
        private VpcInterfaceAttachment vpcInterfaceAttachment;
        private String outputStatus;
        private Integer ndiSpeedHqQuality;
        private String ndiProgramName;
        private Map<String, String> outputTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddOutputRequest model) {
            this.cidrAllowList(model.cidrAllowList);
            this.description(model.description);
            this.destination(model.destination);
            this.encryption(model.encryption);
            this.maxLatency(model.maxLatency);
            this.mediaStreamOutputConfigurations(model.mediaStreamOutputConfigurations);
            this.minLatency(model.minLatency);
            this.name(model.name);
            this.port(model.port);
            this.protocol(model.protocol);
            this.remoteId(model.remoteId);
            this.senderControlPort(model.senderControlPort);
            this.smoothingLatency(model.smoothingLatency);
            this.streamId(model.streamId);
            this.vpcInterfaceAttachment(model.vpcInterfaceAttachment);
            this.outputStatus(model.outputStatus);
            this.ndiSpeedHqQuality(model.ndiSpeedHqQuality);
            this.ndiProgramName(model.ndiProgramName);
            this.outputTags(model.outputTags);
        }

        public final Collection<String> getCidrAllowList() {
            if (this.cidrAllowList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrAllowList;
        }

        public final void setCidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOfStringCopier.copy(cidrAllowList);
        }

        @Override
        public final Builder cidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOfStringCopier.copy(cidrAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrAllowList(String ... cidrAllowList) {
            this.cidrAllowList(Arrays.asList(cidrAllowList));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final Encryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final Integer getMaxLatency() {
            return this.maxLatency;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final List<MediaStreamOutputConfigurationRequest.Builder> getMediaStreamOutputConfigurations() {
            List<MediaStreamOutputConfigurationRequest.Builder> result = ___listOfMediaStreamOutputConfigurationRequestCopier.copyToBuilder(this.mediaStreamOutputConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaStreamOutputConfigurations(Collection<MediaStreamOutputConfigurationRequest.BuilderImpl> mediaStreamOutputConfigurations) {
            this.mediaStreamOutputConfigurations = ___listOfMediaStreamOutputConfigurationRequestCopier.copyFromBuilder(mediaStreamOutputConfigurations);
        }

        @Override
        public final Builder mediaStreamOutputConfigurations(Collection<MediaStreamOutputConfigurationRequest> mediaStreamOutputConfigurations) {
            this.mediaStreamOutputConfigurations = ___listOfMediaStreamOutputConfigurationRequestCopier.copy(mediaStreamOutputConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreamOutputConfigurations(MediaStreamOutputConfigurationRequest ... mediaStreamOutputConfigurations) {
            this.mediaStreamOutputConfigurations(Arrays.asList(mediaStreamOutputConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreamOutputConfigurations(Consumer<MediaStreamOutputConfigurationRequest.Builder> ... mediaStreamOutputConfigurations) {
            this.mediaStreamOutputConfigurations(Stream.of(mediaStreamOutputConfigurations).map(c -> (MediaStreamOutputConfigurationRequest)((MediaStreamOutputConfigurationRequest.Builder)MediaStreamOutputConfigurationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMinLatency() {
            return this.minLatency;
        }

        public final void setMinLatency(Integer minLatency) {
            this.minLatency = minLatency;
        }

        @Override
        public final Builder minLatency(Integer minLatency) {
            this.minLatency = minLatency;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getRemoteId() {
            return this.remoteId;
        }

        public final void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        @Override
        public final Builder remoteId(String remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public final Integer getSenderControlPort() {
            return this.senderControlPort;
        }

        public final void setSenderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
        }

        @Override
        public final Builder senderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
            return this;
        }

        public final Integer getSmoothingLatency() {
            return this.smoothingLatency;
        }

        public final void setSmoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
        }

        @Override
        public final Builder smoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
            return this;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final VpcInterfaceAttachment.Builder getVpcInterfaceAttachment() {
            return this.vpcInterfaceAttachment != null ? this.vpcInterfaceAttachment.toBuilder() : null;
        }

        public final void setVpcInterfaceAttachment(VpcInterfaceAttachment.BuilderImpl vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment != null ? vpcInterfaceAttachment.build() : null;
        }

        @Override
        public final Builder vpcInterfaceAttachment(VpcInterfaceAttachment vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment;
            return this;
        }

        public final String getOutputStatus() {
            return this.outputStatus;
        }

        public final void setOutputStatus(String outputStatus) {
            this.outputStatus = outputStatus;
        }

        @Override
        public final Builder outputStatus(String outputStatus) {
            this.outputStatus = outputStatus;
            return this;
        }

        @Override
        public final Builder outputStatus(OutputStatus outputStatus) {
            this.outputStatus(outputStatus == null ? null : outputStatus.toString());
            return this;
        }

        public final Integer getNdiSpeedHqQuality() {
            return this.ndiSpeedHqQuality;
        }

        public final void setNdiSpeedHqQuality(Integer ndiSpeedHqQuality) {
            this.ndiSpeedHqQuality = ndiSpeedHqQuality;
        }

        @Override
        public final Builder ndiSpeedHqQuality(Integer ndiSpeedHqQuality) {
            this.ndiSpeedHqQuality = ndiSpeedHqQuality;
            return this;
        }

        public final String getNdiProgramName() {
            return this.ndiProgramName;
        }

        public final void setNdiProgramName(String ndiProgramName) {
            this.ndiProgramName = ndiProgramName;
        }

        @Override
        public final Builder ndiProgramName(String ndiProgramName) {
            this.ndiProgramName = ndiProgramName;
            return this;
        }

        public final Map<String, String> getOutputTags() {
            if (this.outputTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.outputTags;
        }

        public final void setOutputTags(Map<String, String> outputTags) {
            this.outputTags = ___mapOfStringCopier.copy(outputTags);
        }

        @Override
        public final Builder outputTags(Map<String, String> outputTags) {
            this.outputTags = ___mapOfStringCopier.copy(outputTags);
            return this;
        }

        public AddOutputRequest build() {
            return new AddOutputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddOutputRequest> {
        public Builder cidrAllowList(Collection<String> var1);

        public Builder cidrAllowList(String ... var1);

        public Builder description(String var1);

        public Builder destination(String var1);

        public Builder encryption(Encryption var1);

        default public Builder encryption(Consumer<Encryption.Builder> encryption) {
            return this.encryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(encryption)).build());
        }

        public Builder maxLatency(Integer var1);

        public Builder mediaStreamOutputConfigurations(Collection<MediaStreamOutputConfigurationRequest> var1);

        public Builder mediaStreamOutputConfigurations(MediaStreamOutputConfigurationRequest ... var1);

        public Builder mediaStreamOutputConfigurations(Consumer<MediaStreamOutputConfigurationRequest.Builder> ... var1);

        public Builder minLatency(Integer var1);

        public Builder name(String var1);

        public Builder port(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder remoteId(String var1);

        public Builder senderControlPort(Integer var1);

        public Builder smoothingLatency(Integer var1);

        public Builder streamId(String var1);

        public Builder vpcInterfaceAttachment(VpcInterfaceAttachment var1);

        default public Builder vpcInterfaceAttachment(Consumer<VpcInterfaceAttachment.Builder> vpcInterfaceAttachment) {
            return this.vpcInterfaceAttachment((VpcInterfaceAttachment)((VpcInterfaceAttachment.Builder)VpcInterfaceAttachment.builder().applyMutation(vpcInterfaceAttachment)).build());
        }

        public Builder outputStatus(String var1);

        public Builder outputStatus(OutputStatus var1);

        public Builder ndiSpeedHqQuality(Integer var1);

        public Builder ndiProgramName(String var1);

        public Builder outputTags(Map<String, String> var1);
    }
}

