/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.EncodingName;
import software.amazon.awssdk.services.mediaconnect.model.InputConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.___listOfInputConfigurationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaStreamSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaStreamSourceConfiguration> {
    private static final SdkField<String> ENCODING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncodingName").getter(MediaStreamSourceConfiguration.getter(MediaStreamSourceConfiguration::encodingNameAsString)).setter(MediaStreamSourceConfiguration.setter(Builder::encodingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encodingName").build()}).build();
    private static final SdkField<List<InputConfiguration>> INPUT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputConfigurations").getter(MediaStreamSourceConfiguration.getter(MediaStreamSourceConfiguration::inputConfigurations)).setter(MediaStreamSourceConfiguration.setter(Builder::inputConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MEDIA_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaStreamName").getter(MediaStreamSourceConfiguration.getter(MediaStreamSourceConfiguration::mediaStreamName)).setter(MediaStreamSourceConfiguration.setter(Builder::mediaStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCODING_NAME_FIELD, INPUT_CONFIGURATIONS_FIELD, MEDIA_STREAM_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaStreamSourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String encodingName;
    private final List<InputConfiguration> inputConfigurations;
    private final String mediaStreamName;

    private MediaStreamSourceConfiguration(BuilderImpl builder) {
        this.encodingName = builder.encodingName;
        this.inputConfigurations = builder.inputConfigurations;
        this.mediaStreamName = builder.mediaStreamName;
    }

    public final EncodingName encodingName() {
        return EncodingName.fromValue(this.encodingName);
    }

    public final String encodingNameAsString() {
        return this.encodingName;
    }

    public final boolean hasInputConfigurations() {
        return this.inputConfigurations != null && !(this.inputConfigurations instanceof SdkAutoConstructList);
    }

    public final List<InputConfiguration> inputConfigurations() {
        return this.inputConfigurations;
    }

    public final String mediaStreamName() {
        return this.mediaStreamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputConfigurations() ? this.inputConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStreamName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamSourceConfiguration)) {
            return false;
        }
        MediaStreamSourceConfiguration other = (MediaStreamSourceConfiguration)obj;
        return Objects.equals(this.encodingNameAsString(), other.encodingNameAsString()) && this.hasInputConfigurations() == other.hasInputConfigurations() && Objects.equals(this.inputConfigurations(), other.inputConfigurations()) && Objects.equals(this.mediaStreamName(), other.mediaStreamName());
    }

    public final String toString() {
        return ToString.builder((String)"MediaStreamSourceConfiguration").add("EncodingName", (Object)this.encodingNameAsString()).add("InputConfigurations", this.hasInputConfigurations() ? this.inputConfigurations() : null).add("MediaStreamName", (Object)this.mediaStreamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncodingName": {
                return Optional.ofNullable(clazz.cast(this.encodingNameAsString()));
            }
            case "InputConfigurations": {
                return Optional.ofNullable(clazz.cast(this.inputConfigurations()));
            }
            case "MediaStreamName": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("encodingName", ENCODING_NAME_FIELD);
        map.put("inputConfigurations", INPUT_CONFIGURATIONS_FIELD);
        map.put("mediaStreamName", MEDIA_STREAM_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaStreamSourceConfiguration, T> g) {
        return obj -> g.apply((MediaStreamSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String encodingName;
        private List<InputConfiguration> inputConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String mediaStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaStreamSourceConfiguration model) {
            this.encodingName(model.encodingName);
            this.inputConfigurations(model.inputConfigurations);
            this.mediaStreamName(model.mediaStreamName);
        }

        public final String getEncodingName() {
            return this.encodingName;
        }

        public final void setEncodingName(String encodingName) {
            this.encodingName = encodingName;
        }

        @Override
        public final Builder encodingName(String encodingName) {
            this.encodingName = encodingName;
            return this;
        }

        @Override
        public final Builder encodingName(EncodingName encodingName) {
            this.encodingName(encodingName == null ? null : encodingName.toString());
            return this;
        }

        public final List<InputConfiguration.Builder> getInputConfigurations() {
            List<InputConfiguration.Builder> result = ___listOfInputConfigurationCopier.copyToBuilder(this.inputConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputConfigurations(Collection<InputConfiguration.BuilderImpl> inputConfigurations) {
            this.inputConfigurations = ___listOfInputConfigurationCopier.copyFromBuilder(inputConfigurations);
        }

        @Override
        public final Builder inputConfigurations(Collection<InputConfiguration> inputConfigurations) {
            this.inputConfigurations = ___listOfInputConfigurationCopier.copy(inputConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputConfigurations(InputConfiguration ... inputConfigurations) {
            this.inputConfigurations(Arrays.asList(inputConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputConfigurations(Consumer<InputConfiguration.Builder> ... inputConfigurations) {
            this.inputConfigurations(Stream.of(inputConfigurations).map(c -> (InputConfiguration)((InputConfiguration.Builder)InputConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMediaStreamName() {
            return this.mediaStreamName;
        }

        public final void setMediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
        }

        @Override
        public final Builder mediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
            return this;
        }

        public MediaStreamSourceConfiguration build() {
            return new MediaStreamSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaStreamSourceConfiguration> {
        public Builder encodingName(String var1);

        public Builder encodingName(EncodingName var1);

        public Builder inputConfigurations(Collection<InputConfiguration> var1);

        public Builder inputConfigurations(InputConfiguration ... var1);

        public Builder inputConfigurations(Consumer<InputConfiguration.Builder> ... var1);

        public Builder mediaStreamName(String var1);
    }
}

